/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultHighlightUtil {
    @Nullable
    public static HighlightInfo checkBadCharacter(@NotNull PsiElement element2) {
        ASTNode node2;
        if (element2 == null) {
            DefaultHighlightUtil.$$$reportNull$$$0(0);
        }
        if ((node2 = element2.getNode()) != null && node2.getElementType() == TokenType.BAD_CHARACTER) {
            char c = element2.textToCharArray()[0];
            boolean printable = StringUtil.isPrintableUnicode((char)c) && !Character.isSpaceChar(c);
            @NlsSafe String hex = String.format("U+%04X", c);
            String text2 = AnalysisBundle.message((String)"text.illegal.character", (Object[])new Object[]{printable ? c + " (" + hex + ")" : hex});
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element2).descriptionAndTooltip(text2).create();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/DefaultHighlightUtil", "checkBadCharacter"));
    }
}

