/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.emmet;

import com.intellij.DynamicBundle;
import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEmmetConfigurable
implements SearchableConfigurable,
Disposable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JBCheckBox myEnableEmmetJBCheckBox;
    private JBCheckBox myEnablePreviewJBCheckBox;
    private JPanel myFiltersListPanel;
    private JBCheckBox myEnableHrefAutodetectJBCheckBox;
    private JBCheckBox myAddEditPointAtTheEndOfTemplateJBCheckBox;
    private JBTextField myBemElementSeparatorTextField;
    private JBTextField myBemModifierSeparatorTextField;
    private JBTextField myBemShortElementPrefixTextField;
    private JPanel myBemPanel;
    private Map<String, JBCheckBox> myFilterCheckboxes;

    public XmlEmmetConfigurable() {
        this.$$$setupUI$$$();
        this.myFilterCheckboxes = new HashMap<String, JBCheckBox>();
        this.myEnableEmmetJBCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected2 = XmlEmmetConfigurable.this.myEnableEmmetJBCheckBox.isSelected();
                XmlEmmetConfigurable.this.myEnablePreviewJBCheckBox.setEnabled(selected2);
                XmlEmmetConfigurable.this.myFiltersListPanel.setEnabled(selected2);
                XmlEmmetConfigurable.this.myEnableHrefAutodetectJBCheckBox.setEnabled(selected2);
                XmlEmmetConfigurable.this.myAddEditPointAtTheEndOfTemplateJBCheckBox.setEnabled(selected2);
                UIUtil.setEnabled((Component)XmlEmmetConfigurable.this.myBemPanel, (boolean)selected2, (boolean)true);
                for (JBCheckBox checkBox2 : XmlEmmetConfigurable.this.myFilterCheckboxes.values()) {
                    checkBox2.setEnabled(selected2);
                }
            }
        });
        this.myFiltersListPanel.setBorder(IdeBorderFactory.createTitledBorder((String)XmlBundle.message((String)"emmet.filters.enabled.by.default", (Object[])new Object[0])));
        this.myBemPanel.setBorder(IdeBorderFactory.createTitledBorder((String)XmlBundle.message((String)"emmet.bem.title", (Object[])new Object[0])));
        this.createFiltersCheckboxes();
    }

    public void createFiltersCheckboxes() {
        List<ZenCodingFilter> filters = ZenCodingFilter.getInstances();
        GridBagLayout layoutManager = new GridBagLayout();
        GridBagConstraints constraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        this.myFiltersListPanel.setLayout(layoutManager);
        int added2 = 0;
        for (ZenCodingFilter filter : filters) {
            if (this.myFilterCheckboxes.containsKey(filter.getSuffix())) continue;
            JBCheckBox checkBox2 = new JBCheckBox(filter.getDisplayName());
            this.myFilterCheckboxes.put(filter.getSuffix(), checkBox2);
            constraints2.gridy = added2++;
            this.myFiltersListPanel.add((Component)checkBox2, constraints2);
        }
        this.myFiltersListPanel.revalidate();
    }

    public void dispose() {
        this.myFilterCheckboxes.clear();
        this.myFilterCheckboxes = null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        return emmetOptions.isEmmetEnabled() != this.myEnableEmmetJBCheckBox.isSelected() || emmetOptions.isPreviewEnabled() != this.myEnablePreviewJBCheckBox.isSelected() || emmetOptions.isHrefAutoDetectEnabled() != this.myEnableHrefAutodetectJBCheckBox.isSelected() || emmetOptions.isAddEditPointAtTheEndOfTemplate() != this.myAddEditPointAtTheEndOfTemplateJBCheckBox.isSelected() || !emmetOptions.getFiltersEnabledByDefault().equals(this.enabledFilters()) || !emmetOptions.getBemElementSeparator().equals(this.myBemElementSeparatorTextField.getText()) || !emmetOptions.getBemModifierSeparator().equals(this.myBemModifierSeparatorTextField.getText()) || !emmetOptions.getBemShortElementPrefix().equals(this.myBemShortElementPrefixTextField.getText());
    }

    public void apply() throws ConfigurationException {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        emmetOptions.setEmmetEnabled(this.myEnableEmmetJBCheckBox.isSelected());
        emmetOptions.setPreviewEnabled(this.myEnablePreviewJBCheckBox.isSelected());
        emmetOptions.setHrefAutoDetectEnabled(this.myEnableHrefAutodetectJBCheckBox.isSelected());
        emmetOptions.setAddEditPointAtTheEndOfTemplate(this.myAddEditPointAtTheEndOfTemplateJBCheckBox.isSelected());
        emmetOptions.setFiltersEnabledByDefault(this.enabledFilters());
        emmetOptions.setBemElementSeparator(this.myBemElementSeparatorTextField.getText());
        emmetOptions.setBemModifierSeparator(this.myBemModifierSeparatorTextField.getText());
        emmetOptions.setBemShortElementPrefix(this.myBemShortElementPrefixTextField.getText());
    }

    public void reset() {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        this.myEnableEmmetJBCheckBox.setSelected(emmetOptions.isEmmetEnabled());
        this.myEnablePreviewJBCheckBox.setEnabled(emmetOptions.isEmmetEnabled());
        this.myEnablePreviewJBCheckBox.setSelected(emmetOptions.isPreviewEnabled());
        this.myEnableHrefAutodetectJBCheckBox.setEnabled(emmetOptions.isEmmetEnabled());
        this.myEnableHrefAutodetectJBCheckBox.setSelected(emmetOptions.isHrefAutoDetectEnabled());
        this.myAddEditPointAtTheEndOfTemplateJBCheckBox.setEnabled(emmetOptions.isEmmetEnabled());
        this.myAddEditPointAtTheEndOfTemplateJBCheckBox.setSelected(emmetOptions.isAddEditPointAtTheEndOfTemplate());
        this.myBemElementSeparatorTextField.setText(emmetOptions.getBemElementSeparator());
        this.myBemModifierSeparatorTextField.setText(emmetOptions.getBemModifierSeparator());
        this.myBemShortElementPrefixTextField.setText(emmetOptions.getBemShortElementPrefix());
        Set<String> enabledByDefault = emmetOptions.getFiltersEnabledByDefault();
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            String filterSuffix = filter.getSuffix();
            JBCheckBox checkBox2 = this.myFilterCheckboxes.get(filterSuffix);
            if (checkBox2 == null) continue;
            checkBox2.setEnabled(emmetOptions.isEmmetEnabled());
            checkBox2.setSelected(enabledByDefault.contains(filterSuffix));
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    private Set<String> enabledFilters() {
        HashSet<String> result2 = new HashSet<String>();
        for (Map.Entry<String, JBCheckBox> checkbox : this.myFilterCheckboxes.entrySet()) {
            if (!checkbox.getValue().isSelected()) continue;
            result2.add(checkbox.getKey());
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            XmlEmmetConfigurable.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nls
    public String getDisplayName() {
        return XmlBundle.message((String)"configurable.XmlEmmetConfigurable.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return this.getId();
    }

    @NotNull
    public String getId() {
        return "reference.idesettings.emmet.xml";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/XmlEmmetConfigurable", "enabledFilters"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel3;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableEmmetJBCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/XmlBundle", XmlEmmetConfigurable.class).getString("emmet.enable.label"));
        jPanel4.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myEnablePreviewJBCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/XmlBundle", XmlEmmetConfigurable.class).getString("emmet.enable.preview"));
        jPanel4.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myFiltersListPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(5, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myEnableHrefAutodetectJBCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/XmlBundle", XmlEmmetConfigurable.class).getString("emmet.href.autodetect"));
        jPanel4.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myAddEditPointAtTheEndOfTemplateJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/XmlBundle", XmlEmmetConfigurable.class).getString("emmet.add.edit.point.at.the.end.of.template"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myBemPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/XmlBundle", XmlEmmetConfigurable.class).getString("xml.options.border.title.bem"), (int)0, (int)0, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/XmlBundle", XmlEmmetConfigurable.class).getString("emmet.bem.class.name.element.separator.label"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/XmlBundle", XmlEmmetConfigurable.class).getString("emmet.bem.class.name.modifier.separator.label"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/XmlBundle", XmlEmmetConfigurable.class).getString("emmet.bem.short.element.prefix.label"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBemElementSeparatorTextField = jBTextField3 = new JBTextField();
        jPanel2.add((Component)jBTextField3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(50, -1), null));
        this.myBemModifierSeparatorTextField = jBTextField2 = new JBTextField();
        jPanel2.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(50, -1), null));
        this.myBemShortElementPrefixTextField = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(50, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField3);
        jBLabel2.setLabelFor((Component)jBTextField2);
        jBLabel3.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

