/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.AbstractFontOptionsPanel;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.editor.fonts.FontFamilyCombo;
import com.intellij.application.options.editor.fonts.FontWeightCombo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.ui.AbstractFontCombo;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEditorFontOptionsPanel
extends AbstractFontOptionsPanel {
    private static final int FONT_WEIGHT_COMBO_WIDTH = 250;
    private final EditorColorsScheme myScheme;
    private final FontPreferences myDefaultPreferences;
    private FontWeightCombo myRegularWeightCombo;
    private FontWeightCombo myBoldWeightCombo;
    private ActionLink myRestoreLabel;

    protected AppEditorFontOptionsPanel(EditorColorsScheme scheme2) {
        this.myScheme = scheme2;
        this.myDefaultPreferences = new FontPreferencesImpl();
        AppEditorFontOptions.initDefaults((ModifiableFontPreferences)this.myDefaultPreferences);
        this.updateOptionsList();
    }

    @Override
    protected JComponent createControls() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = JBUI.emptyInsets();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        topPanel.add((Component)this.createFontSettingsPanel(), c);
        ++c.gridy;
        c.insets = JBUI.insets((int)12, (int)5, (int)0, (int)0);
        this.myRestoreLabel = this.createRestoreLabel();
        topPanel.add((Component)this.myRestoreLabel, c);
        c.fill = 2;
        ++c.gridy;
        c.insets = JBUI.insets((int)12, (int)0);
        topPanel.add((Component)this.createTypographySettingsPanel(), c);
        this.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void fontChanged() {
                if (AppEditorFontOptionsPanel.this.myRegularWeightCombo != null) {
                    AppEditorFontOptionsPanel.this.myRegularWeightCombo.update(AppEditorFontOptionsPanel.this.getFontPreferences());
                }
                if (AppEditorFontOptionsPanel.this.myBoldWeightCombo != null) {
                    AppEditorFontOptionsPanel.this.myBoldWeightCombo.update(AppEditorFontOptionsPanel.this.getFontPreferences());
                }
                AppEditorFontOptionsPanel.this.updateRestoreButtonState();
            }
        });
        return topPanel;
    }

    private JPanel createTypographySettingsPanel() {
        JPanel typographyPanel = new JPanel(new BorderLayout());
        JPanel expansionPanel = new JPanel(new BorderLayout());
        expansionPanel.setBorder((Border)JBUI.Borders.empty());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.editor.font.typography.settings", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.emptyInsets()));
        expansionPanel.add((Component)titlePanel, "Center");
        final JLabel arrowLabel = new JLabel(AllIcons.General.ArrowRight);
        arrowLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)10, (int)5));
        expansionPanel.add((Component)arrowLabel, "West");
        typographyPanel.add((Component)expansionPanel, "North");
        final JPanel internalPanel = new JPanel(new GridBagLayout());
        internalPanel.setBorder((Border)JBUI.Borders.empty());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = AppEditorFontOptionsPanel.getInsets(0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        if (AppEditorFontOptionsPanel.isAdvancedFontFamiliesUI()) {
            internalPanel.add((Component)new JLabel(ApplicationBundle.message((String)"settings.editor.font.main.weight", (Object[])new Object[0])), c);
            c.gridx = 1;
            c.insets = JBUI.insets((int)0, (int)5, (int)0, (int)0);
            this.myRegularWeightCombo = new MyRegularFontWeightCombo();
            AppEditorFontOptionsPanel.fixComboWidth(this.myRegularWeightCombo, JBUI.scale((int)250));
            this.myRegularWeightCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppEditorFontOptionsPanel.this.changeFontPreferences(preferences -> {
                        String newSubFamily = AppEditorFontOptionsPanel.this.myRegularWeightCombo.getSelectedSubFamily();
                        if (!Objects.equals(preferences.getRegularSubFamily(), newSubFamily)) {
                            preferences.setBoldSubFamily(null);
                        }
                        preferences.setRegularSubFamily(newSubFamily);
                    });
                }
            });
            internalPanel.add((Component)((Object)this.myRegularWeightCombo), c);
            ++c.gridy;
            c.gridx = 0;
            internalPanel.add((Component)new JLabel(ApplicationBundle.message((String)"settings.editor.font.bold.weight", (Object[])new Object[0])), c);
            c.gridx = 1;
            c.insets = AppEditorFontOptionsPanel.getInsets(0, 0);
            this.myBoldWeightCombo = new MyBoldFontWeightCombo();
            this.myBoldWeightCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppEditorFontOptionsPanel.this.changeFontPreferences(preferences -> preferences.setBoldSubFamily(AppEditorFontOptionsPanel.this.myBoldWeightCombo.getSelectedSubFamily()));
                }
            });
            AppEditorFontOptionsPanel.fixComboWidth(this.myBoldWeightCombo, JBUI.scale((int)250));
            internalPanel.add((Component)((Object)this.myBoldWeightCombo), c);
            ++c.gridy;
            JLabel boldHintLabel = new JLabel(ApplicationBundle.message((String)"settings.editor.font.bold.weight.hint", (Object[])new Object[0]));
            boldHintLabel.setFont((Font)JBUI.Fonts.smallFont());
            boldHintLabel.setForeground(UIUtil.getContextHelpForeground());
            internalPanel.add((Component)boldHintLabel, c);
            ++c.gridy;
        }
        c.gridx = 0;
        this.createSecondaryFontComboAndLabel(internalPanel, c);
        internalPanel.setVisible(false);
        typographyPanel.add((Component)internalPanel, "Center");
        arrowLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                internalPanel.setVisible(!internalPanel.isVisible());
                arrowLabel.setIcon(internalPanel.isVisible() ? AllIcons.General.ArrowDown : AllIcons.General.ArrowRight);
            }
        });
        return typographyPanel;
    }

    private static void fixComboWidth(@NotNull FontWeightCombo combo, int width) {
        if (combo == null) {
            AppEditorFontOptionsPanel.$$$reportNull$$$0(0);
        }
        combo.setMinimumSize(new Dimension(width, 0));
        combo.setMinimumSize(new Dimension(width, Integer.MAX_VALUE));
        combo.setPreferredSize(new Dimension(width, combo.getPreferredSize().height));
    }

    void restoreDefaults() {
        AppEditorFontOptions.initDefaults((ModifiableFontPreferences)this.getFontPreferences());
        this.updateOnChangedFont();
    }

    @NotNull
    private ActionLink createRestoreLabel() {
        return new ActionLink(ApplicationBundle.message((String)"settings.editor.font.restored.defaults", (Object[])new Object[0]), e -> this.restoreDefaults());
    }

    public void updateOnChangedFont() {
        this.updateOptionsList();
        this.fireFontChanged();
    }

    private void updateRestoreButtonState() {
        this.myRestoreLabel.setEnabled(!this.myDefaultPreferences.equals(this.getFontPreferences()));
    }

    @Override
    protected boolean isReadOnly() {
        return false;
    }

    @Override
    protected boolean isDelegating() {
        return false;
    }

    @Override
    @NotNull
    protected FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myScheme.getFontPreferences();
        if (fontPreferences == null) {
            AppEditorFontOptionsPanel.$$$reportNull$$$0(1);
        }
        return fontPreferences;
    }

    private void changeFontPreferences(Consumer<ModifiableFontPreferences> consumer) {
        FontPreferences preferences = this.getFontPreferences();
        assert (preferences instanceof ModifiableFontPreferences);
        consumer.accept((ModifiableFontPreferences)preferences);
        this.fireFontChanged();
    }

    @Override
    protected void setFontSize(int fontSize) {
        this.myScheme.setEditorFontSize(fontSize);
    }

    @Override
    protected float getLineSpacing() {
        return this.myScheme.getLineSpacing();
    }

    @Override
    protected void setCurrentLineSpacing(float lineSpacing) {
        this.myScheme.setLineSpacing(lineSpacing);
    }

    @Override
    protected AbstractFontCombo<?> createPrimaryFontCombo() {
        if (AppEditorFontOptionsPanel.isAdvancedFontFamiliesUI()) {
            return new FontFamilyCombo(true);
        }
        return super.createPrimaryFontCombo();
    }

    @Override
    protected AbstractFontCombo<?> createSecondaryFontCombo() {
        if (AppEditorFontOptionsPanel.isAdvancedFontFamiliesUI()) {
            return new FontFamilyCombo(false);
        }
        return super.createSecondaryFontCombo();
    }

    private static boolean isAdvancedFontFamiliesUI() {
        return AppEditorFontOptions.NEW_FONT_SELECTOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/editor/fonts/AppEditorFontOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/editor/fonts/AppEditorFontOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixComboWidth";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyBoldFontWeightCombo
    extends FontWeightCombo {
        MyBoldFontWeightCombo() {
            super(true);
        }

        @Override
        @Nullable
        String getSubFamily(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                MyBoldFontWeightCombo.$$$reportNull$$$0(0);
            }
            return preferences.getBoldSubFamily();
        }

        @Override
        @NotNull
        String getRecommendedSubFamily(@NotNull String family) {
            if (family == null) {
                MyBoldFontWeightCombo.$$$reportNull$$$0(1);
            }
            String string = FontFamilyService.getRecommendedBoldSubFamily(family, (String)ObjectUtils.notNull((Object)AppEditorFontOptionsPanel.this.myRegularWeightCombo.getSelectedSubFamily(), (Object)FontFamilyService.getRecommendedSubFamily(family)));
            if (string == null) {
                MyBoldFontWeightCombo.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferences";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "family";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/editor/fonts/AppEditorFontOptionsPanel$MyBoldFontWeightCombo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/editor/fonts/AppEditorFontOptionsPanel$MyBoldFontWeightCombo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecommendedSubFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubFamily";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecommendedSubFamily";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyRegularFontWeightCombo
    extends FontWeightCombo {
        MyRegularFontWeightCombo() {
            super(false);
        }

        @Override
        @Nullable
        String getSubFamily(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                MyRegularFontWeightCombo.$$$reportNull$$$0(0);
            }
            return preferences.getRegularSubFamily();
        }

        @Override
        @NotNull
        String getRecommendedSubFamily(@NotNull String family) {
            if (family == null) {
                MyRegularFontWeightCombo.$$$reportNull$$$0(1);
            }
            String string = FontFamilyService.getRecommendedSubFamily(family);
            if (string == null) {
                MyRegularFontWeightCombo.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferences";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "family";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/editor/fonts/AppEditorFontOptionsPanel$MyRegularFontWeightCombo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/editor/fonts/AppEditorFontOptionsPanel$MyRegularFontWeightCombo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecommendedSubFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubFamily";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecommendedSubFamily";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

