/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.cache;

import com.intellij.application.options.codeStyle.cache.CodeStyleCachedValueProvider;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleCachingServiceImpl
implements CodeStyleCachingService,
Disposable {
    public static final int MAX_CACHE_SIZE = 100;
    private static final Key<CodeStyleCachedValueProvider> PROVIDER_KEY = Key.create((String)"code.style.cached.value.provider");
    private final Map<String, FileData> myFileDataCache = new HashMap<String, FileData>();
    private final Object CACHE_LOCK = new Object();
    private final PriorityQueue<FileData> myRemoveQueue = new PriorityQueue<FileData>(100, Comparator.comparingLong(fileData -> fileData.lastRefTimeStamp));

    public CodeStyleCachingServiceImpl() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                CodeStyleCachingServiceImpl.this.clearCache();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleCachingServiceImpl.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public CodeStyleSettings tryGetSettings(@NotNull PsiFile file2) {
        CodeStyleCachedValueProvider provider2;
        if (file2 == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(0);
        }
        return (provider2 = this.getOrCreateCachedValueProvider(file2)) != null ? provider2.tryGetSettings() : null;
    }

    public void scheduleWhenSettingsComputed(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        CodeStyleCachedValueProvider provider2;
        if (file2 == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(2);
        }
        if ((provider2 = this.getOrCreateCachedValueProvider(file2)) != null) {
            provider2.scheduleWhenComputed(runnable2);
        } else {
            runnable2.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CodeStyleCachedValueProvider getOrCreateCachedValueProvider(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(3);
        }
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            if (virtualFile2 != null) {
                FileData fileData = this.getOrCreateFileData(CodeStyleCachingServiceImpl.getFileKey(virtualFile2));
                CodeStyleCachedValueProvider provider2 = (CodeStyleCachedValueProvider)fileData.getUserData(PROVIDER_KEY);
                if (provider2 == null || provider2.isExpired()) {
                    provider2 = new CodeStyleCachedValueProvider(file2);
                    fileData.putUserData(PROVIDER_KEY, provider2);
                }
                return provider2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.myFileDataCache.values().forEach(fileData -> ObjectUtils.consumeIfNotNull((Object)((CodeStyleCachedValueProvider)fileData.getUserData(PROVIDER_KEY)), provider2 -> provider2.cancelComputation()));
            this.myFileDataCache.clear();
            this.myRemoveQueue.clear();
        }
    }

    @Nullable
    public UserDataHolder getDataHolder(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(4);
        }
        return this.getOrCreateFileData(CodeStyleCachingServiceImpl.getFileKey(virtualFile2));
    }

    @NotNull
    private synchronized FileData getOrCreateFileData(@NotNull String path2) {
        FileData fileData;
        if (path2 == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(5);
        }
        if (this.myFileDataCache.containsKey(path2)) {
            FileData fileData2 = this.myFileDataCache.get(path2);
            fileData2.update();
            FileData fileData3 = fileData2;
            if (fileData3 == null) {
                CodeStyleCachingServiceImpl.$$$reportNull$$$0(6);
            }
            return fileData3;
        }
        FileData newData = new FileData();
        if (this.myFileDataCache.size() >= 100 && (fileData = this.myRemoveQueue.poll()) != null) {
            this.myFileDataCache.values().remove((Object)fileData);
        }
        this.myFileDataCache.put(path2, newData);
        this.myRemoveQueue.add(newData);
        FileData fileData4 = newData;
        if (fileData4 == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(7);
        }
        return fileData4;
    }

    @NotNull
    private static String getFileKey(VirtualFile file2) {
        String string = file2.getUrl();
        if (string == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void dispose() {
        this.clearCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFileData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryGetSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWhenSettingsComputed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCachedValueProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDataHolder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFileData";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FileData
    extends UserDataHolderBase {
        private long lastRefTimeStamp;

        private FileData() {
            this.update();
        }

        void update() {
            this.lastRefTimeStamp = System.currentTimeMillis();
        }
    }
}

