/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.GlobalVariablesHolder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalVariablesHolder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandler$Companion$WhenMappings;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandlerKt;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import java.awt.Component;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/javascript/debugger/console/JavaScriptDebuggerConsoleExecuteActionHandler;", "Lcom/intellij/execution/console/BaseConsoleExecuteActionHandler;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "consolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/javascript/debugger/console/ConsolePrinter;)V", "getConsolePrinter", "()Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "globalVariables", "Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "getGlobalVariables", "()Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "globalVariables$delegate", "Lkotlin/Lazy;", "localVariables", "Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "getLocalVariables", "()Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "execute", "", "text", "", "console", "Lcom/intellij/execution/console/LanguageConsoleView;", "isEmptyCommandExecutionAllowed", "", "runExecuteAction", "consoleView", "Companion", "intellij.javascript.debugger"})
public final class JavaScriptDebuggerConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler {
    @NotNull
    private final LocalVariablesHolder localVariables;
    @NotNull
    private final Lazy globalVariables$delegate;
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private static final Key<Object> STRING_KEY;
    @NotNull
    private static final Key<Object> NUMBER_KEY;
    @NotNull
    private static final Key<Object> KEYWORD_KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final LocalVariablesHolder getLocalVariables() {
        return this.localVariables;
    }

    @NotNull
    public final GlobalVariablesHolder getGlobalVariables() {
        Lazy lazy = this.globalVariables$delegate;
        JavaScriptDebuggerConsoleExecuteActionHandler javaScriptDebuggerConsoleExecuteActionHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GlobalVariablesHolder)lazy.getValue();
    }

    public boolean isEmptyCommandExecutionAllowed() {
        return false;
    }

    public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        if (!(consoleView instanceof WebConsoleView)) {
            super.runExecuteAction(consoleView);
            return;
        }
        this.beforeExecution(consoleView);
        String text = ((WebConsoleView)consoleView).prepareExecuteAction(true, true);
        UndoManager undoManager = UndoManager.getInstance((Project)consoleView.getProject());
        if (undoManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
        }
        UndoManagerImpl undoManagerImpl = (UndoManagerImpl)undoManager;
        DocumentReferenceManager documentReferenceManager = DocumentReferenceManager.getInstance();
        EditorEx editorEx = consoleView.getCurrentEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"consoleView.getCurrentEditor()");
        undoManagerImpl.invalidateActionsFor(documentReferenceManager.create((Document)editorEx.getDocument()));
        ConsoleHistoryController.addToHistory((LanguageConsoleView)consoleView, (String)text);
        this.execute(text, consoleView);
    }

    public void execute(@NotNull String text, @NotNull LanguageConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)console.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026ontext(console.component)");
        DataContext dataContext2 = dataContext;
        XDebugSession xDebugSession = (XDebugSession)XDebugSession.DATA_KEY.getData(dataContext2);
        if (xDebugSession == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"XDebugSession.DATA_KEY.g\u2026ta(dataContext) ?: return");
        XDebugSession session = xDebugSession;
        XDebugProcess xDebugProcess = session.getDebugProcess();
        if (xDebugProcess == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.JavaScriptDebugProcess<*>");
        }
        JavaScriptDebugProcess debugProcess = (JavaScriptDebugProcess)xDebugProcess;
        XStackFrame xStackFrame = session.getCurrentStackFrame();
        if (!(xStackFrame instanceof CallFrameView)) {
            xStackFrame = null;
        }
        CallFrameView currentCallFrame = (CallFrameView)xStackFrame;
        Runnable successHandler2 = new Runnable(this, console, currentCallFrame, session, debugProcess){
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
            final /* synthetic */ LanguageConsoleView $console;
            final /* synthetic */ CallFrameView $currentCallFrame;
            final /* synthetic */ XDebugSession $session;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;

            public final void run() {
                this.$console.print("\u200c", ConsoleViewContentType.NORMAL_OUTPUT);
                this.this$0.getGlobalVariables().update();
                boolean rebuildViewsRequested = false;
                if (Intrinsics.areEqual((Object)this.$currentCallFrame, (Object)this.$session.getCurrentStackFrame()) && this.$currentCallFrame != null) {
                    CallFrame callFrame = this.$currentCallFrame.getCallFrame();
                    this.this$0.getLocalVariables().setCallFrame(callFrame);
                    Scope localScope = JavaScriptDebuggerConsoleExecuteActionHandlerKt.getLocalScope(callFrame);
                    if (localScope != null) {
                        rebuildViewsRequested = true;
                        localScope.getVariablesHost().clearCaches().onSuccess(new Consumer(this){
                            final /* synthetic */ execute.successHandler.1 this$0;

                            public final void accept(Object it) {
                                this.this$0.this$0.getLocalVariables().update();
                                this.this$0.$debugProcess.getSession().rebuildViews();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }).onError((Consumer)new RejectErrorReporter(this.$session, null, 2, null));
                    }
                }
                if (!rebuildViewsRequested) {
                    this.$debugProcess.getSession().rebuildViews();
                }
            }
            {
                this.this$0 = javaScriptDebuggerConsoleExecuteActionHandler;
                this.$console = languageConsoleView;
                this.$currentCallFrame = callFrameView;
                this.$session = xDebugSession;
                this.$debugProcess = javaScriptDebugProcess;
            }
        };
        Function1<String, Unit> $fun$errorHandler$1 = new Function1<String, Unit>(console){
            final /* synthetic */ LanguageConsoleView $console;

            public final void invoke(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                this.$console.print("\u200c", ConsoleViewContentType.ERROR_OUTPUT);
                this.$console.print(errorMessage, ConsoleViewContentType.ERROR_OUTPUT);
                this.$console.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
            }
            {
                this.$console = languageConsoleView;
                super(1);
            }
        };
        if (console instanceof WebConsoleView) {
            XDebuggerEvaluator.XEvaluationCallback callback2 = new XDebuggerEvaluator.XEvaluationCallback(this, $fun$errorHandler$1, successHandler2, console){
                final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                final /* synthetic */ execute.1 $errorHandler$1;
                final /* synthetic */ Runnable $successHandler;
                final /* synthetic */ LanguageConsoleView $console;

                public void errorOccurred(@NotNull String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                    this.this$0.getConsolePrinter().userInput((Function0<Unit>)((Function0)new Function0<Unit>(this, errorMessage){
                        final /* synthetic */ execute.callback.1 this$0;
                        final /* synthetic */ String $errorMessage;

                        public final void invoke() {
                            this.this$0.$errorHandler$1.invoke(this.$errorMessage);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$errorMessage = string;
                            super(0);
                        }
                    }));
                }

                public void evaluated(@NotNull XValue result2) {
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    this.this$0.getConsolePrinter().userInput((Function0<Unit>)((Function0)new Function0<Unit>(this, result2){
                        final /* synthetic */ execute.callback.1 this$0;
                        final /* synthetic */ XValue $result;

                        public final void invoke() {
                            this.this$0.$successHandler.run();
                            WebConsoleView.printValue$default((WebConsoleView)this.this$0.$console, this.$result, false, 2, null);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = xValue;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = this$0;
                    this.$errorHandler$1 = $captured_local_variable$1;
                    this.$successHandler = $captured_local_variable$2;
                    this.$console = $captured_local_variable$3;
                }
            };
            XDebuggerEvaluator xDebuggerEvaluator = debugProcess.getEvaluator();
            Intrinsics.checkNotNull((Object)xDebuggerEvaluator);
            xDebuggerEvaluator.evaluate(text, callback2, null);
        } else {
            CallFrameView callFrameView = currentCallFrame;
            if (callFrameView == null || (callFrameView = callFrameView.getEvaluateContext()) == null) {
                Vm vm = debugProcess.getActiveOrMainVm();
                Intrinsics.checkNotNull((Object)vm);
                EvaluateContext evaluateContext = vm.getEvaluateContext();
                callFrameView = evaluateContext;
                Intrinsics.checkNotNull((Object)evaluateContext);
            }
            Intrinsics.checkNotNullExpressionValue((Object)EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)callFrameView, (String)text, null, (boolean)true, (Project)session.getProject(), (int)2, null).onSuccess(new Consumer(this, console, debugProcess, text, successHandler2){
                final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                final /* synthetic */ LanguageConsoleView $console;
                final /* synthetic */ JavaScriptDebugProcess $debugProcess;
                final /* synthetic */ String $text;
                final /* synthetic */ Runnable $successHandler;

                public final void accept(EvaluateResult it) {
                    this.this$0.getConsolePrinter().userInput((Function0<Unit>)((Function0)new Function0<Unit>(this, it){
                        final /* synthetic */ execute.2 this$0;
                        final /* synthetic */ EvaluateResult $it;

                        public final void invoke() {
                            if (this.$it.getWasThrown()) {
                                this.this$0.$console.print("\u200c", ConsoleViewContentType.ERROR_OUTPUT);
                                GlobalEvaluator globalEvaluator = this.this$0.$debugProcess.getGlobalEvaluator();
                                Value value = this.$it.getValue();
                                String string = this.this$0.$text;
                                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                                globalEvaluator.printAndStoreValueToInspect(value, string, consoleViewContentType, (ConsoleView)this.this$0.$console);
                                this.this$0.$console.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
                                return;
                            }
                            this.this$0.$successHandler.run();
                            GlobalEvaluator globalEvaluator = this.this$0.$debugProcess.getGlobalEvaluator();
                            Value value = this.$it.getValue();
                            String string = this.this$0.$text;
                            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getValueKey(this.$it.getValue()));
                            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026   getValueKey(it.value))");
                            globalEvaluator.printAndStoreValueToInspect(value, string, consoleViewContentType, (ConsoleView)this.this$0.$console);
                            this.this$0.$console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$it = evaluateResult;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = javaScriptDebuggerConsoleExecuteActionHandler;
                    this.$console = languageConsoleView;
                    this.$debugProcess = javaScriptDebugProcess;
                    this.$text = string;
                    this.$successHandler = runnable;
                }
            }).onError(new Consumer(this, $fun$errorHandler$1){
                final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                final /* synthetic */ execute.1 $errorHandler$1;

                public final void accept(Throwable it) {
                    this.this$0.getConsolePrinter().userInput((Function0<Unit>)((Function0)new Function0<Unit>(this, it){
                        final /* synthetic */ execute.3 this$0;
                        final /* synthetic */ Throwable $it;

                        public final void invoke() {
                            execute.1 v0 = this.this$0.$errorHandler$1;
                            String string = this.$it.getMessage();
                            Intrinsics.checkNotNull((Object)string);
                            v0.invoke(string);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$it = throwable;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = javaScriptDebuggerConsoleExecuteActionHandler;
                    this.$errorHandler$1 = var2_2;
                }
            }), (String)"(currentCallFrame?.evalu\u2026!!)\n          }\n        }");
        }
    }

    @NotNull
    public final ConsolePrinter getConsolePrinter() {
        return this.consolePrinter;
    }

    public JavaScriptDebuggerConsoleExecuteActionHandler(final @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        super(true);
        this.consolePrinter = consolePrinter;
        this.localVariables = new LocalVariablesHolder((DebuggerViewSupport)debugProcess.getDebuggerViewSupport());
        this.globalVariables$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GlobalVariablesHolder>(debugProcess){
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GlobalVariablesHolder invoke() {
                void var1_1;
                GlobalVariablesHolder holder = new GlobalVariablesHolder((DebuggerViewSupport)this.$debugProcess.getDebuggerViewSupport());
                holder.update();
                return var1_1;
            }
            {
                this.$debugProcess = javaScriptDebugProcess;
                super(0);
            }
        }));
        debugProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                this.updateConsoleContext();
            }

            private final void updateConsoleContext() {
                this.getLocalVariables().setCallFrame(null);
                XDebugSession session = debugProcess.getSession();
                ConsoleView consoleView = debugProcess.getJSConsoleView(false);
                if (!(consoleView instanceof LanguageConsoleView)) {
                    consoleView = null;
                }
                LanguageConsoleView languageConsoleView = (LanguageConsoleView)consoleView;
                if (languageConsoleView == null) {
                    return;
                }
                LanguageConsoleView consoleView2 = languageConsoleView;
                XDebugSession xDebugSession = session;
                Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"session");
                XSourcePosition position = xDebugSession.getCurrentPosition();
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction(new Computable(session, consoleView2, position){
                    final /* synthetic */ XDebugSession $session$inlined;
                    final /* synthetic */ LanguageConsoleView $consoleView$inlined;
                    final /* synthetic */ XSourcePosition $position$inlined;
                    {
                        this.$session$inlined = xDebugSession;
                        this.$consoleView$inlined = languageConsoleView;
                        this.$position$inlined = xSourcePosition;
                    }

                    public final T compute() {
                        boolean bl = false;
                        XDebugSession xDebugSession = this.$session$inlined;
                        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"session");
                        Project project = xDebugSession.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"session.project");
                        if (!project.isDisposed()) {
                            PsiFile psiFile = this.$consoleView$inlined.getFile();
                            if (psiFile == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl");
                            }
                            JSExpressionCodeFragmentImpl consolePsiFile = (JSExpressionCodeFragmentImpl)psiFile;
                            if (this.$position$inlined == null || this.$position$inlined.getOffset() < 0) {
                                consolePsiFile.setContext((PsiElement)null);
                            } else {
                                PsiFile contextPsiFile;
                                PsiElement context = null;
                                XDebugSession xDebugSession2 = this.$session$inlined;
                                Intrinsics.checkNotNullExpressionValue((Object)xDebugSession2, (String)"session");
                                PsiFile psiFile2 = contextPsiFile = PsiManager.getInstance((Project)xDebugSession2.getProject()).findFile(this.$position$inlined.getFile());
                                context = psiFile2 != null ? psiFile2.findElementAt(this.$position$inlined.getOffset()) : null;
                                consolePsiFile.setContext(context);
                            }
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }

            public void sessionStopped() {
                this.updateConsoleContext();
            }

            public void sessionResumed() {
                this.updateConsoleContext();
            }

            public void sessionPaused() {
                this.updateConsoleContext();
            }
        });
    }

    static {
        Companion = new Companion(null);
        STRING_KEY = new Key("JS_DEBUG_STRING");
        NUMBER_KEY = new Key("JS_DEBUG_NUMBER");
        KEYWORD_KEY = new Key("JS_DEBUG_KEYWORD");
        ConsoleViewContentType.registerNewConsoleViewType(NUMBER_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        ConsoleViewContentType.registerNewConsoleViewType(STRING_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        ConsoleViewContentType.registerNewConsoleViewType(KEYWORD_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000b\u001a\u001e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001 \f*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00040\u00042\u0006\u0010\r\u001a\u00020\u000eR\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/console/JavaScriptDebuggerConsoleExecuteActionHandler$Companion;", "", "()V", "KEYWORD_KEY", "Lcom/intellij/openapi/util/Key;", "getKEYWORD_KEY", "()Lcom/intellij/openapi/util/Key;", "NUMBER_KEY", "getNUMBER_KEY", "STRING_KEY", "getSTRING_KEY", "getValueKey", "kotlin.jvm.PlatformType", "value", "Lorg/jetbrains/debugger/values/Value;", "intellij.javascript.debugger"})
    public static final class Companion {
        @NotNull
        public final Key<Object> getSTRING_KEY() {
            return STRING_KEY;
        }

        @NotNull
        public final Key<Object> getNUMBER_KEY() {
            return NUMBER_KEY;
        }

        @NotNull
        public final Key<Object> getKEYWORD_KEY() {
            return KEYWORD_KEY;
        }

        public final Key<? extends Object> getValueKey(@NotNull Value value) {
            Key<Object> key;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            switch (JavaScriptDebuggerConsoleExecuteActionHandler$Companion$WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
                case 1: 
                case 2: {
                    key = this.getNUMBER_KEY();
                    break;
                }
                case 3: {
                    key = this.getSTRING_KEY();
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    key = this.getKEYWORD_KEY();
                    break;
                }
                default: {
                    key = ProcessOutputTypes.STDOUT;
                }
            }
            return key;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

