/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class SpecificCaseRule
extends Rule {
    private static final Set<String> phrases = new THashSet(SpecificCaseRule.loadPhrases("/en/specific_case.txt"));
    private static int maxLen;
    private static final Map<String, String> lcToProperSpelling;

    private static List<String> loadPhrases(String path) {
        ArrayList<String> l = new ArrayList<String>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            int parts = line.split(" ").length;
            maxLen = Math.max(parts, maxLen);
            l.add(line.trim());
        }
        return l;
    }

    public SpecificCaseRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.CASING.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"I really like <marker>Harry potter</marker>."), Example.fixed((String)"I really like <marker>Harry Potter</marker>."));
    }

    public final String getId() {
        return "EN_SPECIFIC_CASE";
    }

    public String getDescription() {
        return "Checks upper/lower case spelling of some proper nouns";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 0; i < tokens.length; ++i) {
            ArrayList<String> l = new ArrayList<String>();
            int j = 0;
            while (l.size() < maxLen && i + j < tokens.length) {
                l.add(tokens[i + j].getToken());
                ++j;
                String phrase = String.join((CharSequence)" ", l);
                String lcPhrase = phrase.toLowerCase();
                String properSpelling = lcToProperSpelling.get(lcPhrase);
                if (properSpelling == null || StringTools.isAllUppercase((String)phrase) || phrase.equals(properSpelling) || i > 0 && tokens[i - 1].isSentenceStart() && !StringTools.startsWithUppercase((String)properSpelling)) continue;
                String msg = this.allWordsUppercase(properSpelling) ? "If the term is a proper noun, use initial capitals." : "If the term is a proper noun, use the suggested capitalization.";
                RuleMatch match = new RuleMatch((Rule)this, sentence, tokens[i].getStartPos(), tokens[i + j - 1].getEndPos(), msg, "Proper noun");
                match.setSuggestedReplacement(properSpelling);
                matches.add(match);
            }
        }
        return this.toRuleMatchArray(matches);
    }

    private boolean allWordsUppercase(String s) {
        return Arrays.stream(s.split(" ")).allMatch(StringTools::startsWithUppercase);
    }

    static {
        lcToProperSpelling = new THashMap();
        for (String phrase : phrases) {
            lcToProperSpelling.put(phrase.toLowerCase(), phrase);
        }
    }
}

