/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlDialectCodeStyleProvider;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlDialectSpecificCodeStyleScheme;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/dialects/base/BaseSqlDialectCodeStyleProvider;", "S", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "Lcom/intellij/sql/formatter/SqlDialectCodeStyleProvider;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "settingsClass", "Lkotlin/reflect/KClass;", "dialectDisplayName", "", "(Lcom/intellij/sql/dialects/SqlLanguageDialect;Lkotlin/reflect/KClass;Ljava/lang/String;)V", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getDialectDisplayName", "()Ljava/lang/String;", "getSettingsClass", "()Lkotlin/reflect/KClass;", "createCustomSettings", "settingsContainer", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "intellij.database.dialects.base.core"})
public class BaseSqlDialectCodeStyleProvider<S extends SqlCodeStyleSettings>
implements SqlDialectCodeStyleProvider {
    @NotNull
    private final SqlLanguageDialect dialect;
    @NotNull
    private final KClass<S> settingsClass;
    @Nullable
    private final String dialectDisplayName;

    @NotNull
    public S createCustomSettings(@NotNull CodeStyleSettings settingsContainer) {
        Intrinsics.checkNotNullParameter((Object)settingsContainer, (String)"settingsContainer");
        KFunction kFunction = (KFunction)CollectionsKt.firstOrNull((Iterable)this.getSettingsClass().getConstructors());
        if (kFunction == null) {
            throw (Throwable)new IllegalStateException("Class " + this.getSettingsClass().getQualifiedName() + " has no constructors");
        }
        KFunction constructor = kFunction;
        SqlCodeStyleSettings settingsInstance = (SqlCodeStyleSettings)constructor.call(new Object[]{settingsContainer});
        return (S)settingsInstance;
    }

    @NotNull
    public SqlLanguageDialect getDialect() {
        return this.dialect;
    }

    @NotNull
    public KClass<S> getSettingsClass() {
        return this.settingsClass;
    }

    @Nullable
    public String getDialectDisplayName() {
        return this.dialectDisplayName;
    }

    public BaseSqlDialectCodeStyleProvider(@NotNull SqlLanguageDialect dialect, @NotNull KClass<S> settingsClass, @Nullable String dialectDisplayName) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter(settingsClass, (String)"settingsClass");
        this.dialect = dialect;
        this.settingsClass = settingsClass;
        this.dialectDisplayName = dialectDisplayName;
    }

    public /* synthetic */ BaseSqlDialectCodeStyleProvider(SqlLanguageDialect sqlLanguageDialect, KClass kClass, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(sqlLanguageDialect, kClass, string);
    }

    @Nullable
    public List<SqlDialectSpecificCodeStyleScheme> getDialectSpecificPredefinedStyleSchemes() {
        return SqlDialectCodeStyleProvider.DefaultImpls.getDialectSpecificPredefinedStyleSchemes((SqlDialectCodeStyleProvider)this);
    }

    public int getWeight() {
        return SqlDialectCodeStyleProvider.DefaultImpls.getWeight((SqlDialectCodeStyleProvider)this);
    }
}

