/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.google.common.collect.ImmutableList;
import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.AbstractCodeGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.LinkedPriorityQueue;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.PreOrderComparator;
import com.intellij.database.dialects.base.generator.Scenario;
import com.intellij.database.dialects.base.generator.ScenarioDot;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.ScriptingResultImpl;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a0\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\u000f\u00a8\u0006\u0010"}, d2={"createPreOrderComparator", "Ljava/util/Comparator;", "Lcom/intellij/database/dialects/base/generator/Operation;", "operations", "", "createResult", "Lcom/intellij/database/script/generator/ScriptingResult;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "generateSuccessors", "Lcom/intellij/util/containers/MultiMap;", "", "processOperations", "", "processor", "Lkotlin/Function1;", "intellij.database.dialects.base.core"})
public final class AbstractCodeGeneratorKt {
    @NotNull
    public static final ScriptingResult createResult(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ImmutableList script = ImmutableList.copyOf((Collection)context.getScript());
        context.getScript().clear();
        String stmtDelimiter = (Boolean)context.getOptions().get(ScriptingOptionStatic.USE_SEMICOLON) != false ? ";" : context.getHelper().getStatementDelimiterStr();
        boolean stmtDelimiterOwnsLine = Intrinsics.areEqual((Object)stmtDelimiter, (Object)";") ^ true && context.getHelper().getStatementDelimiterOwnsLine() || Intrinsics.areEqual((Object)stmtDelimiter, (Object)";") && context.getCodeStyle().SCRIPT_STMT_SEMICOLON_WRAP == 1;
        ImmutableList immutableList = script;
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"script");
        return new ScriptingResultImpl((List)immutableList, stmtDelimiter, stmtDelimiterOwnsLine);
    }

    public static final void processOperations(@NotNull ScriptingContext context, @NotNull Set<Operation> operations, @NotNull Function1<? super Operation, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Comparator<Operation> cmp = AbstractCodeGeneratorKt.createPreOrderComparator((Collection<Operation>)operations);
        MultiMap<Operation, Operation> successors = AbstractCodeGeneratorKt.generateSuccessors(operations);
        LinkedPriorityQueue<Operation> queue = new LinkedPriorityQueue<Operation>(cmp);
        Iterable $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation it = (Operation)element$iv;
            boolean bl = false;
            if (it.getIncidence() != 0) continue;
            queue.add(it);
        }
        while (!successors.keySet().isEmpty()) {
            Object v2;
            while (!queue.isEmpty()) {
                Operation op;
                Intrinsics.checkNotNull((Object)queue.poll());
                Collection rev = successors.remove((Object)op);
                if (rev == null) continue;
                processor.invoke((Object)op);
                Iterable $this$forEach$iv2 = rev;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Operation it = (Operation)element$iv;
                    boolean bl = false;
                    Operation operation2 = it;
                    operation2.setIncidence(operation2.getIncidence() + -1);
                    operation2.getIncidence();
                    if (it.getIncidence() != 0) continue;
                    Operation operation3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)operation3, (String)"it");
                    queue.add(operation3);
                }
            }
            if (successors.keySet().isEmpty()) continue;
            Iterable $this$minBy$iv = operations;
            boolean $i$f$minBy = false;
            Iterable $this$minByOrNull$iv$iv = $this$minBy$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv$iv = $this$minByOrNull$iv$iv.iterator();
            if (!iterator$iv$iv.hasNext()) {
                v2 = null;
            } else {
                Object minElem$iv$iv = iterator$iv$iv.next();
                if (!iterator$iv$iv.hasNext()) {
                    v2 = minElem$iv$iv;
                } else {
                    Operation it = (Operation)minElem$iv$iv;
                    boolean bl = false;
                    int minValue$iv$iv = successors.containsKey((Object)it) ? it.getIncidence() : Integer.MAX_VALUE;
                    do {
                        int v$iv$iv;
                        Object e$iv$iv = iterator$iv$iv.next();
                        Operation it2 = (Operation)e$iv$iv;
                        $i$a$-minBy-AbstractCodeGeneratorKt$processOperations$breaker$1 = false;
                        int n = v$iv$iv = successors.containsKey((Object)it2) ? it2.getIncidence() : Integer.MAX_VALUE;
                        if (minValue$iv$iv <= v$iv$iv) continue;
                        minElem$iv$iv = e$iv$iv;
                        minValue$iv$iv = v$iv$iv;
                    } while (iterator$iv$iv.hasNext());
                    v2 = minElem$iv$iv;
                }
            }
            Intrinsics.checkNotNull(v2);
            Operation breaker = v2;
            queue.add(breaker);
            processor.invoke((Object)new Operation(new BaseProducer(context, context, AbstractCodeGenerator.Companion.getERROR()){
                final /* synthetic */ ScriptingContext $context;

                public void produce() {
                    this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)processOperations.produce.1.INSTANCE));
                }
                {
                    this.$context = $captured_local_variable$0;
                    super($super_call_param$1, $super_call_param$2);
                }
            }));
            if (context.getTask().getCategory() != ScriptCategory.CREATE_DEFINITION && context.getTask().getCategory() != ScriptCategory.CREATE_COMPLETE) continue;
            Object object = JBIterable.generate((Object)CollectionsKt.first((Iterable)operations), (Function)processOperations.root.1.INSTANCE).first();
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JBIterable.generate(oper\u2026) { it.parent }.first()!!");
            Operation root2 = (Operation)object;
            AbstractCodeGenerator.Companion.getLOG().warn("Found cycle\n" + ScenarioDot.build$default(new ScenarioDot(new Scenario(root2.getProducer()), null, 2, null), null, 1, null).toString());
        }
    }

    private static final MultiMap<Operation, Operation> generateSuccessors(Set<Operation> operations) {
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.createSet<Operation, Operation>()");
        MultiMap successors = multiMap;
        Iterable $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation op = (Operation)element$iv;
            boolean bl = false;
            Set<Operation> flatPreceders = op.getFlatPreceders();
            successors.getModifiable((Object)op);
            int incidence = 0;
            Iterable $this$forEach$iv2 = flatPreceders;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Operation p = (Operation)element$iv2;
                boolean bl2 = false;
                if (!operations.contains(p)) continue;
                successors.putValue((Object)p, (Object)op);
                ++incidence;
            }
            op.setIncidence(incidence);
        }
        return successors;
    }

    private static final Comparator<Operation> createPreOrderComparator(Collection<Operation> operations) {
        return new PreOrderComparator();
    }

    public static final /* synthetic */ Comparator access$createPreOrderComparator(Collection operations) {
        return AbstractCodeGeneratorKt.createPreOrderComparator(operations);
    }
}

