/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipVmKt;
import org.jetbrains.wip.WipWorkerCommandProcessor;
import org.jetbrains.wip.WipWorkerVm;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;
import org.jetbrains.wip.protocol.serviceworker.ServiceWorkerKt;
import org.jetbrains.wip.protocol.target.AttachedToTargetEventData;
import org.jetbrains.wip.protocol.target.DetachedFromTargetEventData;
import org.jetbrains.wip.protocol.target.ReceivedMessageFromTargetEventData;
import org.jetbrains.wip.protocol.target.TargetKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\nJ\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/wip/WipWorkerManager;", "", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "getVm", "()Lorg/jetbrains/wip/WipVm;", "workers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/wip/WipWorkerVm;", "enableWorkers", "", "hasWorker", "", "workerId", "prepareWorkerForDebugging", "worker", "registerWorkerEvents", "eventMap", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "workerCreated", "workerVm", "workerMessageReceived", "message", "workerTerminated", "id", "intellij.javascript.wip.backend"})
public class WipWorkerManager {
    private final ConcurrentHashMap<String, WipWorkerVm> workers;
    @NotNull
    private final WipVm vm;

    public void enableWorkers() {
        this.vm.getCommandProcessor().send((Request)TargetKt.SetAutoAttach$default(true, true, null, 4, null));
        this.vm.getCommandProcessor().send((Request)ServiceWorkerKt.Enable());
    }

    public final void workerCreated(@NotNull WipWorkerVm workerVm2) {
        Intrinsics.checkNotNullParameter((Object)((Object)workerVm2), (String)"workerVm");
        this.vm.getRegisterVmPrintEvents().invoke((Object)workerVm2);
        String id = workerVm2.getSessionId();
        WipWorkerVm wipWorkerVm = this.workers.remove(id);
        if (wipWorkerVm != null) {
            wipWorkerVm.terminate();
        }
        ((Map)this.workers).put(id, workerVm2);
        this.prepareWorkerForDebugging(workerVm2);
        this.vm.getChildVMs().add(workerVm2);
    }

    private final void prepareWorkerForDebugging(WipWorkerVm worker) {
        WipVmKt.enableConsole(worker.getCommandProcessor());
        worker.getCommandProcessor().send((Request)DebuggerKt.Enable$default(null, 1, null));
        worker.enableWorkers();
        this.vm.getDebugListener().childVmAdded((Vm)worker);
        worker.getCommandProcessor().send((Request)RuntimeKt.RunIfWaitingForDebugger());
    }

    public final void workerTerminated(@NotNull String id) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            WipWorkerVm wipWorkerVm = this.workers.remove(id);
            if (wipWorkerVm == null) break block0;
            WipWorkerVm wipWorkerVm2 = wipWorkerVm;
            boolean bl = false;
            boolean bl2 = false;
            WipWorkerVm it = wipWorkerVm2;
            boolean bl3 = false;
            this.vm.getChildVMs().remove((Object)it);
            it.terminate();
        }
    }

    public final void workerMessageReceived(@NotNull String workerId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)workerId, (String)"workerId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = this.workers.get(workerId);
        if (object == null || (object = object.getCommandProcessor()) == null) {
            return;
        }
        WipWorkerVm processor = object;
        ((WipCommandProcessor)((Object)processor)).processIncomingJson(new JsonReaderEx((CharSequence)message));
    }

    public void registerWorkerEvents(@NotNull EventMap<ProtocolResponseReader> eventMap) {
        Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
        eventMap.add((EventType)AttachedToTargetEventData.TYPE, (Function1)new Function1<AttachedToTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;

            public final void invoke(@NotNull AttachedToTargetEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                WipWorkerCommandProcessor wipWorkerCommandProcessor = new WipWorkerCommandProcessor(it.sessionId(), this.this$0.getVm().getCommandProcessor());
                WipWorkerVm workerVm2 = new WipWorkerVm(it.sessionId(), it.targetInfo().targetId(), it.targetInfo().title(), this.this$0.getVm().getDebugListener(), wipWorkerCommandProcessor, null, 32, null);
                this.this$0.workerCreated(workerVm2);
            }
            {
                this.this$0 = wipWorkerManager;
                super(1);
            }
        });
        eventMap.add((EventType)DetachedFromTargetEventData.TYPE, (Function1)new Function1<DetachedFromTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;

            public final void invoke(@NotNull DetachedFromTargetEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.workerTerminated(it.sessionId());
            }
            {
                this.this$0 = wipWorkerManager;
                super(1);
            }
        });
        eventMap.add((EventType)ReceivedMessageFromTargetEventData.TYPE, (Function1)new Function1<ReceivedMessageFromTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;

            public final void invoke(@NotNull ReceivedMessageFromTargetEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.workerMessageReceived(it.sessionId(), it.message());
            }
            {
                this.this$0 = wipWorkerManager;
                super(1);
            }
        });
    }

    public final boolean hasWorker(@Nullable String workerId) {
        boolean bl;
        block4: {
            if (workerId == null) {
                return false;
            }
            Collection<WipWorkerVm> collection = this.workers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"workers.values");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WipWorkerVm worker = (WipWorkerVm)((Object)element$iv);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)worker.getWorkerId(), (Object)workerId)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    protected final WipVm getVm() {
        return this.vm;
    }

    public WipWorkerManager(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.workers = new ConcurrentHashMap();
    }
}

