/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.concurrency.Semaphore;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.JSDebuggerWipBackendBundle;
import org.jetbrains.wip.WipV8ProfilingHelper;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.heapprofiler.AddHeapSnapshotChunkEventData;
import org.jetbrains.wip.protocol.heapprofiler.HeapProfilerKt;
import org.jetbrains.wip.protocol.heapprofiler.ReportHeapSnapshotProgressEventData;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/wip/WipV8ProfilingHelper;", "", "v8Vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "takeHeapSnapShot", "", "file", "Ljava/io/File;", "intellij.javascript.wip.backend"})
public final class WipV8ProfilingHelper {
    private final WipVm v8Vm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nls
    @Nullable
    public final String takeHeapSnapShot(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Semaphore semaphore = new Semaphore();
        AtomicReference<String> error = new AtomicReference<String>();
        AtomicReference throwableRef = new AtomicReference();
        Closeable closeable = new BufferedOutputStream(new FileOutputStream(file));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedOutputStream output = (BufferedOutputStream)closeable;
            boolean bl3 = false;
            EventMap<ProtocolResponseReader> eventMap = this.v8Vm.getCommandProcessor().getEventMap();
            Function1 chunkHandler2 = (Function1)new Function1<AddHeapSnapshotChunkEventData, Unit>(output){
                final /* synthetic */ BufferedOutputStream $output;

                public final void invoke(@NotNull AddHeapSnapshotChunkEventData it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = it.chunk();
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    this.$output.write(byArray);
                }
                {
                    this.$output = bufferedOutputStream;
                    super(1);
                }
            };
            eventMap.add((EventType)AddHeapSnapshotChunkEventData.TYPE, chunkHandler2);
            Function1 progressHandler2 = takeHeapSnapShot.1.progressHandler.1.INSTANCE;
            eventMap.add((EventType)ReportHeapSnapshotProgressEventData.TYPE, progressHandler2);
            semaphore.down();
            this.v8Vm.getCommandProcessor().send((Request)HeapProfilerKt.TakeHeapSnapshot$default(null, 1, null)).onError(new Consumer(this, semaphore, error, throwableRef){
                final /* synthetic */ WipV8ProfilingHelper this$0;
                final /* synthetic */ Semaphore $semaphore$inlined;
                final /* synthetic */ AtomicReference $error$inlined;
                final /* synthetic */ AtomicReference $throwableRef$inlined;
                {
                    this.this$0 = wipV8ProfilingHelper;
                    this.$semaphore$inlined = semaphore;
                    this.$error$inlined = atomicReference;
                    this.$throwableRef$inlined = atomicReference2;
                }

                public final void accept(Throwable it) {
                    this.$error$inlined.set(JSDebuggerWipBackendBundle.message("error.taking.v8.snapshot.rejected", new Object[0]));
                    this.$throwableRef$inlined.set(it);
                }
            }).onError(new Consumer(this, semaphore, error, throwableRef){
                final /* synthetic */ WipV8ProfilingHelper this$0;
                final /* synthetic */ Semaphore $semaphore$inlined;
                final /* synthetic */ AtomicReference $error$inlined;
                final /* synthetic */ AtomicReference $throwableRef$inlined;
                {
                    this.this$0 = wipV8ProfilingHelper;
                    this.$semaphore$inlined = semaphore;
                    this.$error$inlined = atomicReference;
                    this.$throwableRef$inlined = atomicReference2;
                }

                public final void accept(Throwable it) {
                    this.$throwableRef$inlined.set(it);
                }
            }).onProcessed(new Consumer(eventMap, chunkHandler2, progressHandler2, this, semaphore, error, throwableRef){
                final /* synthetic */ EventMap $eventMap;
                final /* synthetic */ Function1 $chunkHandler;
                final /* synthetic */ Function1 $progressHandler;
                final /* synthetic */ WipV8ProfilingHelper this$0;
                final /* synthetic */ Semaphore $semaphore$inlined;
                final /* synthetic */ AtomicReference $error$inlined;
                final /* synthetic */ AtomicReference $throwableRef$inlined;
                {
                    this.$eventMap = eventMap;
                    this.$chunkHandler = function1;
                    this.$progressHandler = function12;
                    this.this$0 = wipV8ProfilingHelper;
                    this.$semaphore$inlined = semaphore;
                    this.$error$inlined = atomicReference;
                    this.$throwableRef$inlined = atomicReference2;
                }

                public final void accept(Unit it) {
                    this.$eventMap.remove((EventType)AddHeapSnapshotChunkEventData.TYPE, this.$chunkHandler);
                    this.$eventMap.remove((EventType)ReportHeapSnapshotProgressEventData.TYPE, this.$progressHandler);
                    this.$semaphore$inlined.up();
                }
            });
            if (!semaphore.waitFor(TimeUnit.MINUTES.toMillis(3L))) {
                error.set(JSDebuggerWipBackendBundle.message("error.timeout.occurred.when.saving.v8.heap.snapshot", new Object[0]));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Throwable throwable3 = (Throwable)throwableRef.get();
        if (throwable3 != null) {
            throw throwable3;
        }
        String message = (String)error.get();
        return message;
    }

    public WipV8ProfilingHelper(@NotNull WipVm v8Vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)v8Vm), (String)"v8Vm");
        this.v8Vm = v8Vm;
    }
}

