/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Notifications {
    public static final Topic<Notifications> TOPIC = Topic.create((String)"Notifications", Notifications.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    public static final String SYSTEM_MESSAGES_GROUP_ID = "System Messages";

    default public void notify(@NotNull Notification notification) {
        if (notification == null) {
            Notifications.$$$reportNull$$$0(0);
        }
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType) {
        if (groupDisplayName == null) {
            Notifications.$$$reportNull$$$0(1);
        }
        if (defaultDisplayType == null) {
            Notifications.$$$reportNull$$$0(2);
        }
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType, boolean shouldLog) {
        if (groupDisplayName == null) {
            Notifications.$$$reportNull$$$0(3);
        }
        if (defaultDisplayType == null) {
            Notifications.$$$reportNull$$$0(4);
        }
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType, boolean shouldLog, boolean shouldReadAloud) {
        if (groupDisplayName == null) {
            Notifications.$$$reportNull$$$0(5);
        }
        if (defaultDisplayType == null) {
            Notifications.$$$reportNull$$$0(6);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayName";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDisplayType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/notification/Notifications";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "notify";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Bus {
        private Bus() {
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        public static void register(@NotNull String groupId, @NotNull NotificationDisplayType defaultDisplayType) {
            if (groupId == null) {
                Bus.$$$reportNull$$$0(0);
            }
            if (defaultDisplayType == null) {
                Bus.$$$reportNull$$$0(1);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).register(groupId, defaultDisplayType);
                }
            });
        }

        public static void notify(@NotNull Notification notification) {
            if (notification == null) {
                Bus.$$$reportNull$$$0(2);
            }
            Bus.notify(notification, null);
        }

        public static void notify(@NotNull Notification notification, @Nullable Project project) {
            if (notification == null) {
                Bus.$$$reportNull$$$0(3);
            }
            notification.assertHasTitleOrContent();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Bus.doNotify(notification, project);
            } else {
                UIUtil.invokeLaterIfNeeded(() -> Bus.doNotify(notification, project));
            }
        }

        private static void doNotify(Notification notification, @Nullable Project project) {
            if (project != null && !project.isDisposed() && !project.isDefault()) {
                ((Notifications)project.getMessageBus().syncPublisher(TOPIC)).notify(notification);
            } else {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).notify(notification);
                }
            }
        }

        @ApiStatus.Experimental
        public static void notifyAndHide(@NotNull Notification notification) {
            if (notification == null) {
                Bus.$$$reportNull$$$0(4);
            }
            Bus.notifyAndHide(notification, null);
        }

        @ApiStatus.Experimental
        public static void notifyAndHide(@NotNull Notification notification, @Nullable Project project) {
            if (notification == null) {
                Bus.$$$reportNull$$$0(5);
            }
            Bus.notify(notification);
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> notification.expire(), 5L, TimeUnit.SECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultDisplayType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/Notifications$Bus";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "register";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notify";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyAndHide";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

