/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Notification {
    private static final Logger LOG = Logger.getInstance(Notification.class);
    private static final DataKey<Notification> KEY = DataKey.create((String)"Notification");
    @NotNull
    public final String id;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final NotificationType myType;
    @Nullable
    private String myDisplayId;
    @Nullable
    private Icon myIcon;
    @NotNull
    private @NlsContexts.NotificationTitle String myTitle;
    @Nullable
    private @NlsContexts.NotificationSubtitle String mySubtitle;
    @NotNull
    private @NlsContexts.NotificationContent String myContent;
    @Nullable
    private NotificationListener myListener;
    @Nullable
    private @NlsContexts.LinkLabel String myDropDownText;
    @Nullable
    private List<AnAction> myActions;
    @NotNull
    private CollapseActionsDirection myCollapseDirection;
    @Nullable
    private AnAction myContextHelpAction;
    @Nullable
    private Runnable myWhenExpired;
    @Nullable
    private Boolean myImportant;
    private final AtomicBoolean myExpired;
    private final AtomicReference<WeakReference<Balloon>> myBalloonRef;
    private final long myTimestamp;

    public Notification(@NotNull String groupId, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(0);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(1);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(2);
        }
        this(groupId, "", content, type);
    }

    public Notification(@NotNull String groupId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(3);
        }
        if (title == null) {
            Notification.$$$reportNull$$$0(4);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(5);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(6);
        }
        this.myCollapseDirection = CollapseActionsDirection.KEEP_RIGHTMOST;
        this.myExpired = new AtomicBoolean(false);
        this.myBalloonRef = new AtomicReference();
        this.myTimestamp = System.currentTimeMillis();
        this.id = this.myTimestamp + "." + System.identityHashCode(this);
        this.myGroupId = groupId;
        this.myType = type;
        this.myTitle = title;
        this.myContent = content;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Nullable
    public String getDisplayId() {
        return this.myDisplayId;
    }

    @NotNull
    public Notification setDisplayId(@NotNull String displayId) {
        if (displayId == null) {
            Notification.$$$reportNull$$$0(7);
        }
        this.myDisplayId = displayId;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(8);
        }
        return notification;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Notification setIcon(@Nullable Icon icon2) {
        this.myIcon = icon2;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(9);
        }
        return notification;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            Notification.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean hasTitle() {
        return !Notification.isEmpty(this.myTitle) || !Notification.isEmpty(this.mySubtitle);
    }

    @NotNull
    @NlsContexts.NotificationTitle
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            Notification.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public Notification setTitle(@Nullable @NlsContexts.NotificationTitle String title) {
        this.myTitle = StringUtil.notNullize((String)title);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(12);
        }
        return notification;
    }

    @NotNull
    public Notification setTitle(@Nullable @NlsContexts.NotificationTitle String title, @Nullable @NlsContexts.NotificationSubtitle String subtitle) {
        Notification notification = this.setTitle(title).setSubtitle(subtitle);
        if (notification == null) {
            Notification.$$$reportNull$$$0(13);
        }
        return notification;
    }

    @Nullable
    @NlsContexts.NotificationTitle
    public String getSubtitle() {
        return this.mySubtitle;
    }

    @NotNull
    public Notification setSubtitle(@Nullable @NlsContexts.NotificationTitle String subtitle) {
        this.mySubtitle = subtitle;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(14);
        }
        return notification;
    }

    public boolean hasContent() {
        return !Notification.isEmpty(this.myContent);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String text2) {
        return StringUtil.isEmptyOrSpaces((String)text2) || StringUtil.isEmptyOrSpaces((String)StringUtil.stripHtml((String)text2, (boolean)false));
    }

    @NotNull
    @NlsContexts.NotificationContent
    public String getContent() {
        String string = this.myContent;
        if (string == null) {
            Notification.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public Notification setContent(@NlsContexts.NotificationContent @Nullable String content) {
        this.myContent = StringUtil.notNullize((String)content);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(16);
        }
        return notification;
    }

    @Nullable
    public NotificationListener getListener() {
        return this.myListener;
    }

    @NotNull
    public Notification setListener(@NotNull NotificationListener listener2) {
        if (listener2 == null) {
            Notification.$$$reportNull$$$0(17);
        }
        this.myListener = listener2;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(18);
        }
        return notification;
    }

    @NotNull
    public static Notification get(@NotNull AnActionEvent e) {
        if (e == null) {
            Notification.$$$reportNull$$$0(19);
        }
        Notification notification = Objects.requireNonNull(e.getData(KEY));
        if (notification == null) {
            Notification.$$$reportNull$$$0(20);
        }
        return notification;
    }

    public static void fire(@NotNull Notification notification, @NotNull AnAction action2) {
        if (notification == null) {
            Notification.$$$reportNull$$$0(21);
        }
        if (action2 == null) {
            Notification.$$$reportNull$$$0(22);
        }
        Notification.fire(notification, action2, null);
    }

    public static void fire(@NotNull Notification notification, @NotNull AnAction action2, @Nullable DataContext context) {
        DataContext contextWrapper;
        AnActionEvent event;
        if (notification == null) {
            Notification.$$$reportNull$$$0(23);
        }
        if (action2 == null) {
            Notification.$$$reportNull$$$0(24);
        }
        if (ActionUtil.lastUpdateAndCheckDumb(action2, event = AnActionEvent.createFromAnAction(action2, null, "Notification", contextWrapper = dataId -> KEY.is(dataId) ? notification : (context != null ? context.getData(dataId) : null)), false)) {
            ActionUtil.performActionDumbAwareWithCallbacks(action2, event);
        }
    }

    public static void setDataProvider(@NotNull Notification notification, @NotNull JComponent component) {
        if (notification == null) {
            Notification.$$$reportNull$$$0(25);
        }
        if (component == null) {
            Notification.$$$reportNull$$$0(26);
        }
        DataManager.registerDataProvider(component, dataId -> KEY.is(dataId) ? notification : null);
    }

    @NotNull
    @NlsContexts.LinkLabel
    public String getDropDownText() {
        if (this.myDropDownText == null) {
            this.myDropDownText = IdeBundle.message("link.label.actions", new Object[0]);
        }
        String string = this.myDropDownText;
        if (string == null) {
            Notification.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public Notification setDropDownText(@NotNull @NlsContexts.LinkLabel String dropDownText) {
        if (dropDownText == null) {
            Notification.$$$reportNull$$$0(28);
        }
        this.myDropDownText = dropDownText;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(29);
        }
        return notification;
    }

    @NotNull
    public CollapseActionsDirection getCollapseDirection() {
        CollapseActionsDirection collapseActionsDirection = this.myCollapseDirection;
        if (collapseActionsDirection == null) {
            Notification.$$$reportNull$$$0(30);
        }
        return collapseActionsDirection;
    }

    @NotNull
    public Notification setCollapseDirection(CollapseActionsDirection collapseDirection) {
        this.myCollapseDirection = collapseDirection;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(31);
        }
        return notification;
    }

    @NotNull
    public List<AnAction> getActions() {
        List<AnAction> list = this.myActions != null ? this.myActions : Collections.emptyList();
        if (list == null) {
            Notification.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public Notification addAction(@NotNull AnAction action2) {
        if (action2 == null) {
            Notification.$$$reportNull$$$0(33);
        }
        (this.myActions != null ? this.myActions : (this.myActions = new ArrayList<AnAction>())).add(action2);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(34);
        }
        return notification;
    }

    @NotNull
    public Notification addActions(@NotNull Collection<? extends AnAction> actions) {
        if (actions == null) {
            Notification.$$$reportNull$$$0(35);
        }
        (this.myActions != null ? this.myActions : (this.myActions = new ArrayList<AnAction>())).addAll(actions);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(36);
        }
        return notification;
    }

    @Nullable
    public AnAction getContextHelpAction() {
        return this.myContextHelpAction;
    }

    @NotNull
    public Notification setContextHelpAction(AnAction action2) {
        this.myContextHelpAction = action2;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(37);
        }
        return notification;
    }

    @NotNull
    public NotificationType getType() {
        NotificationType notificationType = this.myType;
        if (notificationType == null) {
            Notification.$$$reportNull$$$0(38);
        }
        return notificationType;
    }

    public boolean isExpired() {
        return this.myExpired.get();
    }

    public void expire() {
        if (!this.myExpired.compareAndSet(false, true)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(this::hideBalloon);
        NotificationsManager.getNotificationsManager().expire(this);
        Runnable whenExpired = this.myWhenExpired;
        if (whenExpired != null) {
            whenExpired.run();
        }
    }

    public Notification whenExpired(@Nullable Runnable whenExpired) {
        this.myWhenExpired = whenExpired;
        return this;
    }

    public void hideBalloon() {
        Notification.hideBalloon(this.myBalloonRef.getAndSet(null));
    }

    private static void hideBalloon(@Nullable Reference<? extends Balloon> balloonRef) {
        Balloon balloon = (Balloon)SoftReference.dereference(balloonRef);
        if (balloon != null) {
            UIUtil.invokeLaterIfNeeded(balloon::hide);
        }
    }

    public void setBalloon(final @NotNull Balloon balloon) {
        if (balloon == null) {
            Notification.$$$reportNull$$$0(39);
        }
        WeakReference<Balloon> oldBalloon = this.myBalloonRef.getAndSet(new WeakReference<Balloon>(balloon));
        Notification.hideBalloon(oldBalloon);
        balloon.addListener(new JBPopupListener(){

            @Override
            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Notification.this.myBalloonRef.updateAndGet(prev -> SoftReference.dereference((Reference)prev) == balloon ? null : prev);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/Notification$1", "onClosed"));
            }
        });
    }

    @Nullable
    public Balloon getBalloon() {
        return (Balloon)SoftReference.dereference((Reference)this.myBalloonRef.get());
    }

    public void notify(@Nullable Project project) {
        Notifications.Bus.notify(this, project);
    }

    @NotNull
    public Notification setImportant(boolean important) {
        this.myImportant = important;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(40);
        }
        return notification;
    }

    public boolean isImportant() {
        return this.myImportant != null ? this.myImportant : this.getListener() != null || this.myActions != null && !this.myActions.isEmpty();
    }

    public final void assertHasTitleOrContent() {
        LOG.assertTrue(this.hasTitle() || this.hasContent(), (Object)("Notification should have title and/or content; groupId: " + this.myGroupId));
    }

    public String toString() {
        return String.format("Notification{id='%s', myGroupId='%s', myType=%s, myTitle='%s', mySubtitle='%s', myContent='%s'}", new Object[]{this.id, this.myGroupId, this.myType, this.myTitle, this.mySubtitle, this.myContent});
    }

    @Deprecated
    public Notification(@NotNull String groupId, @Nullable Icon icon2, @NotNull NotificationType type) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(41);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(42);
        }
        this(groupId, "", type);
        this.setIcon(icon2);
    }

    @Deprecated
    public Notification(@NotNull String groupId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(43);
        }
        if (title == null) {
            Notification.$$$reportNull$$$0(44);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(45);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(46);
        }
        this(groupId, title, content, type);
        this.myListener = listener2;
    }

    @Deprecated
    public Notification(@NotNull String groupId, @Nullable Icon icon2, @Nullable @NlsContexts.NotificationTitle String title, @Nullable @NlsContexts.NotificationSubtitle String subtitle, @Nullable @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(47);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(48);
        }
        this(groupId, content != null ? content : "", type);
        this.setIcon(icon2);
        this.setTitle(title, subtitle);
        this.myListener = listener2;
    }

    @Deprecated
    public final void addActions(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            Notification.$$$reportNull$$$0(49);
        }
        this.addActions((Collection<? extends AnAction>)actions);
    }

    @Deprecated
    public CollapseActionsDirection getCollapseActionsDirection() {
        return this.myCollapseDirection;
    }

    @Deprecated
    public void setCollapseActionsDirection(CollapseActionsDirection collapseDirection) {
        this.myCollapseDirection = collapseDirection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 5: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 6: 
            case 42: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayId";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/Notification";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 22: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropDownText";
                break;
            }
            case 35: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/Notification";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setDisplayId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setSubtitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setContent";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setListener";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDropDownText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "setDropDownText";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapseDirection";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "setCollapseDirection";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "addAction";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "addActions";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "setContextHelpAction";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "setImportant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayId";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fire";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setDropDownText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 35: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setBalloon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CollapseActionsDirection {
        KEEP_LEFTMOST,
        KEEP_RIGHTMOST;

    }
}

