/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.JoinedStringTargetEnvironmentFunction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\u001a/\u0010\u0000\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0001j\b\u0012\u0004\u0012\u0002H\u0003`\u0004\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0005\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u0006\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u001a \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a>\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004*\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u00042\u0006\u0010\u0017\u001a\u00020\b\u001a \u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004*\u00020\u0019\u001a \u0010\u001a\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001b0\u0001j\b\u0012\u0004\u0012\u00020\u001b`\u0004*\u00020\u001c\u001a(\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004*\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\b\u001a \u0010\u001f\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004*\u00020 \u001a \u0010!\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\b\u0018\u00010\"*\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\b\u001aJ\u0010#\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004\"\u0004\b\u0000\u0010\u0003*\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0001j\b\u0012\u0004\u0012\u0002H\u0003`\u00040$2\u0006\u0010%\u001a\u00020&*(\u0010'\u001a\u0004\b\u0000\u0010(\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H(0\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H(0\u0001\u00a8\u0006)"}, d2={"constant", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "T", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "value", "(Ljava/lang/Object;)Ljava/util/function/Function;", "getRelativePathIfAncestor", "", "ancestor", "file", "joinPaths", "basePath", "relativePath", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "downloadFromTarget", "", "localPath", "Ljava/nio/file/Path;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getRelativeTargetPath", "targetRelativePath", "getTargetDownloadPath", "Lcom/intellij/execution/target/TargetEnvironment$DownloadRoot;", "getTargetEnvironmentValue", "Lcom/intellij/execution/target/HostPort;", "Lcom/intellij/execution/target/TargetEnvironment$LocalPortBinding;", "getTargetEnvironmentValueForLocalPath", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetUploadPath", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "getUploadRootForLocalPath", "Lkotlin/Pair;", "joinToStringFunction", "", "separator", "", "TargetEnvironmentFunction", "R", "intellij.platform.lang"})
@JvmName(name="TargetEnvironmentFunctions")
public final class TargetEnvironmentFunctions {
    @NotNull
    public static final <T> Function<TargetEnvironment, T> constant(T value2) {
        return new Function(value2){
            final /* synthetic */ Object $value;

            public final T apply(@NotNull TargetEnvironment it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (T)this.$value;
            }
            {
                this.$value = object;
            }
        };
    }

    @NotNull
    public static final <T> Function<TargetEnvironment, String> joinToStringFunction(@NotNull Iterable<? extends Function<TargetEnvironment, T>> $this$joinToStringFunction, @NotNull CharSequence separator) {
        Intrinsics.checkNotNullParameter($this$joinToStringFunction, (String)"$this$joinToStringFunction");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return new JoinedStringTargetEnvironmentFunction($this$joinToStringFunction, separator);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Function<TargetEnvironment, String> getTargetEnvironmentValueForLocalPath(@NotNull TargetEnvironmentRequest $this$getTargetEnvironmentValueForLocalPath, @NotNull String localPath) {
        void uploadRoot;
        Intrinsics.checkNotNullParameter((Object)$this$getTargetEnvironmentValueForLocalPath, (String)"$this$getTargetEnvironmentValueForLocalPath");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Pair<TargetEnvironment.UploadRoot, String> pair = TargetEnvironmentFunctions.getUploadRootForLocalPath($this$getTargetEnvironmentValueForLocalPath, localPath);
        if (pair == null) {
            throw (Throwable)new IllegalArgumentException("Local path \"" + localPath + "\" is not registered within uploads in the request");
        }
        Pair<TargetEnvironment.UploadRoot, String> pair2 = pair;
        TargetEnvironment.UploadRoot uploadRoot2 = (TargetEnvironment.UploadRoot)pair2.component1();
        String relativePath = (String)pair2.component2();
        return new Function((TargetEnvironment.UploadRoot)uploadRoot, relativePath){
            final /* synthetic */ TargetEnvironment.UploadRoot $uploadRoot;
            final /* synthetic */ String $relativePath;

            @NotNull
            public final String apply(@NotNull TargetEnvironment targetEnvironment) {
                Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
                TargetEnvironment.UploadableVolume uploadableVolume = targetEnvironment.getUploadVolumes().get(this.$uploadRoot);
                if (uploadableVolume == null) {
                    throw (Throwable)new IllegalStateException("Upload root \"" + this.$uploadRoot + "\" is expected to be created in the target environment");
                }
                TargetEnvironment.UploadableVolume volume = uploadableVolume;
                return TargetEnvironmentFunctions.access$joinPaths(volume.getTargetRoot(), this.$relativePath, targetEnvironment.getTargetPlatform());
            }
            {
                this.$uploadRoot = uploadRoot;
                this.$relativePath = string;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Pair<TargetEnvironment.UploadRoot, String> getUploadRootForLocalPath(@NotNull TargetEnvironmentRequest $this$getUploadRootForLocalPath, @NotNull String localPath) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getUploadRootForLocalPath, (String)"$this$getUploadRootForLocalPath");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        char targetFileSeparator = $this$getUploadRootForLocalPath.getTargetPlatform().getPlatform().fileSeparator;
        Iterable $this$mapNotNull$iv = $this$getUploadRootForLocalPath.getUploadVolumes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TargetEnvironment.UploadRoot uploadRoot = (TargetEnvironment.UploadRoot)element$iv$iv;
            boolean bl2 = false;
            if (TargetEnvironmentFunctions.getRelativePathIfAncestor(((Object)uploadRoot.getLocalRootPath()).toString(), localPath) != null) {
                String string;
                boolean bl3 = false;
                boolean bl4 = false;
                String relativePath = string;
                boolean bl5 = false;
                pair = TuplesKt.to((Object)uploadRoot, (Object)(File.separatorChar != targetFileSeparator ? StringsKt.replace$default((String)relativePath, (char)File.separatorChar, (char)targetFileSeparator, (boolean)false, (int)4, null) : relativePath));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair it$iv$iv = pair2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final String getRelativePathIfAncestor(String ancestor, String file) {
        return FileUtil.isAncestor((String)ancestor, (String)file, (boolean)false) ? FileUtil.getRelativePath((String)ancestor, (String)file, (char)File.separatorChar) : null;
    }

    private static final String joinPaths(String basePath, String relativePath, TargetPlatform targetPlatform) {
        String fileSeparator = String.valueOf(targetPlatform.getPlatform().fileSeparator);
        String string = FileUtil.toSystemIndependentName((String)(StringsKt.removeSuffix((String)basePath, (CharSequence)fileSeparator) + fileSeparator + relativePath));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemIndepen\u2026eSeparator$relativePath\")");
        return string;
    }

    @NotNull
    public static final Function<TargetEnvironment, String> getTargetUploadPath(@NotNull TargetEnvironment.UploadRoot $this$getTargetUploadPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetUploadPath, (String)"$this$getTargetUploadPath");
        return new Function($this$getTargetUploadPath){
            final /* synthetic */ TargetEnvironment.UploadRoot $this_getTargetUploadPath;

            @NotNull
            public final String apply(@NotNull TargetEnvironment targetEnvironment) {
                Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
                TargetEnvironment.UploadRoot uploadRoot = this.$this_getTargetUploadPath;
                TargetEnvironment.UploadableVolume uploadableVolume = targetEnvironment.getUploadVolumes().get(uploadRoot);
                if (uploadableVolume == null) {
                    throw (Throwable)new IllegalStateException("Upload root \"" + uploadRoot + "\" cannot be found");
                }
                TargetEnvironment.UploadableVolume uploadableVolume2 = uploadableVolume;
                return uploadableVolume2.getTargetRoot();
            }
            {
                this.$this_getTargetUploadPath = uploadRoot;
            }
        };
    }

    @NotNull
    public static final Function<TargetEnvironment, String> getRelativeTargetPath(@NotNull Function<TargetEnvironment, String> $this$getRelativeTargetPath, @NotNull String targetRelativePath) {
        Intrinsics.checkNotNullParameter($this$getRelativeTargetPath, (String)"$this$getRelativeTargetPath");
        Intrinsics.checkNotNullParameter((Object)targetRelativePath, (String)"targetRelativePath");
        return new Function($this$getRelativeTargetPath, targetRelativePath){
            final /* synthetic */ Function $this_getRelativeTargetPath;
            final /* synthetic */ String $targetRelativePath;

            @NotNull
            public final String apply(@NotNull TargetEnvironment targetEnvironment) {
                Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
                R r = this.$this_getRelativeTargetPath.apply(targetEnvironment);
                Intrinsics.checkNotNullExpressionValue(r, (String)"this@getRelativeTargetPa\u2026.apply(targetEnvironment)");
                String targetBasePath = (String)r;
                return TargetEnvironmentFunctions.access$joinPaths(targetBasePath, this.$targetRelativePath, targetEnvironment.getTargetPlatform());
            }
            {
                this.$this_getRelativeTargetPath = function;
                this.$targetRelativePath = string;
            }
        };
    }

    @NotNull
    public static final Function<TargetEnvironment, String> getTargetDownloadPath(@NotNull TargetEnvironment.DownloadRoot $this$getTargetDownloadPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetDownloadPath, (String)"$this$getTargetDownloadPath");
        return new Function($this$getTargetDownloadPath){
            final /* synthetic */ TargetEnvironment.DownloadRoot $this_getTargetDownloadPath;

            @NotNull
            public final String apply(@NotNull TargetEnvironment targetEnvironment) {
                Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
                TargetEnvironment.DownloadRoot downloadRoot = this.$this_getTargetDownloadPath;
                TargetEnvironment.DownloadableVolume downloadableVolume = targetEnvironment.getDownloadVolumes().get(downloadRoot);
                if (downloadableVolume == null) {
                    throw (Throwable)new IllegalStateException("Download root \"" + downloadRoot + "\" cannot be found");
                }
                TargetEnvironment.DownloadableVolume downloadableVolume2 = downloadableVolume;
                return downloadableVolume2.getTargetRoot();
            }
            {
                this.$this_getTargetDownloadPath = downloadRoot;
            }
        };
    }

    @NotNull
    public static final Function<TargetEnvironment, HostPort> getTargetEnvironmentValue(@NotNull TargetEnvironment.LocalPortBinding $this$getTargetEnvironmentValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetEnvironmentValue, (String)"$this$getTargetEnvironmentValue");
        return new Function($this$getTargetEnvironmentValue){
            final /* synthetic */ TargetEnvironment.LocalPortBinding $this_getTargetEnvironmentValue;

            @NotNull
            public final HostPort apply(@NotNull TargetEnvironment targetEnvironment) {
                Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
                TargetEnvironment.LocalPortBinding localPortBinding = this.$this_getTargetEnvironmentValue;
                ResolvedPortBinding resolvedPortBinding = targetEnvironment.getLocalPortBindings().get(localPortBinding);
                if (resolvedPortBinding == null) {
                    throw (Throwable)new IllegalStateException("Local port binding \"" + localPortBinding + "\" cannot be found");
                }
                ResolvedPortBinding resolvedPortBinding2 = resolvedPortBinding;
                return resolvedPortBinding2.getTargetEndpoint();
            }
            {
                this.$this_getTargetEnvironmentValue = localPortBinding;
            }
        };
    }

    public static final void downloadFromTarget(@NotNull TargetEnvironment $this$downloadFromTarget, @NotNull Path localPath, @NotNull ProgressIndicator progressIndicator) throws IOException {
        Object v0;
        boolean bl;
        Object object;
        Path localFileDir;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$downloadFromTarget, (String)"$this$downloadFromTarget");
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            localFileDir = localPath.getParent();
            Collection<TargetEnvironment.DownloadableVolume> downloadVolumes = $this$downloadFromTarget.getDownloadVolumes().values();
            object = downloadVolumes;
            bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                TargetEnvironment.DownloadableVolume it = (TargetEnvironment.DownloadableVolume)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getLocalRoot(), (Object)localFileDir)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TargetEnvironment.DownloadableVolume downloadableVolume = v0;
        if (downloadableVolume == null) {
            object = "Volume with local root " + localFileDir + " not found";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        TargetEnvironment.DownloadableVolume downloadVolume = downloadableVolume;
        downloadVolume.download(PathsKt.getName((Path)localPath), progressIndicator);
    }

    public static final /* synthetic */ String access$joinPaths(String basePath, String relativePath, TargetPlatform targetPlatform) {
        return TargetEnvironmentFunctions.joinPaths(basePath, relativePath, targetPlatform);
    }
}

