/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionDialog;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0017\u0010\b\u001a\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHandler;", "Lcom/intellij/sql/refactoring/SqlIntroduceHandlerBase;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "()V", "doRefactor", "", "routineInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "getHelper", "Lorg/jetbrains/annotations/Nullable;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "intellij.database.sql.impl"})
public final class SqlExtractFunctionHandler
extends SqlIntroduceHandlerBase<SqlExtractFunctionHelper> {
    @NotNull
    public static final SqlExtractFunctionHandler INSTANCE;

    @Override
    @Nullable
    protected SqlExtractFunctionHelper getHelper(@NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return dialect.getExtractFunctionHelper();
    }

    @Override
    protected void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull SqlExpression expression) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        SqlType sqlType = expression.getSqlType();
        Intrinsics.checkNotNullExpressionValue((Object)sqlType, (String)"expression.sqlType");
        SqlType sqlType2 = sqlType;
        if (Intrinsics.areEqual((Object)sqlType2, (Object)SqlType.UNKNOWN) || !(sqlType2 instanceof SqlPrimitiveType)) {
            String string = SqlBundle.message("dialog.message.only.expressions.primitive.types.are.supported", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"dialo\u2026ive.types.are.supported\")");
            this.showError(project, editor, string);
            return;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(expression)");
        SqlExtractFunctionHelper sqlExtractFunctionHelper = this.getHelper(sqlLanguageDialectEx);
        if (sqlExtractFunctionHelper == null) {
            return;
        }
        SqlExtractFunctionHelper helper = sqlExtractFunctionHelper;
        PsiElement psiElement = helper.findTopmostBlock((PsiElement)expression);
        if (!(psiElement instanceof SqlElement)) {
            psiElement = null;
        }
        SqlElement sqlElement = (SqlElement)psiElement;
        if (sqlElement == null) {
            return;
        }
        SqlElement container = sqlElement;
        SqlExtractableCodeInfo codeInfo = new SqlExtractableCodeInfo(expression, container);
        SqlExtractFunctionInfo routineInfo = new SqlExtractFunctionInfo(codeInfo, "my_function", codeInfo.getParameterInfos());
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.doRefactor(routineInfo);
        } else {
            new SqlExtractFunctionDialog(routineInfo, helper, (Function1<? super SqlExtractFunctionInfo, Unit>)((Function1)new Function1<SqlExtractFunctionInfo, Unit>(this){

                public final void invoke(@NotNull SqlExtractFunctionInfo p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    SqlExtractFunctionHandler.access$doRefactor((SqlExtractFunctionHandler)this.receiver, p1);
                }
            })).show();
        }
    }

    private final void doRefactor(SqlExtractFunctionInfo routineInfo) {
        SqlExtractFunctionHelper sqlExtractFunctionHelper = this.getHelper(routineInfo.getCodeInfo().getDialect());
        if (sqlExtractFunctionHelper == null) {
            return;
        }
        SqlExtractFunctionHelper helper = sqlExtractFunctionHelper;
        Project project = routineInfo.getCodeInfo().getProject();
        SqlExpression expression = routineInfo.getCodeInfo().getOriginalExpression();
        SqlRoutineDefinition routineDefinition = helper.generateRoutine(routineInfo, false);
        SqlFunctionCallExpression call = helper.generateCall(routineInfo);
        PsiElement anchor2 = helper.findAnchor((PsiElement)expression, (PsiElement)routineInfo.getCodeInfo().getContainer());
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getName(), null, (Runnable)new Runnable(expression, call, helper, routineDefinition, anchor2, routineInfo, project){
            final /* synthetic */ SqlExpression $expression;
            final /* synthetic */ SqlFunctionCallExpression $call;
            final /* synthetic */ SqlExtractFunctionHelper $helper;
            final /* synthetic */ SqlRoutineDefinition $routineDefinition;
            final /* synthetic */ PsiElement $anchor;
            final /* synthetic */ SqlExtractFunctionInfo $routineInfo;
            final /* synthetic */ Project $project;

            public final void run() {
                this.$expression.replace((PsiElement)this.$call);
                SqlRoutineDefinition routineInPlace = this.$helper.addRoutine(this.$routineDefinition, this.$anchor, this.$routineInfo.getCodeInfo().getContainer());
                CodeStyleManager.getInstance((Project)this.$project).reformat((PsiElement)routineInPlace);
            }
            {
                this.$expression = sqlExpression;
                this.$call = sqlFunctionCallExpression;
                this.$helper = sqlExtractFunctionHelper;
                this.$routineDefinition = sqlRoutineDefinition;
                this.$anchor = psiElement;
                this.$routineInfo = sqlExtractFunctionInfo;
                this.$project = project;
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private SqlExtractFunctionHandler() {
        String string = SqlBundle.message("extract.function", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"extract.function\")");
        super(string);
    }

    static {
        SqlExtractFunctionHandler sqlExtractFunctionHandler;
        INSTANCE = sqlExtractFunctionHandler = new SqlExtractFunctionHandler();
    }

    public static final /* synthetic */ void access$doRefactor(SqlExtractFunctionHandler $this, SqlExtractFunctionInfo routineInfo) {
        $this.doRefactor(routineInfo);
    }
}

