/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.MapFun;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u008b\u0001\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u00020\u0003\"\u0014\b\u0002\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00012\u0006\u0010\u0007\u001a\u0002H\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00010\t26\u0010\n\u001a2\u0012\u0013\u0012\u0011H\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u0011H\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u0002H\u00040\u000b\u00a2\u0006\u0002\u0010\u0010\u001a\u0095\u0001\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u00020\u0003\"\u0014\b\u0002\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00012\b\u0010\u0007\u001a\u0004\u0018\u0001H\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00010\t26\u0010\n\u001a2\u0012\u0013\u0012\u0011H\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u0011H\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u0002H\u00040\u000bH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0010\u001a\u008d\u0001\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0012\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u001226\u0010\n\u001a2\u0012\u0013\u0012\u0011H\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u0011H\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u0002H\u00040\u000bH\u0007\u00a2\u0006\u0002\b\u0013\u001a\u0093\u0001\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u0012\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u00020\u00032\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u00122\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u001226\u0010\n\u001a2\u0012\u0013\u0012\u0011H\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u0011H\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u0002H\u00040\u000bH\u0007\u00a2\u0006\u0002\b\u0011\u001a.\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u0004*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\u00150\u0017\u001a=\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u0005\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u00020\u0003*\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u0005H\u0086\b\u00a8\u0006\u0019"}, d2={"merge", "M", "K", "", "V", "", "mapA", "mapB", "mapCreatingMethod", "Lkotlin/Function0;", "mergeValueMethod", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "a", "b", "(Ljava/util/Map;Ljava/util/Map;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)Ljava/util/Map;", "mergeNullable", "Ljava/util/SortedMap;", "mergeSorted", "containsValues", "", "predicate", "Lkotlin/Function1;", "nullize", "intellij.database.core.impl"})
@JvmName(name="MapFun")
public final class MapFun {
    @NotNull
    public static final <K, V, M extends Map<K, ? extends V>> M merge(@NotNull M mapA, @NotNull M mapB, @NotNull Function0<? extends M> mapCreatingMethod, @NotNull Function2<? super V, ? super V, ? extends V> mergeValueMethod) {
        K k;
        Intrinsics.checkNotNullParameter(mapA, (String)"mapA");
        Intrinsics.checkNotNullParameter(mapB, (String)"mapB");
        Intrinsics.checkNotNullParameter(mapCreatingMethod, (String)"mapCreatingMethod");
        Intrinsics.checkNotNullParameter(mergeValueMethod, (String)"mergeValueMethod");
        if (mapB.isEmpty()) {
            return mapA;
        }
        if (mapA.isEmpty()) {
            return mapB;
        }
        Map result2 = (Map)mapCreatingMethod.invoke();
        Map map2 = result2;
        if (!TypeIntrinsics.isMutableMap((Object)map2)) {
            map2 = null;
        }
        if (map2 == null) {
            throw (Throwable)new IllegalArgumentException("The map producer must create a mutable map instance " + "but it has created " + result2.getClass().getName() + " that is not mutable.");
        }
        Map container = map2;
        for (Map.Entry<K, Object> e : mapA.entrySet()) {
            k = e.getKey();
            V v1 = e.getValue();
            V v2 = mapB.get(k);
            if (v2 == null) {
                container.put(k, v1);
                continue;
            }
            Object v3 = mergeValueMethod.invoke(v1, v2);
            container.put(k, v3);
        }
        for (Map.Entry<K, Object> e : mapB.entrySet()) {
            k = e.getKey();
            if (container.containsKey(k)) continue;
            V v2 = e.getValue();
            container.put(k, v2);
        }
        return (M)result2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmName(name="mergeNullable")
    @Nullable
    public static final <K, V, M extends Map<K, ? extends V>> M mergeNullable(@Nullable M mapA, @Nullable M mapB, @NotNull Function0<? extends M> mapCreatingMethod, @NotNull Function2<? super V, ? super V, ? extends V> mergeValueMethod) {
        M m;
        Intrinsics.checkNotNullParameter(mapCreatingMethod, (String)"mapCreatingMethod");
        Intrinsics.checkNotNullParameter(mergeValueMethod, (String)"mergeValueMethod");
        if (mapB == null || mapB.isEmpty()) {
            M m2;
            if (mapA != null) {
                M m3 = mapA;
                boolean bl = false;
                if (!m3.isEmpty()) {
                    m2 = mapA;
                    return m2;
                }
            }
            m2 = null;
            return m2;
        }
        if (mapA != null) {
            if (!mapA.isEmpty()) return MapFun.merge(mapA, mapB, mapCreatingMethod, mergeValueMethod);
        }
        M m4 = mapB;
        boolean bl = false;
        if (!m4.isEmpty()) {
            m = mapB;
            return m;
        }
        m = null;
        return m;
    }

    @JvmName(name="mergeSorted")
    @NotNull
    public static final <K, V> SortedMap<K, V> mergeSorted(@NotNull SortedMap<K, V> mapA, @NotNull SortedMap<K, V> mapB, @NotNull Function2<? super V, ? super V, ? extends V> mergeValueMethod) {
        Intrinsics.checkNotNullParameter(mapA, (String)"mapA");
        Intrinsics.checkNotNullParameter(mapB, (String)"mapB");
        Intrinsics.checkNotNullParameter(mergeValueMethod, (String)"mergeValueMethod");
        return (SortedMap)MapFun.merge((Map)mapA, (Map)mapB, merge.1.INSTANCE, mergeValueMethod);
    }

    @JvmName(name="mergeNullable")
    @Nullable
    public static final <K, V> SortedMap<K, V> mergeNullable(@Nullable SortedMap<K, V> mapA, @Nullable SortedMap<K, V> mapB, @NotNull Function2<? super V, ? super V, ? extends V> mergeValueMethod) {
        Intrinsics.checkNotNullParameter(mergeValueMethod, (String)"mergeValueMethod");
        return (SortedMap)MapFun.mergeNullable((Map)mapA, (Map)mapB, merge.2.INSTANCE, mergeValueMethod);
    }

    public static final <V> boolean containsValues(@NotNull Map<?, ? extends V> $this$containsValues, @NotNull Function1<? super V, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$containsValues, (String)"$this$containsValues");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        for (V value2 : $this$containsValues.values()) {
            if (!((Boolean)predicate.invoke(value2)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final <K, V> Map<K, V> nullize(@Nullable Map<K, ? extends V> $this$nullize) {
        int $i$f$nullize = 0;
        if ($this$nullize == null) return null;
        Map<K, V> map2 = $this$nullize;
        boolean bl = false;
        if (map2.isEmpty()) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        Map<K, V> map3 = $this$nullize;
        return map3;
    }
}

