/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.CompoundObjectEditor;
import com.intellij.database.schemaEditor.DbObjectBoolPropEditor;
import com.intellij.database.schemaEditor.DbObjectEditor;
import com.intellij.database.schemaEditor.DbObjectEditorFactoryHelper;
import com.intellij.database.schemaEditor.DbObjectEnumPropEditor;
import com.intellij.database.schemaEditor.DbObjectGrantsEditor;
import com.intellij.database.schemaEditor.DbObjectGrantsEditorImpl;
import com.intellij.database.schemaEditor.DbObjectNameEditor;
import com.intellij.database.schemaEditor.DbObjectReferencePropEditor;
import com.intellij.database.schemaEditor.DbObjectTextCollectionPropEditor;
import com.intellij.database.schemaEditor.DbObjectTextPropEditor;
import com.intellij.database.schemaEditor.DbSeqIdPropEditor;
import com.intellij.database.schemaEditor.DbUserGrantsEditor;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectEditorFactoryHelperImpl
extends DbObjectEditorFactoryHelper {
    @Override
    @NotNull
    public DbObjectEditor createNameEditor(@NotNull Project project) {
        if (project == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(0);
        }
        return new DbObjectNameEditor(project);
    }

    @Override
    @NotNull
    public DbObjectEditor createBoolPropEditor(@NotNull BasicMetaProperty<?, Boolean> property, @Nullable @NlsContexts.Label String title) {
        if (property == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(1);
        }
        return new DbObjectBoolPropEditor(property, title);
    }

    @Override
    @NotNull
    public DbObjectEditor createSeqIdPropEditor(@NotNull BasicMetaProperty<?, SequenceIdentity> property, @Nullable @NlsContexts.Label String title) {
        if (property == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(2);
        }
        return new DbSeqIdPropEditor(property, title);
    }

    @Override
    @NotNull
    public DbObjectEditor createEnumPropEditor(@NotNull BasicMetaProperty<?, Enum<?>> property, @Nullable @NlsContexts.Label String title) {
        if (property == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(3);
        }
        return new DbObjectEnumPropEditor(property, title);
    }

    @Override
    @NotNull
    public <T> DbObjectEditor createTextPropEditor(@NotNull BasicMetaProperty<?, T> property, @Nullable @NlsContexts.Label String title, @NotNull Function<? super T, String> from, @NotNull Function<? super String, ? extends T> to) {
        if (property == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(4);
        }
        if (from == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(5);
        }
        if (to == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(6);
        }
        return new DbObjectTextPropEditor(property, title, from, to);
    }

    @Override
    @NotNull
    public DbObjectEditor createTextCollectionPropEditor(@NotNull BasicMetaProperty<?, ?> property, @Nullable @NlsContexts.Label String title, @NotNull Function<?, String> from, @NotNull Function<? super String, ?> to, @NotNull Factory<? extends Collection<?>> fac) {
        if (property == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(7);
        }
        if (from == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(8);
        }
        if (to == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(9);
        }
        if (fac == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(10);
        }
        return new DbObjectTextCollectionPropEditor(property, title, from, to, fac);
    }

    @NotNull
    public <T extends Enum<T>, C extends Collection<T>> DbObjectEditor createEnumListEditor(BasicMetaProperty<?, C> property, @NlsSafe String title, Class<T> enumClass, Factory<? extends C> fac) {
        return new DbObjectTextCollectionPropEditor(property, title, Enum::name, n -> Enum.valueOf(enumClass, n), fac);
    }

    @Override
    @NotNull
    public <E extends BasicElement, T> DbObjectEditor createReferencePropEditor(@NotNull Project project, @NotNull BasicMetaProperty<E, T> property, @NlsContexts.Label @Nullable String title, @NotNull BasicMetaObject<?> meta, @NotNull Function<E, Pair<BasicElement, String>> extract, @NotNull PairConsumer<E, Pair<BasicElement, String>> assign) {
        if (project == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(11);
        }
        if (property == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(12);
        }
        if (meta == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(13);
        }
        if (extract == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(14);
        }
        if (assign == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(15);
        }
        return new DbObjectReferencePropEditor<E, T>(project, property, title, extract, assign, (PairFunction<DbDataSource, ObjectPath, JBIterable<BasicElement>>)((PairFunction)(ds, context) -> DbObjectReferencePropEditor.createTraverser(ds, context, meta)));
    }

    @Override
    @NotNull
    public <E extends BasicElement, T> DbObjectEditor createReferencePropEditor(@NotNull Project project, @NotNull BasicMetaProperty<E, T> property, @NlsContexts.Label @Nullable String title, @NotNull BasicMetaReference<E, ?> metaRef, @NotNull Function<E, Pair<BasicElement, String>> extract, @NotNull PairConsumer<E, Pair<BasicElement, String>> assign) {
        if (project == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(16);
        }
        if (property == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(17);
        }
        if (metaRef == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(18);
        }
        if (extract == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(19);
        }
        if (assign == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(20);
        }
        return new DbObjectReferencePropEditor<E, T>(project, property, title, extract, assign, (PairFunction<DbDataSource, ObjectPath, JBIterable<BasicElement>>)((PairFunction)(ds, context) -> DbObjectReferencePropEditor.createTraverser(ds, context, metaRef)));
    }

    @Override
    @Nullable
    public <G extends Grants.Grant, U extends BasicElement> DbObjectGrantsEditor<G, U> createGrantsEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta, @Nullable Grants.Controller<G, U> grantCtl) {
        if (project == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(21);
        }
        if (meta == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(22);
        }
        Iterable<String> p2 = grantCtl == null ? null : grantCtl.possiblePrivileges(meta);
        return grantCtl == null || !p2.iterator().hasNext() ? null : new DbObjectGrantsEditorImpl<G, U>(project, meta.getModel().dbms, grantCtl);
    }

    @Override
    @Nullable
    public <G extends Grants.Grant, U extends BasicElement> DbObjectEditor createGranteeGrantsEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta, @Nullable Grants.Controller<G, U> grantCtl) {
        if (project == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(23);
        }
        if (meta == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(24);
        }
        return grantCtl == null ? null : new DbUserGrantsEditor<G, U>(project, meta.getModel().dbms, grantCtl);
    }

    @Override
    @NotNull
    public DbObjectEditor createCompoundEditor(@NotNull List<DbObjectEditor> editors) {
        if (editors == null) {
            DbObjectEditorFactoryHelperImpl.$$$reportNull$$$0(25);
        }
        return new CompoundObjectEditor(editors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fac";
                break;
            }
            case 13: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extract";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assign";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaRef";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactoryHelperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createNameEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createBoolPropEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createSeqIdPropEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createEnumPropEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createTextPropEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createTextCollectionPropEditor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferencePropEditor";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "createGrantsEditor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "createGranteeGrantsEditor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "createCompoundEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

