/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseDynamicBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectKind
implements Comparable<ObjectKind> {
    private static final AtomicInteger ourOrderNumCounter = new AtomicInteger(0);
    public static final Map<String, ObjectKind> ourKinds = new ConcurrentHashMap<String, ObjectKind>();
    private static final DynamicBundle ourPresentableNamesBundle = DatabaseDynamicBundle.INSTANCE;
    private static final String ourPresentableNamesCodePrefix = "ObjectKind.";
    public static final ObjectKind NONE = new ObjectKind("NONE");
    public static final ObjectKind ROOT = new ObjectKind("ROOT");
    public static final ObjectKind DATABASE = new ObjectKind("DATABASE");
    public static final ObjectKind SCHEMA = new ObjectKind("SCHEMA");
    public static final ObjectKind SEQUENCE = new ObjectKind("SEQUENCE");
    public static final ObjectKind CLUSTER = new ObjectKind("CLUSTER");
    public static final ObjectKind OBJECT_TYPE = new ObjectKind("OBJECT TYPE");
    public static final ObjectKind COLLECTION_TYPE = new ObjectKind("COLLECTION TYPE");
    public static final ObjectKind TABLE_TYPE = new ObjectKind("TABLE TYPE");
    public static final ObjectKind ALIAS_TYPE = new ObjectKind("ALIAS TYPE");
    public static final ObjectKind TABLE = new ObjectKind("TABLE");
    public static final ObjectKind MAT_LOG = new ObjectKind("MATERIALIZED LOG");
    public static final ObjectKind MAT_VIEW = new ObjectKind("MATERIALIZED VIEW");
    public static final ObjectKind VIEW = new ObjectKind("VIEW");
    public static final ObjectKind PACKAGE = new ObjectKind("PACKAGE");
    public static final ObjectKind BODY = new ObjectKind("BODY");
    public static final ObjectKind ROUTINE = new ObjectKind("ROUTINE");
    public static final ObjectKind METHOD = new ObjectKind("METHOD");
    public static final ObjectKind OPERATOR = new ObjectKind("OPERATOR");
    public static final ObjectKind OBJECT_ATTRIBUTE = new ObjectKind("OBJECT ATTRIBUTE");
    public static final ObjectKind COLUMN = new ObjectKind("COLUMN");
    public static final ObjectKind INDEX = new ObjectKind("INDEX");
    public static final ObjectKind KEY = new ObjectKind("KEY");
    public static final ObjectKind FOREIGN_KEY = new ObjectKind("FOREIGN KEY");
    public static final ObjectKind CHECK = new ObjectKind("CHECK");
    public static final ObjectKind DEFAULT = new ObjectKind("DEFAULT");
    public static final ObjectKind RULE = new ObjectKind("RULE");
    public static final ObjectKind TRIGGER = new ObjectKind("TRIGGER");
    public static final ObjectKind ARGUMENT = new ObjectKind("ARGUMENT");
    public static final ObjectKind VARIABLE = new ObjectKind("VARIABLE");
    public static final ObjectKind SYNONYM = new ObjectKind("SYNONYM");
    public static final ObjectKind DB_LINK = new ObjectKind("DBLINK");
    public static final ObjectKind VIRTUAL_TABLE = new ObjectKind("VIRTUAL TABLE");
    public static final ObjectKind COLLATION = new ObjectKind("COLLATION");
    public static final ObjectKind SCRIPT = new ObjectKind("SCRIPT");
    public static final ObjectKind TABLESPACE = new ObjectKind("TABLESPACE");
    public static final ObjectKind DATA_FILE = new ObjectKind("DATA FILE");
    public static final ObjectKind ROLE = new ObjectKind("ROLE");
    public static final ObjectKind USER = new ObjectKind("USER");
    public static final ObjectKind CONNECTION = new ObjectKind("CONNECTION");
    public static final ObjectKind FOREIGN_DATA_WRAPPER = new ObjectKind("FOREIGN DATA WRAPPER");
    public static final ObjectKind SERVER = new ObjectKind("SERVER");
    public static final ObjectKind USER_MAPPING = new ObjectKind("USER MAPPING");
    public static final ObjectKind FOREIGN_TABLE = new ObjectKind("FOREIGN TABLE");
    public static final ObjectKind EXTERNAL_SCHEMA = new ObjectKind("EXTERNAL SCHEMA");
    public static final ObjectKind SCHEDULED_EVENT = new ObjectKind("SCHEDULED EVENT");
    public static final ObjectKind ACCESS_METHOD = new ObjectKind("ACCESS METHOD");
    public static final ObjectKind AGGREGATE = new ObjectKind("AGGREGATE");
    public static final ObjectKind EXCEPTION = new ObjectKind("EXCEPTION");
    public static final ObjectKind EXTENSION = new ObjectKind("EXTENSION");
    public static final ObjectKind PROJECTION = new ObjectKind("PROJECTION");
    public static final ObjectKind MACRO = new ObjectKind("MACRO");
    public static final ObjectKind PARTITION = new ObjectKind("PARTITION");
    public static final ObjectKind WAREHOUSE = new ObjectKind("WAREHOUSE");
    public static final ObjectKind FORMAT = new ObjectKind("FORMAT");
    public static final ObjectKind INDEX_EXTENSION = new ObjectKind("INDEX EXTENSION");
    public static final ObjectKind INDEX_SEARCH_METHOD = new ObjectKind("SEARCH METHOD");
    public static final ObjectKind CONSTANT = new ObjectKind("CONSTANT");
    public static final ObjectKind PERIOD = new ObjectKind("PERIOD");
    public static final ObjectKind LANGUAGE = new ObjectKind("LANGUAGE");
    public static final ObjectKind LOGIN = new ObjectKind("LOGIN");
    public static final ObjectKind OPERATOR_CLASS = new ObjectKind("OPERATOR CLASS");
    public static final ObjectKind OPERATOR_FAMILY = new ObjectKind("OPERATOR FAMILY");
    public static final ObjectKind GROUP = new ObjectKind("GROUP");
    public static final ObjectKind SECURITY_POLICY = new ObjectKind("SECURITY POLICY");
    public static final ObjectKind SECURITY_PREDICATE = new ObjectKind("SECURITY PREDICATE");
    public static final ObjectKind LINKED_SERVER = new ObjectKind("LINKED SERVER");
    public static final ObjectKind UNKNOWN_OBJECT = new ObjectKind("UNKNOWN OBJECT", Integer.MAX_VALUE);
    private static final int ourLastDatabaseKind = ourOrderNumCounter.get();
    private final String myName;
    private final @Nullable Supplier<@Nls String> myPresentableNameSupplier;
    private final int myOrderNum;
    private final String myCode;
    @NotNull
    final String mySingularPresentableKey;
    @NotNull
    final String myPluralPresentableKey;

    public ObjectKind(@NotNull String name) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(0);
        }
        this(name, null, ourOrderNumCounter.getAndIncrement());
    }

    private ObjectKind(@NotNull String name, int orderNum) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(1);
        }
        this(name, null, orderNum);
    }

    private ObjectKind(@NotNull String name, @Nullable Supplier<@Nls String> presentableNameSupplier, int orderNum) {
        if (name == null) {
            ObjectKind.$$$reportNull$$$0(2);
        }
        assert (name.length() > 0);
        assert (orderNum >= 0);
        this.myName = name;
        this.myPresentableNameSupplier = presentableNameSupplier;
        this.myOrderNum = orderNum;
        this.myCode = StringUtil.toLowerCase((String)this.myName).replace(' ', '-');
        String thePresentableCode = this.myCode.replace('-', '_');
        String thePresentableCodePlural = StringUtil.pluralize((String)thePresentableCode);
        this.mySingularPresentableKey = ourPresentableNamesCodePrefix + thePresentableCode;
        this.myPluralPresentableKey = ourPresentableNamesCodePrefix + thePresentableCodePlural;
        ourKinds.putIfAbsent(this.myCode, this);
    }

    public String name() {
        return this.myName;
    }

    public String code() {
        return this.myCode;
    }

    @Nls
    public String getPresentableName() {
        String s2 = null;
        if (this.myPresentableNameSupplier != null) {
            s2 = this.myPresentableNameSupplier.get();
        }
        if (s2 == null) {
            s2 = ourPresentableNamesBundle.messageOrNull(this.mySingularPresentableKey, new Object[0]);
        }
        if (s2 == null) {
            s2 = this.myName.toLowerCase(Locale.ENGLISH);
        }
        return s2;
    }

    @Nls
    public String getPluralPresentableName() {
        String s2 = ourPresentableNamesBundle.messageOrNull(this.myPluralPresentableKey, new Object[0]);
        if (s2 == null) {
            s2 = StringUtil.pluralize((String)this.myName.toLowerCase(Locale.ENGLISH));
        }
        return s2;
    }

    public int getOrder() {
        return this.myOrderNum;
    }

    public String toString() {
        return this.code();
    }

    @Override
    public int compareTo(@NotNull ObjectKind that) {
        if (that == null) {
            ObjectKind.$$$reportNull$$$0(3);
        }
        if (this == that) {
            return 0;
        }
        if (this.myOrderNum < that.myOrderNum) {
            return -1;
        }
        if (this.myOrderNum > that.myOrderNum) {
            return 1;
        }
        throw new IllegalStateException(String.format("Incomparable object kinds: %s and %s", this.code(), that.code()));
    }

    @NotNull
    public static JBIterable<ObjectKind> getDatabaseKinds() {
        JBIterable jBIterable = JBIterable.from(ourKinds.values()).filter(ObjectKind::isDatabaseKind);
        if (jBIterable == null) {
            ObjectKind.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    public static boolean isDatabaseKind(@NotNull ObjectKind k) {
        if (k == null) {
            ObjectKind.$$$reportNull$$$0(5);
        }
        return k.myOrderNum < ourLastDatabaseKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ObjectKind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ObjectKind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDatabaseKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

