/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.StorageLockContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorageDsMetadata
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbSrcStorageDsMetadata.class);
    private final PersistentHashMap<ObjectPath, MetaData> myObjects;

    public DbSrcStorageDsMetadata(@NotNull File file) throws IOException {
        if (file == null) {
            DbSrcStorageDsMetadata.$$$reportNull$$$0(0);
        }
        this.myObjects = DbSrcStorageDsMetadata.createMapOrRecreate(file);
    }

    public void flush() {
        this.myObjects.force();
    }

    @NotNull
    private static PersistentHashMap<ObjectPath, MetaData> createMapOrRecreate(@NotNull File file) throws IOException {
        if (file == null) {
            DbSrcStorageDsMetadata.$$$reportNull$$$0(1);
        }
        try {
            FileUtil.createParentDirs((File)file.getParentFile());
            return DbSrcStorageDsMetadata.createMap(file);
        }
        catch (IOException e) {
            FileUtil.delete((File)file);
            return DbSrcStorageDsMetadata.createMap(file);
        }
    }

    @NotNull
    public static PersistentHashMap<ObjectPath, MetaData> createMap(@NotNull File file) throws IOException {
        if (file == null) {
            DbSrcStorageDsMetadata.$$$reportNull$$$0(2);
        }
        return new PersistentHashMap(file.toPath(), (KeyDescriptor)new MyKeyDescriptor(), (DataExternalizer)new MyDataExternalizer(), 1024, 0, new StorageLockContext(true));
    }

    @Nullable
    public MetaData getMetaData(@NotNull ObjectPath path) {
        if (path == null) {
            DbSrcStorageDsMetadata.$$$reportNull$$$0(3);
        }
        try {
            return (MetaData)this.myObjects.get((Object)path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void putMetaData(@NotNull ObjectPath object, @Nullable MetaData data) {
        if (object == null) {
            DbSrcStorageDsMetadata.$$$reportNull$$$0(4);
        }
        try {
            if (data == null || data.equals(MetaData.EMPTY)) {
                this.myObjects.remove((Object)object);
            } else {
                this.myObjects.put((Object)object, (Object)data);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void dispose() {
        try {
            this.myObjects.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void serialize(MetaData metaData, HierarchicalStreamWriter stream) {
        stream.startNode("");
        if (metaData != null && !metaData.equals(MetaData.EMPTY)) {
            PairConsumer adder = (k, v) -> {
                stream.startNode(k);
                stream.setValue(v);
                stream.endNode();
            };
            adder.consume((Object)"fmtVer", (Object)String.valueOf(3));
            adder.consume((Object)"srcVer", (Object)String.valueOf(metaData.srcVersion));
            adder.consume((Object)"introVer", (Object)String.valueOf(metaData.introContentVersion));
            adder.consume((Object)"genVer", (Object)String.valueOf(metaData.genContentVersion));
            adder.consume((Object)"hash", (Object)String.valueOf(metaData.contentHash));
            if (metaData.kinds != null && metaData.offsets != null) {
                stream.startNode("offs");
                int e = Math.max(metaData.kinds.length, metaData.offsets.length);
                for (int i2 = 0; i2 < e; ++i2) {
                    stream.startNode(String.valueOf(metaData.offsets[i2]));
                    stream.setValue(String.valueOf(metaData.kinds[i2]));
                    stream.endNode();
                }
                stream.endNode();
            }
        }
        stream.endNode();
    }

    public static MetaData deserialize(HierarchicalStreamReader stream) {
        return MetaData.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createMapOrRecreate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMetaData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "putMetaData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDataExternalizer
    implements DataExternalizer<MetaData> {
        private static final byte DATA_VERSION = 3;
        private static final String OLD_KINDS = "_FODS;";

        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, MetaData value2) throws IOException {
            if (out == null) {
                MyDataExternalizer.$$$reportNull$$$0(0);
            }
            out.write(3);
            out.writeBoolean(value2.srcVersion != null);
            if (value2.srcVersion != null) {
                out.writeLong(value2.srcVersion);
            }
            out.writeInt(value2.contentHash);
            out.writeInt(value2.offsets == null ? 0 : value2.offsets.length);
            if (value2.offsets != null) {
                for (int offset : value2.offsets) {
                    out.writeInt(offset);
                }
            }
            if (value2.kinds != null) {
                for (char kind : value2.kinds) {
                    out.writeChar(kind);
                }
            }
            out.writeInt(value2.introContentVersion);
            out.writeInt(value2.genContentVersion);
        }

        public MetaData read(@NotNull DataInput in) throws IOException {
            byte ver;
            if (in == null) {
                MyDataExternalizer.$$$reportNull$$$0(1);
            }
            boolean srcVersionNotNull = (ver = in.readByte()) < 2 ? ver == 1 : in.readBoolean();
            Long srcVersion = srcVersionNotNull ? Long.valueOf(in.readLong()) : null;
            int contentHash = in.readInt();
            if (ver < 2) {
                return new MetaData(srcVersion, contentHash, MetaData.EMPTY.offsets, MetaData.EMPTY.kinds, 0, 0);
            }
            int size = in.readInt();
            if (size > 100) {
                throw new IOException("Corrupted data format");
            }
            int[] offsets = null;
            char[] kinds = null;
            if (size != 0) {
                int i2;
                offsets = new int[size];
                kinds = new char[size];
                for (i2 = 0; i2 < offsets.length; ++i2) {
                    offsets[i2] = in.readInt();
                }
                for (i2 = 0; i2 < kinds.length; ++i2) {
                    kinds[i2] = ver == 2 ? MyDataExternalizer.getV2Char(in.readByte()) : in.readChar();
                }
            }
            if (ver < 3) {
                return new MetaData(srcVersion, contentHash, offsets, kinds, 0, 0);
            }
            int maj = in.readInt();
            int min = in.readInt();
            return new MetaData(srcVersion, contentHash, offsets, kinds, maj, min);
        }

        private static char getV2Char(byte ord) {
            return OLD_KINDS.charAt(ord >= 0 && ord < OLD_KINDS.length() ? (int)ord : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MyDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyKeyDescriptor
    implements KeyDescriptor<ObjectPath> {
        private MyKeyDescriptor() {
        }

        public int getHashCode(ObjectPath value2) {
            return Comparing.hashcode((Object)value2);
        }

        public boolean isEqual(ObjectPath val1, ObjectPath val2) {
            return Comparing.equal((Object)val1, (Object)val2);
        }

        public void save(@NotNull DataOutput out, ObjectPath value2) throws IOException {
            if (out == null) {
                MyKeyDescriptor.$$$reportNull$$$0(0);
            }
            int size = ObjectPaths.getLength(value2);
            out.write(size);
            value2.forEach(v -> {
                out.writeUTF(v.name);
                out.writeUTF(v.kind.code());
                String d2 = value2.getIdentity();
                out.writeBoolean(d2 != null);
                if (d2 != null) {
                    out.writeUTF(d2);
                }
            });
        }

        public ObjectPath read(@NotNull DataInput in) throws IOException {
            int size;
            if (in == null) {
                MyKeyDescriptor.$$$reportNull$$$0(1);
            }
            if ((size = in.readInt()) > 10) {
                throw new IOException("Corrupted key format");
            }
            ObjectPath result2 = null;
            for (int i2 = 0; i2 < size; ++i2) {
                String name = DbUtil.intern(in.readUTF());
                String code = DbUtil.intern(in.readUTF());
                ObjectKind kind = (ObjectKind)ObjectUtils.notNull((Object)DbSrcUtilsCore.findKind(code), (Object)ObjectKind.NONE);
                String id = i2 == size - 1 && in.readBoolean() ? in.readUTF() : null;
                result2 = ObjectPath.create(name, kind, true, id, result2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MyKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MetaData {
        public static final MetaData EMPTY = new MetaData(null, 0, null, null, Integer.MIN_VALUE, Integer.MIN_VALUE);
        public final Long srcVersion;
        public final int contentHash;
        public final int[] offsets;
        public final char[] kinds;
        public final int introContentVersion;
        public final int genContentVersion;

        public static boolean isEmpty(@Nullable MetaData metaData) {
            return metaData == null || metaData.equals(EMPTY);
        }

        public MetaData(Long srcVersion, int contentHash, int[] offsets, char[] kinds, int introContentVersion, int genContentVersion) {
            this.srcVersion = srcVersion;
            this.contentHash = contentHash;
            this.offsets = offsets;
            this.kinds = kinds;
            this.introContentVersion = introContentVersion;
            this.genContentVersion = genContentVersion;
        }

        @NotNull
        public static MetaData modSrcVersion(@Nullable MetaData data, @Nullable Long srcVersion) {
            if (data == null) {
                data = EMPTY;
            }
            return new MetaData(srcVersion, data.contentHash, data.offsets, data.kinds, data.introContentVersion, data.genContentVersion);
        }

        @NotNull
        public static MetaData modContentVersion(@Nullable MetaData data, int introVer, int genVer) {
            if (data == null) {
                data = EMPTY;
            }
            return new MetaData(data.srcVersion, data.contentHash, data.offsets, data.kinds, introVer, genVer);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaData data = (MetaData)o;
            if (this.contentHash != data.contentHash) {
                return false;
            }
            if (this.srcVersion != null ? !this.srcVersion.equals(data.srcVersion) : data.srcVersion != null) {
                return false;
            }
            if (!Arrays.equals(this.offsets, data.offsets)) {
                return false;
            }
            if (!Arrays.equals(this.kinds, data.kinds)) {
                return false;
            }
            if (this.introContentVersion != data.introContentVersion) {
                return false;
            }
            return this.genContentVersion == data.genContentVersion;
        }

        public int hashCode() {
            int result2 = this.srcVersion != null ? this.srcVersion.hashCode() : 0;
            result2 = 31 * result2 + this.contentHash;
            result2 = 31 * result2 + Arrays.hashCode(this.offsets);
            result2 = 31 * result2 + Arrays.hashCode(this.kinds);
            result2 = 31 * result2 + this.introContentVersion;
            result2 = 31 * result2 + this.genContentVersion;
            return result2;
        }
    }
}

