/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.NoCredentialsAuthProvider;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseCredentialsAuthProvider
implements DatabaseAuthProvider {
    private static final Logger LOG = Logger.getInstance(DatabaseCredentialsAuthProvider.class);
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";

    @Override
    public @Nullable CompletionStage<@NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(0);
        }
        return DatabaseCredentialsAuthProvider.applyInitialCredentials(proto, silent).unwrap();
    }

    @Override
    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource2) {
        if (credentials == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(1);
        }
        if (dataSource2 == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(2);
        }
        return DatabaseUiService.getInstance().createUserPassWidget(credentials, dataSource2);
    }

    @Override
    @Nullable
    public CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull SQLException e, boolean silent, int attempt) {
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(3);
        }
        if (e == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(4);
        }
        return DatabaseCredentialsAuthProvider.handleCredentialsFailure(proto, e, silent, attempt);
    }

    @Nullable
    public static CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> handleCredentialsFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull SQLException e, boolean silent, int attempt) {
        AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> passwordResolution;
        Boolean requestPassword;
        Credentials credentials;
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(5);
        }
        if (e == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(6);
        }
        String user = StringUtil.notNullize((String)((credentials = DatabaseCredentialsAuthProvider.extractCredentials(proto)) == null ? null : credentials.getUserName()), (String)USER_KEY);
        boolean passIsEmpty = StringUtil.isEmpty((String)(credentials == null ? null : credentials.getPasswordAsString()));
        String message2 = DatabaseCredentialsAuthProvider.getMessage(e);
        Dbms dbms = proto.getConnectionPoint().getDataSource().getDbms();
        Boolean bl = requestPassword = attempt < 20 ? DatabaseCredentialsAuthProvider.mayRequestPassword(dbms, e, user) : Boolean.FALSE;
        if ((Boolean.TRUE.equals(requestPassword) || requestPassword == null && passIsEmpty && attempt == 0) && (passwordResolution = DatabaseCredentialsAuthProvider.resolvePasswordIssues(message2, credentials, proto, silent, attempt)) != null) {
            return passwordResolution.unwrap();
        }
        return null;
    }

    @NotNull
    private static String getMessage(@NotNull SQLException e) {
        if (e == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(7);
        }
        Throwable ex = AsyncUtil.unwrap(e);
        String message2 = JdbcUtil.getLongMessage(ex);
        Object object = e == ex ? message2 : JdbcUtil.getLongMessage(e) + "\n" + message2;
        if (object == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(8);
        }
        return object;
    }

    private static AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> resolvePasswordIssues(@NotNull String message2, @Nullable Credentials credentials, @NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent, int attempt) {
        if (message2 == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(9);
        }
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(10);
        }
        LocalDataSource dataSource2 = proto.getConnectionPoint().getDataSource();
        DatabaseCredentials dc = proto.getCredentials();
        if (attempt == 0 && "user-pass".equals(dataSource2.getAuthProviderId()) && !Comparing.equal((Object)credentials, (Object)dc.getCredentials(dataSource2))) {
            return AsyncTask.completed(DatabaseCredentialsAuthProvider.applyCredentials(proto, dc.getCredentials(dataSource2), true));
        }
        if (silent) {
            return null;
        }
        return DatabaseCredentialsAuthProvider.askPasswordAsync(proto, message2);
    }

    private static AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> askPasswordAsync(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, String message2) {
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(11);
        }
        return DatabaseCredentialsAuthProvider.askCredentialsWhenFailed(proto, DatabaseBundle.message("dialog.message.html.specified.database.user.password.combination.rejected.choice.br.html", message2, message2.isEmpty() ? 0 : 1), true);
    }

    @Nullable
    private static Boolean mayRequestPassword(@NotNull Dbms dbms, @NotNull SQLException e, @Nullable String user) {
        if (dbms == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(12);
        }
        if (e == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(13);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        Boolean request = DatabaseErrorHandler.EP.forDbms(dbms).mayRequestPassword(e);
        if (request != null) {
            return request;
        }
        String message2 = DatabaseCredentialsAuthProvider.getMessage(e);
        String userPart = StringUtil.isNotEmpty((String)user) ? "|" + StringUtil.escapeToRegexp((String)user) : "";
        String regex = "(?i)\\b(access|denied|password|user|authentication failed" + userPart + ")\\b";
        return Pattern.compile(regex).matcher(message2).find() ? Boolean.valueOf(true) : null;
    }

    @Override
    @NotNull
    public String getId() {
        return "user-pass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("database.auth.type.user.password", new Object[0]);
        if (string == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(15);
        }
        if (!NoCredentialsAuthProvider.isAuthRequired(dataSource2, false, false)) {
            return true;
        }
        DatabaseDriver driver = DbImplUtilCore.guessDatabaseDriver(dataSource2.getDbms());
        return driver == null || !driver.isPredefined();
    }

    @Override
    public void setNewPassword(DatabaseConnectionInterceptor.ProtoConnection proto, String newPass) {
        DatabaseCredentialsAuthProvider.applyNewPassword(proto, newPass);
    }

    public static void applyNewPassword(DatabaseConnectionInterceptor.ProtoConnection proto, String newPass) {
        proto.getCredentials().setPassword(proto.getConnectionPoint().getDataSource(), new OneTimeString(newPass));
        DatabaseCredentialsAuthProvider.applyCredentials(proto, new Credentials(DatabaseCredentialsAuthProvider.getUser(proto), newPass), false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static AsyncTask<Credentials> getInitialCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(16);
        }
        return DatabaseCredentialsAuthProvider.applyInitialCredentials(proto, silent).apply(null, p2 -> DatabaseCredentialsAuthProvider.extractCredentials(p2));
    }

    @Nullable
    public static Credentials extractCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection p2) {
        if (p2 == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(17);
        }
        String user = DatabaseCredentialsAuthProvider.getUser(p2);
        String pass = DatabaseCredentialsAuthProvider.getPassword(p2);
        return StringUtil.isEmpty((String)user) && StringUtil.isEmpty((String)pass) ? null : new Credentials(user, pass);
    }

    public static AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> applyInitialCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        boolean canAskPassword;
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(18);
        }
        LocalDataSource dataSource2 = proto.getConnectionPoint().getDataSource();
        boolean bl = canAskPassword = !silent;
        if (!dataSource2.getPasswordStorage().isPersisted() && dataSource2.isConfiguredByUrl()) {
            JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(dataSource2);
            boolean hardcoded = parsed != null && parsed.isValid() && parsed.getParameter(PASSWORD_KEY) != null;
            canAskPassword &= !hardcoded;
        }
        return DatabaseCredentials.getInitialCredentialsImpl(dataSource2.getPasswordStorage(), canAskPassword, () -> AsyncTask.currentFrame().wrap(null, () -> proto.getCredentials().getCredentialsAsync(dataSource2)).apply(null, c2 -> Pair.create((Object)DatabaseCredentialsAuthProvider.applyCredentials(proto, c2, false), (Object)(c2 == null || c2.getPassword() == null ? 1 : 0))), th -> (th == null ? DatabaseCredentialsAuthProvider.askNoCredentials(proto) : DatabaseCredentialsAuthProvider.askCredentialsWhenFailed(proto, th.getMessage(), true)).apply(null, p2 -> Pair.create((Object)p2, (Object)false)), c2 -> (Boolean)c2.second).apply(null, p2 -> (DatabaseConnectionInterceptor.ProtoConnection)p2.first);
    }

    private static AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> askNoCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto) {
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(19);
        }
        return DatabaseCredentialsAuthProvider.askCredentialsWhenFailed(proto, DatabaseBundle.message("dialog.message.html.please.provide.database.credentials.html", new Object[0]), false);
    }

    @NotNull
    public static AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> askCredentialsWhenFailed(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NlsContexts.DialogMessage @Nullable String message2, boolean error2) {
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(20);
        }
        LocalDataSource dataSource2 = proto.getConnectionPoint().getDataSource();
        Project project = proto.getRunConfiguration().getProject();
        DatabaseCredentials dc = proto.getCredentials();
        if (project.isDefault()) {
            AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.cancelled();
            if (asyncTask == null) {
                DatabaseCredentialsAuthProvider.$$$reportNull$$$0(21);
            }
            return asyncTask;
        }
        Credentials c1 = dc.getCredentials(dataSource2);
        AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.frame(DatabaseBundle.message("progress.title.re.ask.credentials", new Object[0])).computeAsync(DatabaseCredentialsUi.EXECUTOR, () -> {
            CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> intercepted;
            DatabaseAuthProvider provider;
            Credentials c2 = dc.getCredentials(dataSource2);
            if (Comparing.equal((Object)c1, (Object)c2)) {
                DatabaseUiService.getInstance().askCredentials(message2, error2, dataSource2, project, dc);
            }
            if ((provider = DatabaseAuthProvider.get(dataSource2.getAuthProviderId())) == null) {
                provider = DatabaseAuthProvider.getDefault(dataSource2);
            }
            return (intercepted = provider.intercept(proto, true)) == null ? AsyncTask.completed(proto) : AsyncTask.currentFrame().wrap(intercepted);
        });
        if (asyncTask == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(22);
        }
        return asyncTask;
    }

    public static DatabaseConnectionInterceptor.ProtoConnection applyCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @Nullable Credentials credentials, boolean cancelOnEmpty) {
        String password;
        String userName;
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(23);
        }
        if (credentials == null && cancelOnEmpty) {
            throw new ProcessCanceledException();
        }
        String string = userName = credentials == null ? null : credentials.getUserName();
        if (StringUtil.isNotEmpty((String)userName)) {
            LOG.info("Connecting as: " + userName);
            proto.getConnectionProperties().put(USER_KEY, userName);
        } else {
            LOG.info("No user name provided (may be in url)");
            proto.getConnectionProperties().remove(USER_KEY);
        }
        String string2 = password = credentials == null ? null : credentials.getPasswordAsString();
        if (StringUtil.isNotEmpty((String)password)) {
            proto.getConnectionProperties().put(PASSWORD_KEY, password);
        } else {
            proto.getConnectionProperties().remove(PASSWORD_KEY);
        }
        return proto;
    }

    @Nullable
    public static String getUser(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto) {
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(24);
        }
        return proto.getConnectionProperties().get(USER_KEY);
    }

    @Nullable
    public static String getPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto) {
        if (proto == null) {
            DatabaseCredentialsAuthProvider.$$$reportNull$$$0(25);
        }
        return proto.getConnectionProperties().get(PASSWORD_KEY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 14: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 14: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 14: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseCredentialsAuthProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseCredentialsAuthProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "askCredentialsWhenFailed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleConnectionFailure";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleCredentialsFailure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 8: 
            case 14: 
            case 21: 
            case 22: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolvePasswordIssues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "askPasswordAsync";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mayRequestPassword";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCredentials";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractCredentials";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyInitialCredentials";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "askNoCredentials";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "askCredentialsWhenFailed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyCredentials";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getUser";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPassword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 14: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

