/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.client;

import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.SessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SessionClientHolder<S, P extends Parameters> {
    public static final DataKey<SessionClient> CLIENT_KEY = DataKey.create((String)"SESSION_CLIENT_KEY");
    private final Class<S> myClazz;

    protected SessionClientHolder(@NotNull Class<S> clazz) {
        if (clazz == null) {
            SessionClientHolder.$$$reportNull$$$0(0);
        }
        this.myClazz = clazz;
    }

    @Nullable
    public S getClient(@NotNull AnActionEvent e) {
        SessionClient client;
        if (e == null) {
            SessionClientHolder.$$$reportNull$$$0(1);
        }
        if ((client = (SessionClient)e.getData(CLIENT_KEY)) != null) {
            return (S)(this.myClazz.isInstance(client) ? client : null);
        }
        return this.getClient(e.getProject(), (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    @Nullable
    public S getClient(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        for (S client : this.getActiveClients(project)) {
            if (!Comparing.equal((Object)this.getFile(client), (Object)file)) continue;
            return client;
        }
        return null;
    }

    @Nullable
    protected Object getFile(@NotNull S client) {
        if (client == null) {
            SessionClientHolder.$$$reportNull$$$0(2);
        }
        return client instanceof JdbcConsoleCore ? ((JdbcConsoleCore)client).getVirtualFile() : (client instanceof DatabaseSessionClientWithFile ? ((DatabaseSessionClientWithFile)client).getVirtualFile() : null);
    }

    @NotNull
    protected abstract List<S> getActiveClients(@NotNull Project var1);

    protected abstract void register(@NotNull Project var1, @NotNull S var2);

    @NotNull
    public S createClient(@NotNull P parameters) {
        if (parameters == null) {
            SessionClientHolder.$$$reportNull$$$0(3);
        }
        S session2 = this.createClientInner(parameters);
        this.register(((Parameters)parameters).project, session2);
        S s2 = session2;
        if (s2 == null) {
            SessionClientHolder.$$$reportNull$$$0(4);
        }
        return s2;
    }

    @NotNull
    protected abstract S createClientInner(@NotNull P var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/client/SessionClientHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/client/SessionClientHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClient";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createClient";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Parameters {
        public final Project project;
        public final DatabaseSession session;

        protected Parameters(@NotNull Project project, @NotNull DatabaseSession session2) {
            if (project == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            this.project = project;
            this.session = session2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/client/SessionClientHolder$Parameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

