/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCliDialogValidator
implements CliDialogValidator,
Disposable {
    private final ThreadPoolExecutor myExecutor;
    private final String[] myFileArgs;
    private final String[] myPasswordArgs;
    private final Map<String, ThreeState> myValidatedFiles;

    public SimpleCliDialogValidator(String @NotNull [] fileArgs, String @NotNull [] passwordArgs) {
        if (fileArgs == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(0);
        }
        if (passwordArgs == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(1);
        }
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Cli dialog validator");
        this.myFileArgs = fileArgs;
        this.myPasswordArgs = passwordArgs;
        this.myValidatedFiles = new ConcurrentHashMap<String, ThreeState>();
    }

    @Override
    @Nullable
    public ValidationInfo createInfo(@NotNull CliModel model) {
        if (model == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(2);
        }
        return !this.checkExecutablePath(model) ? new ValidationInfo(DatabaseBundle.message("dialog.message.path.to.executable.wrong", new Object[0]), model.getPreferredFocusableComponent()) : (!this.checkPassword(model) ? new ValidationInfo(DatabaseBundle.message("dialog.message.password.request.not.allowed.here", new Object[0]), model.getCommandComponent()) : (!this.checkFilePath(model) ? new ValidationInfo(DatabaseBundle.message("dialog.message.path.to.file.empty", new Object[0]), this.findPathComponent(model)) : null));
    }

    private boolean checkPassword(@NotNull CliModel settings) {
        if (settings == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(3);
        }
        return SimpleCliDialogValidator.checkArgumentNonEmpty(settings, this.myPasswordArgs);
    }

    @Nullable
    protected JComponent findPathComponent(@NotNull CliModel settings) {
        List<CliComponent> components;
        CliComponent component;
        if (settings == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(4);
        }
        return (component = (CliComponent)ContainerUtil.find(components = settings.getCliComponents(), c2 -> {
            String[] args = c2.getArgument().getArguments();
            String intersection = (String)ContainerUtil.find((Object[])this.myFileArgs, arg -> ArrayUtil.find((Object[])args, (Object)arg) != -1);
            return intersection != null;
        })) == null ? null : component.getComponent();
    }

    protected boolean checkFilePath(@NotNull CliModel settings) {
        if (settings == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(5);
        }
        return settings.getContext().contains(this.myFileArgs);
    }

    private static boolean checkArgumentNonEmpty(@NotNull CliModel model, String @NotNull [] args) {
        List<String> parameterizable;
        String command;
        String value2;
        if (model == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(6);
        }
        if (args == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(7);
        }
        return (value2 = DbCliUtil.getArgumentValue(command = model.getCommand(), parameterizable = model.getParameterizable(), args)) == null || !StringUtil.isEmptyOrSpaces((String)value2);
    }

    private boolean checkExecutablePath(@NotNull CliModel model) {
        String executable;
        if (model == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(8);
        }
        return this.checkFile(executable = model.getPathToExecutable()) && this.startFileValidation(executable, model.getConfiguration());
    }

    private boolean startFileValidation(@NotNull String path, @NotNull CliConfiguration configuration) {
        if (path == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(10);
        }
        if (this.myValidatedFiles.containsKey(path)) {
            return true;
        }
        this.myValidatedFiles.put(path, ThreeState.UNSURE);
        this.myExecutor.execute(new MyValidationTask(path, configuration));
        return true;
    }

    private boolean checkFile(@NotNull String path) {
        if (path == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(11);
        }
        File file = new File(path);
        ThreeState state = this.myValidatedFiles.get(path);
        return file.exists() && file.isFile() && Files.isExecutable(Paths.get(path, new String[0])) && (state == ThreeState.UNSURE || state == ThreeState.YES || state == null);
    }

    public void dispose() {
        this.myExecutor.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutor.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @NotNull
    private static String readStream(@NotNull InputStream stream) {
        if (stream == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(12);
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String s2;
            while ((s2 = br.readLine()) != null) {
                sb.append(s2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = sb.toString();
        if (string == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static Process createProcess(@NotNull GeneralCommandLine line) {
        if (line == null) {
            SimpleCliDialogValidator.$$$reportNull$$$0(14);
        }
        try {
            return line.createProcess();
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileArgs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwordArgs";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/SimpleCliDialogValidator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/SimpleCliDialogValidator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkPassword";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPathComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFilePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkArgumentNonEmpty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkExecutablePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startFileValidation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readStream";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyValidationTask
    implements Runnable {
        private final String myPath;
        private final CliConfiguration myConfiguration;

        private MyValidationTask(@NotNull String path, CliConfiguration configuration) {
            if (path == null) {
                MyValidationTask.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                MyValidationTask.$$$reportNull$$$0(1);
            }
            this.myPath = path;
            this.myConfiguration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{this.myPath, this.myConfiguration.getValidationCommand()});
            Process process2 = SimpleCliDialogValidator.createProcess(line);
            if (process2 == null) {
                SimpleCliDialogValidator.this.myValidatedFiles.put(this.myPath, ThreeState.NO);
                return;
            }
            try {
                String output = SimpleCliDialogValidator.readStream(process2.getInputStream());
                SimpleCliDialogValidator.this.myValidatedFiles.put(this.myPath, ThreeState.fromBoolean((boolean)StringUtil.contains((CharSequence)output, (CharSequence)this.myConfiguration.getPartOfValidationOut())));
            }
            finally {
                process2.destroyForcibly();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/cli/SimpleCliDialogValidator$MyValidationTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

