/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ManageDataSourcesAction
extends DumbAwareAction {
    static DbDataSource getDataSourceFromEvent(@NotNull AnActionEvent e) {
        if (e == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(0);
        }
        PsiElement element2 = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DasDataSource system = (DasDataSource)ObjectUtils.coalesce((Object)DataGridUtil.getDatabaseSystem(dataGrid), (Object)DbImplUtilCore.getForcedDataSource(file), (Object)((DbDataSource)PsiTreeUtil.getParentOfType((PsiElement)element2, DbDataSource.class, (boolean)false)));
        return (DbDataSource)ObjectUtils.tryCast((Object)system, DbDataSource.class);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DataSourceManagerDialog.showDialog(project, (Object)ManageDataSourcesAction.getDataSourceFromEvent(e), null);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(2);
        }
        KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class);
        boolean mainMenu = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        if (mainMenu) {
            e.getPresentation().setText(DatabaseBundle.message("action.DatabaseView.PropertiesAction.menu.text", new Object[0]));
        } else if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setText(DatabaseBundle.message("action.DatabaseView.PropertiesAction.popup.text", new Object[0]));
        }
        PsiElement element2 = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        DbPsiFacade facade = (DbPsiFacade)((Object)e.getData(DatabaseDataKeysCore.DB_PSI_FACADE));
        DbDataSource dataSource2 = (DbDataSource)PsiTreeUtil.getParentOfType((PsiElement)element2, DbDataSource.class, (boolean)false);
        boolean bl = enabled = mainMenu && keyEvent == null && e.getProject() != null || facade != null && (e.isFromActionToolbar() || dataSource2 != null && element2 == dataSource2);
        if (PlatformUtils.isDataGrip()) {
            KeyboardShortcut shortcut;
            boolean flag = e.getProject() != null && (mainMenu || enabled);
            e.getPresentation().setEnabledAndVisible(flag);
            if (!(enabled || keyEvent == null || (shortcut = e.getActionManager().getKeyboardShortcut(e.getActionManager().getId((AnAction)this))) != null && Comparing.equal((Object)KeyStroke.getKeyStrokeForEvent(keyEvent), (Object)shortcut.getFirstKeyStroke()))) {
                e.getPresentation().setEnabled(false);
            }
        } else {
            e.getPresentation().setEnabledAndVisible(enabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/actions/ManageDataSourcesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataSourceFromEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

