/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J:\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010JF\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010J \u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder;", "", "()V", "createByteToCharMap", "", "", "byteOffsets", "Ljava/util/SortedSet;", "contentInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion$ContentInfo;", "createFor", "", "errors", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangTidyError;", "unsavedFilePaths", "", "fileToByteOffset", "getContentInfo", "filePath", "Companion", "intellij.c.clangd"})
public final class ByteToCharOffsetMapBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Map<Integer, Integer>> createFor(@NotNull List<? extends ClionClangTidyError> errors, @NotNull Collection<String> unsavedFilePaths) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        Intrinsics.checkNotNullParameter(unsavedFilePaths, (String)"unsavedFilePaths");
        HashMap fileToByteOffset = new HashMap();
        for (ClionClangTidyError clionClangTidyError : errors) {
            Iterator<Object> iterator;
            String string = clionClangTidyError.getFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"error.filePath");
            Companion.addOffset(string, clionClangTidyError.getFileOffset(), fileToByteOffset);
            if (clionClangTidyError.getReplacements() != null) {
                iterator = clionClangTidyError.getReplacements().iterator();
                while (iterator.hasNext()) {
                    ClionClangTidyReplacement replacement;
                    ClionClangTidyReplacement clionClangTidyReplacement = replacement = (ClionClangTidyReplacement)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)clionClangTidyReplacement, (String)"replacement");
                    String string2 = clionClangTidyReplacement.getFilePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replacement.filePath");
                    Companion.addOffset(string2, replacement.getOffset(), fileToByteOffset);
                    String string3 = replacement.getFilePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"replacement.filePath");
                    Companion.addOffset(string3, replacement.getOffset() + replacement.getLength(), fileToByteOffset);
                }
            }
            if (clionClangTidyError.getRanges() == null) continue;
            iterator = clionClangTidyError.getRanges().iterator();
            while (iterator.hasNext()) {
                ClangTidyRange range;
                ClangTidyRange clangTidyRange = range = (ClangTidyRange)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)clangTidyRange, (String)"range");
                String string4 = clangTidyRange.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"range.filePath");
                CharSequence charSequence = string4;
                boolean bl = false;
                if (!(charSequence.length() > 0)) continue;
                String string5 = range.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"range.filePath");
                Companion.addOffset(string5, range.getFileOffset(), fileToByteOffset);
                String string6 = range.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"range.filePath");
                Companion.addOffset(string6, range.getFileOffset() + range.getLength(), fileToByteOffset);
            }
        }
        return this.createFor(fileToByteOffset, unsavedFilePaths);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Map<Integer, Integer>> createFor(@NotNull Map<String, ? extends SortedSet<Integer>> fileToByteOffset, @NotNull Collection<String> unsavedFilePaths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileToByteOffset, (String)"fileToByteOffset");
        Intrinsics.checkNotNullParameter(unsavedFilePaths, (String)"unsavedFilePaths");
        Map<String, ? extends SortedSet<Integer>> $this$map$iv = fileToByteOffset;
        boolean $i$f$map = false;
        Map<String, ? extends SortedSet<Integer>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String filePath = (String)it.getKey();
            SortedSet byteOffsets = (SortedSet)it.getValue();
            Companion.ContentInfo contentInfo = this.getContentInfo(filePath, unsavedFilePaths);
            Pair pair = TuplesKt.to((Object)filePath, this.createByteToCharMap(byteOffsets, contentInfo));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Map<Integer, Integer> createByteToCharMap(SortedSet<Integer> byteOffsets, Companion.ContentInfo contentInfo) {
        Integer byteOffset;
        if (contentInfo == null) {
            return MapsKt.emptyMap();
        }
        HashMap byteToCharMap = new HashMap();
        int lastCharOffset = 0;
        int lastByteOffset = contentInfo.getBomLength();
        Iterator iterator = byteOffsets.iterator();
        while (iterator.hasNext() && (byteOffset = (Integer)iterator.next()) <= contentInfo.getContent().length) {
            String sliceWithUnifiedSeparators;
            Integer n = byteOffset;
            Intrinsics.checkNotNull((Object)n);
            int sliceLength = Math.max(0, n - lastByteOffset);
            byte[] byArray = contentInfo.getContent();
            Charset charset = contentInfo.getEncoding();
            boolean bl = false;
            String slice = new String(byArray, lastByteOffset, sliceLength, charset);
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.convertLineSeparators((String)slice), (String)"StringUtil.convertLineSeparators(slice)");
            int charOffset = lastCharOffset + sliceWithUnifiedSeparators.length();
            ((Map)byteToCharMap).put(byteOffset, charOffset);
            lastCharOffset = charOffset;
            lastByteOffset = byteOffset;
        }
        return byteToCharMap;
    }

    private final Companion.ContentInfo getContentInfo(String filePath, Collection<String> unsavedFilePaths) {
        VirtualFile virtualFile;
        boolean bl;
        FileDocumentManager manager;
        block7: {
            CharSequence charSequence = filePath;
            boolean bl2 = false;
            if (charSequence.length() == 0) {
                return null;
            }
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
            manager = fileDocumentManager;
            Iterable $this$any$iv = unsavedFilePaths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!FileUtil.pathsEqual((String)it, (String)filePath)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl && (virtualFile = VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true)) != null) {
            boolean $i$f$runReadAction = false;
            Document document = (Document)ApplicationManager.getApplication().runReadAction(new Computable(manager, virtualFile){
                final /* synthetic */ FileDocumentManager $manager$inlined;
                final /* synthetic */ VirtualFile $virtualFile$inlined;
                {
                    this.$manager$inlined = fileDocumentManager;
                    this.$virtualFile$inlined = virtualFile;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$manager$inlined.getDocument(this.$virtualFile$inlined);
                }
            });
            if (document != null) {
                Charset documentEncoding = Charsets.UTF_8;
                boolean $i$f$runReadAction2 = false;
                byte[] content = (byte[])ApplicationManager.getApplication().runReadAction(new Computable(document, documentEncoding){
                    final /* synthetic */ Document $document$inlined;
                    final /* synthetic */ Charset $documentEncoding$inlined;
                    {
                        this.$document$inlined = document;
                        this.$documentEncoding$inlined = charset;
                    }

                    public final T compute() {
                        boolean bl = false;
                        String string = this.$document$inlined.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
                        String string2 = string;
                        Charset charset = this.$documentEncoding$inlined;
                        boolean bl2 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = string3.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        return (T)byArray;
                    }
                });
                return new Companion.ContentInfo(content, documentEncoding, ByteToCharOffsetMapBuilder.Companion.getBomLength(content, documentEncoding));
            }
        }
        if ((virtualFile = VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true)) == null) {
            return null;
        }
        byte[] content = FileUtil.loadFileBytes((File)new File(filePath));
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"content");
        Charset charset = virtualFile.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"virtualFile.charset");
        Charset charset2 = virtualFile.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"virtualFile.charset");
        return new Companion.ContentInfo(content, charset, ByteToCharOffsetMapBuilder.Companion.getBomLength(content, charset2));
    }

    @JvmStatic
    public static final void addOffset(@NotNull String filePath, int offset, @NotNull Map<String, SortedSet<Integer>> result) {
        Companion.addOffset(filePath, offset, result);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0007J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion;", "", "()V", "addOffset", "", "filePath", "", "offset", "", "result", "", "Ljava/util/SortedSet;", "getBomLength", "content", "", "encoding", "Ljava/nio/charset/Charset;", "ContentInfo", "intellij.c.clangd"})
    public static final class Companion {
        private final int getBomLength(byte[] content, Charset encoding) {
            return CharsetToolkit.getBOMLength((byte[])content, (Charset)encoding);
        }

        @JvmStatic
        public final void addOffset(@NotNull String filePath, int offset, @NotNull Map<String, SortedSet<Integer>> result) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            if (!result.containsKey(filePath)) {
                result.put(filePath, new TreeSet());
            }
            SortedSet<Integer> sortedSet = result.get(filePath);
            Intrinsics.checkNotNull(sortedSet);
            sortedSet.add(offset);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion$ContentInfo;", "", "content", "", "encoding", "Ljava/nio/charset/Charset;", "bomLength", "", "([BLjava/nio/charset/Charset;I)V", "getBomLength", "()I", "getContent", "()[B", "getEncoding", "()Ljava/nio/charset/Charset;", "intellij.c.clangd"})
        private static final class ContentInfo {
            @NotNull
            private final byte[] content;
            @NotNull
            private final Charset encoding;
            private final int bomLength;

            @NotNull
            public final byte[] getContent() {
                return this.content;
            }

            @NotNull
            public final Charset getEncoding() {
                return this.encoding;
            }

            public final int getBomLength() {
                return this.bomLength;
            }

            public ContentInfo(@NotNull byte[] content, @NotNull Charset encoding, int bomLength) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
                this.content = content;
                this.encoding = encoding;
                this.bomLength = bomLength;
            }
        }
    }
}

