/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ModalityUiUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangExecuteCommandAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdDumpServerState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdLogPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdLogPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.CloseClangdToolWindowAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.SetClangdProjectData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.SetInputMirrorFileAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.SetTraceFileAction;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdLogPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lastEditor", "Lcom/intellij/openapi/editor/Editor;", "SetCompileCommandAction", "intellij.c.clangd"})
public final class ClangdLogPanel
extends ClangdPanelBase {
    private Editor lastEditor;

    public ClangdLogPanel(@NotNull Project project) {
        ConsoleViewImpl consoleViewImpl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConsoleView consoleView = new TextConsoleBuilderImpl(project).getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"TextConsoleBuilderImpl(project).console");
        final ConsoleView consoleView2 = consoleView;
        Disposer.register((Disposable)this, (Disposable)((Disposable)consoleView2));
        this.add(consoleView2.getComponent());
        ConsoleView consoleView3 = consoleView2;
        if (!(consoleView3 instanceof ConsoleViewImpl)) {
            consoleView3 = null;
        }
        if ((consoleViewImpl = (ConsoleViewImpl)consoleView3) != null && (consoleViewImpl = consoleViewImpl.getEditor()) != null && (consoleViewImpl = consoleViewImpl.getSettings()) != null) {
            consoleViewImpl.setUseSoftWraps(false);
        }
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        final TextAttributes methodHighlightAttrs = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        final Pattern methodPattern = Pattern.compile("\"method\": \"(.*?)\"");
        consoleView2.addMessageFilter(new Filter(){

            @Nullable
            public final Filter.Result applyFilter(@NotNull String line, int length) {
                Filter.Result result;
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Matcher matcher = methodPattern.matcher(line);
                int lineStartOffset = length - line.length();
                if (matcher.find()) {
                    int groupStart = lineStartOffset + matcher.start(1);
                    int groupEnd = lineStartOffset + matcher.end(1);
                    result = new Filter.Result(groupStart, groupEnd, null, methodHighlightAttrs);
                } else {
                    result = null;
                }
                return result;
            }
        });
        project.getMessageBus().connect((Disposable)this).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            @Override
            public void onMessage(@NotNull String contents, boolean incoming) {
                Function0 edt2;
                Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
                Function0 function0 = edt2 = (Function0)new Function0<Unit>(this, incoming, contents){
                    final /* synthetic */ 2 this$0;
                    final /* synthetic */ boolean $incoming;
                    final /* synthetic */ String $contents;

                    public final void invoke() {
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = ClangdLogPanelKt.access$getDATE_FORMAT$p().format(System.currentTimeMillis());
                        Intrinsics.checkNotNull((Object)string);
                        String linkText = stringBuilder.append(string).append(' ').append(this.$incoming ? "-->" : "<--").toString();
                        this.this$0.consoleView2.printHyperlink(linkText, new HyperlinkInfo(this, linkText){
                            final /* synthetic */ onMessage.edt.1 this$0;
                            final /* synthetic */ String $linkText;

                            public final void navigate(@NotNull Project it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                ClangdLogPanelKt.access$showJsonInEditor(it, this.this$0.$contents, this.$linkText);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$linkText = string;
                            }
                        });
                        this.this$0.consoleView2.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                        this.this$0.consoleView2.print(ClangdLogPanelKt.access$toOneLine(this.$contents), ConsoleViewContentType.NORMAL_OUTPUT);
                        this.this$0.consoleView2.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$incoming = bl;
                        this.$contents = string;
                        super(0);
                    }
                };
                ModalityUiUtil.invokeLaterIfNeeded((Runnable)new Runnable(function0){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ void run() {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                    }
                }, (ModalityState)ModalityState.defaultModalityState());
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        EditorEventMulticaster editorEventMulticaster = editorFactory.getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"EditorFactory.getInstance().eventMulticaster");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        if (eventMulticaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)eventMulticaster).addFocusChangeListener(new FocusChangeListener(){

                public void focusGained(@NotNull Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    lastEditor = editor;
                }
            }, (Disposable)this);
        }
        AnAction[] anActionArray = new AnAction[7];
        AnAction anAction = ActionManager.getInstance().getAction("ClangdCrashServer");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"ActionManager.getInstanc\u2026tion(\"ClangdCrashServer\")");
        anActionArray[0] = anAction;
        anActionArray[1] = new ClangdDumpServerState();
        anActionArray[2] = (AnAction)new SetInputMirrorFileAction();
        anActionArray[3] = (AnAction)new SetTraceFileAction();
        anActionArray[4] = (AnAction)new SetCompileCommandAction();
        anActionArray[5] = (AnAction)new ClangExecuteCommandAction();
        anActionArray[6] = (AnAction)new CloseClangdToolWindowAction();
        this.createToolbarWithActions(anActionArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J$\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u001a\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdLogPanel$SetCompileCommandAction;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/SetClangdProjectData;", "", "", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdLogPanel;)V", "commandLine2Text", "commandLine", "currentFilePath", "editor", "Lcom/intellij/openapi/editor/Editor;", "getCommandsMap", "", "project", "Lcom/intellij/openapi/project/Project;", "getDialogTitle", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "getValue", "setValue", "", "text", "text2CommandLine", "intellij.c.clangd"})
    public final class SetCompileCommandAction
    extends SetClangdProjectData<List<? extends String>> {
        @Override
        @NotNull
        protected String getDialogTitle(@NotNull Project project, @NotNull DataContext dc) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            return super.getDialogTitle(project, dc) + this.currentFilePath(ClangdLogPanel.this.lastEditor);
        }

        @Override
        @NotNull
        protected String getValue(@NotNull Project project, @NotNull DataContext dc) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            String filePath = this.currentFilePath(ClangdLogPanel.this.lastEditor);
            if (filePath == null) {
                return "";
            }
            Map<String, List<String>> commandsMap = this.getCommandsMap(project);
            List<String> commandLine = commandsMap.get(filePath);
            return this.commandLine2Text(commandLine);
        }

        @Override
        protected void setValue(@NotNull Project project, @NotNull DataContext dc, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String filePath = this.currentFilePath(ClangdLogPanel.this.lastEditor);
            if (filePath == null) {
                return;
            }
            Map<String, List<String>> commandsMap = this.getCommandsMap(project);
            commandsMap.put(filePath, this.text2CommandLine(text));
        }

        private final Map<String, List<String>> getCommandsMap(Project project) {
            Map commandsMap = (Map)project.getUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS);
            if (commandsMap != null) {
                return commandsMap;
            }
            commandsMap = new HashMap();
            project.putUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS, (Object)commandsMap);
            return commandsMap;
        }

        private final List<String> text2CommandLine(String text) {
            if (text == null) {
                return null;
            }
            return CidrSwitchBuilder.parseArgs((String)text, (CidrCompilerSwitches.Format)CidrCompilerSwitches.Format.BASH_SHELL);
        }

        private final String commandLine2Text(List<String> commandLine) {
            if (commandLine == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            boolean rest = false;
            for (String option : commandLine) {
                if (rest) {
                    sb.append(" ");
                }
                sb.append(option);
                rest = true;
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        private final String currentFilePath(Editor editor) {
            if (editor == null) {
                return null;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            return virtualFile != null ? virtualFile.getPath() : null;
        }

        public SetCompileCommandAction() {
            Icon icon = AllIcons.Actions.Properties;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Actions.Properties");
            super("Set compilation command for the current file", icon, "Enter compilation command", "Compilation command for ");
        }
    }
}

