/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class ClangdIndexerService
extends ClangdLanguageService {
    @NotNull
    private final List<String> myAppLog;

    public ClangdIndexerService(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdIndexerService.$$$reportNull$$$0(0);
        }
        super(context);
        this.myAppLog = new LinkedList<String>();
        this.installIndexLoggerIfNeeded();
    }

    @NotNull
    public List<String> getAppLog() {
        List<String> list = Collections.unmodifiableList(this.myAppLog);
        if (list == null) {
            ClangdIndexerService.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public CompletableFuture<Boolean> executeCommand(@NotNull String command) {
        if (command == null) {
            ClangdIndexerService.$$$reportNull$$$0(2);
        }
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction(command).action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionIndexerCommand(new ClionIndexerCommandParams(command))))).onRejected(() -> result.complete(false)).onSkipped(() -> result.complete(false)).requiresRecover().create());
        CompletableFuture<Boolean> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    private void installIndexLoggerIfNeeded() {
        if (ApplicationManager.getApplication().isInternal()) {
            this.getMessageBus().connect(this.getAssociatedDisposable()).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){
                private boolean indexStartedCame = false;
                private int lastReportedPercent = -1;

                @Override
                public void onIndexingStarted() {
                    this.indexStartedCame = true;
                    this.lastReportedPercent = -1;
                }

                @Override
                public void onIndexingProgress(int processed, int total) {
                    int newPercent;
                    if (this.indexStartedCame) {
                        ClangdIndexerService.this.addAppLogMessage("Indexing started: " + total + " TUs to process");
                        this.indexStartedCame = false;
                    }
                    if ((newPercent = Double.valueOf((double)processed / (double)total * 100.0).intValue()) != this.lastReportedPercent) {
                        this.lastReportedPercent = newPercent;
                        ClangdIndexerService.this.addAppLogMessage("Progress: " + newPercent + "%");
                    }
                }

                @Override
                public void onIndexingFinished(@NotNull String path) {
                    if (path == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ClangdIndexerService.this.addAppLogMessage("Indexing finished! (" + path + ")");
                }

                @Override
                public void onIndexingMessage(@NotNull String message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ClangdIndexerService.this.addAppLogMessage(message);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onIndexingFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onIndexingMessage";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private void addAppLogMessage(@NotNull String message) {
        if (message == null) {
            ClangdIndexerService.$$$reportNull$$$0(4);
        }
        if (this.myAppLog.size() >= 4096) {
            this.myAppLog.remove(0);
        }
        this.myAppLog.add(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppLog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAppLogMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

