/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.test;

import com.intellij.httpClient.http.request.run.HttpClientTest;
import com.intellij.httpClient.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.httpClient.http.request.run.test.HttpClientTestUtil;
import com.intellij.openapi.progress.ProgressManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HttpClientTestsRunner {
    private static final String TESTS_SUITE = "Tests";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runTests(@NotNull HttpResponseOutputAdapter printer, @NotNull List<? extends HttpClientTest> tests) {
        if (printer == null) {
            HttpClientTestsRunner.$$$reportNull$$$0(0);
        }
        if (tests == null) {
            HttpClientTestsRunner.$$$reportNull$$$0(1);
        }
        int failedTests = 0;
        HttpClientTestUtil.printSuiteStart(printer, TESTS_SUITE, tests.size());
        for (HttpClientTest httpClientTest : tests) {
            ProgressManager.checkCanceled();
            String name = httpClientTest.getName();
            HttpClientTestUtil.printTestStart(printer, name);
            long start = System.currentTimeMillis();
            long duration = 0L;
            try {
                httpClientTest.run();
                duration = System.currentTimeMillis() - start;
            }
            catch (Throwable e) {
                duration = System.currentTimeMillis() - start;
                ++failedTests;
                HttpClientTestUtil.printTestFailed(printer, name, e.getMessage());
            }
            finally {
                HttpClientTestUtil.printTestEnd(printer, name, duration);
            }
        }
        HttpClientTestUtil.printSuiteEnd(printer, TESTS_SUITE);
        return failedTests;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "printer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tests";
                break;
            }
        }
        objectArray[1] = "com/intellij/httpClient/http/request/run/test/HttpClientTestsRunner";
        objectArray[2] = "runTests";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

