/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl.parser;

import com.intellij.httpClient.converters.curl.Utils;
import com.intellij.httpClient.converters.curl.exceptions.CurlParseException;
import com.intellij.httpClient.converters.curl.parser.CurlDataOption;
import com.intellij.httpClient.converters.curl.parser.CurlDataOptionFactory;
import com.intellij.httpClient.converters.curl.parser.CurlFormData;
import com.intellij.httpClient.converters.curl.parser.HttpRequestCurlTokenizer;
import com.intellij.httpClient.execution.RestClientFormBodyPart;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurlParser {
    private static final String BOUNDARY = "WebAppBoundary";
    private static final String MULTIPART_FORM_HEADER_VALUE = "multipart/form-data";
    private static final String URLENCODED_HEADER_VALUE = "application/x-www-form-urlencoded";
    private String myContentType;
    private String myAuthSchemes;
    private boolean myHasRequestBody;

    @NotNull
    public RestClientRequest parseToRestClientRequest(@NotNull String inputString) throws CurlParseException {
        if (inputString == null) {
            CurlParser.$$$reportNull$$$0(0);
        }
        if (!Utils.isCurlString(inputString)) {
            throw CurlParseException.newNotCurlException();
        }
        RestClientRequest restClientRequest = new RestClientRequest();
        List<String> tokens = HttpRequestCurlTokenizer.splitInCurlTokens(inputString);
        int i = 1;
        while (i < tokens.size()) {
            String currentToken = tokens.get(i);
            if (currentToken.equals("\\")) {
                ++i;
                continue;
            }
            String nextToken = null;
            if (i + 1 < tokens.size()) {
                nextToken = tokens.get(i + 1);
            }
            i += this.chooseCategory(restClientRequest, currentToken, CurlParser.deleteBackslashes(nextToken));
        }
        if (restClientRequest.urlBase == null) {
            throw CurlParseException.newNoUrlException();
        }
        this.setHttpMethodToRequest(restClientRequest);
        if (this.myContentType != null) {
            this.addContentTypeHeaderToRequest(restClientRequest);
        }
        RestClientRequest restClientRequest2 = restClientRequest;
        if (restClientRequest2 == null) {
            CurlParser.$$$reportNull$$$0(1);
        }
        return restClientRequest2;
    }

    private int chooseCategory(@NotNull RestClientRequest request, @NotNull String currentToken, @Nullable String nextToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(2);
        }
        if (currentToken == null) {
            CurlParser.$$$reportNull$$$0(3);
        }
        int shift = 1;
        if (Utils.isLongOption(currentToken)) {
            shift = this.addLongOption(request, currentToken.substring(2), nextToken);
        } else if (Utils.isShortOption(currentToken)) {
            shift = this.addShortOption(request, currentToken.substring(1), nextToken);
        } else {
            CurlParser.addURL(request, currentToken);
        }
        return shift;
    }

    @Nullable
    public static String deleteBackslashes(@Nullable String data) {
        return data != null ? data.replaceAll("\\\\", "") : null;
    }

    private int addShortOption(@NotNull RestClientRequest request, @NotNull String option, @Nullable String nextToken) {
        boolean withoutSpace;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(4);
        }
        if (option == null) {
            CurlParser.$$$reportNull$$$0(5);
        }
        if (Utils.isAlwaysSetShortOption(option)) {
            return 1;
        }
        if (!Utils.isKnownShortOption(option)) {
            throw CurlParseException.newNotSupportedOptionException(option);
        }
        if (option.length() > 1) {
            withoutSpace = true;
            nextToken = option.substring(1);
        } else {
            withoutSpace = false;
        }
        if (nextToken == null) {
            throw CurlParseException.newNoRequiredOptionDataException(option);
        }
        switch (option.charAt(0)) {
            case 'X': {
                CurlParser.addHttpMethodToRequest(request, nextToken);
                break;
            }
            case 'H': {
                this.addHeaderToRequest(request, nextToken);
                break;
            }
            case 'd': {
                this.addDataToRequest("data", request, nextToken);
                break;
            }
            case 'u': {
                this.addAuthorizationDataToRequest(request, nextToken);
                break;
            }
            case 'F': {
                this.addFormDataToRequest(request, nextToken);
            }
        }
        return withoutSpace ? 1 : 2;
    }

    private int addLongOption(@NotNull RestClientRequest request, @NotNull String option, @Nullable String nextToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(6);
        }
        if (option == null) {
            CurlParser.$$$reportNull$$$0(7);
        }
        if (Utils.isAlwaysSetLongOption(option)) {
            return 1;
        }
        if (this.isAuthSchemeOption(request, option)) {
            return 1;
        }
        if (!Utils.isKnownLongOption(option)) {
            throw CurlParseException.newNotSupportedOptionException(option);
        }
        if (nextToken == null) {
            throw CurlParseException.newNoRequiredOptionDataException(option);
        }
        if (option.startsWith("data")) {
            this.addDataToRequest(option, request, nextToken);
            return 2;
        }
        switch (option) {
            case "url": {
                CurlParser.addURL(request, nextToken);
                break;
            }
            case "request": {
                CurlParser.addHttpMethodToRequest(request, nextToken);
                break;
            }
            case "header": {
                this.addHeaderToRequest(request, nextToken);
                break;
            }
            case "user": {
                this.addAuthorizationDataToRequest(request, nextToken);
                break;
            }
            case "form": {
                this.addFormDataToRequest(request, nextToken);
            }
        }
        return 2;
    }

    private void addHeaderToRequest(@NotNull RestClientRequest request, @NotNull String header) {
        RestClientRequest.KeyValuePair keyValueHeaderPair;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(8);
        }
        if (header == null) {
            CurlParser.$$$reportNull$$$0(9);
        }
        if (StringUtil.toLowerCase((String)(keyValueHeaderPair = CurlParser.getKeyValueForHeader(header)).getKey()).equals("content-type")) {
            this.myContentType = this.myContentType != null ? CurlParser.updateContentTypeIfNeeded(request, keyValueHeaderPair.getValue(), this.myContentType) : keyValueHeaderPair.getValue();
        } else {
            request.headers.add(CurlParser.getKeyValueForHeader(header));
        }
    }

    @NotNull
    private static String updateContentTypeIfNeeded(@NotNull RestClientRequest request, @NotNull String headerValue, @NotNull String contentType) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(10);
        }
        if (headerValue == null) {
            CurlParser.$$$reportNull$$$0(11);
        }
        if (contentType == null) {
            CurlParser.$$$reportNull$$$0(12);
        }
        Object updatedContentType = contentType;
        if (request.multipartBoundary != null) {
            if (contentType.equals(MULTIPART_FORM_HEADER_VALUE)) {
                updatedContentType = headerValue;
            }
        } else {
            updatedContentType = contentType.equals(URLENCODED_HEADER_VALUE) ? headerValue : contentType + ", " + headerValue;
        }
        String string = updatedContentType;
        if (string == null) {
            CurlParser.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void addHttpMethodToRequest(@NotNull RestClientRequest request, @NotNull String method) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(14);
        }
        if (method == null) {
            CurlParser.$$$reportNull$$$0(15);
        }
        if (!Utils.isValidRequestOption(method)) {
            throw CurlParseException.newInvalidMethodException(method);
        }
        request.httpMethod = method;
    }

    private void setHttpMethodToRequest(RestClientRequest restClientRequest) {
        if ("TRACE".equals(restClientRequest.httpMethod) && this.myHasRequestBody) {
            throw CurlParseException.newMethodDoNotSupportBodyException(restClientRequest.httpMethod);
        }
        if (restClientRequest.httpMethod == null) {
            restClientRequest.httpMethod = "GET";
        }
    }

    private void addDataToRequest(@NotNull String optionName, @NotNull RestClientRequest request, @NotNull String data) {
        CurlDataOption curlDataOption;
        if (optionName == null) {
            CurlParser.$$$reportNull$$$0(16);
        }
        if (request == null) {
            CurlParser.$$$reportNull$$$0(17);
        }
        if (data == null) {
            CurlParser.$$$reportNull$$$0(18);
        }
        if (request.httpMethod == null) {
            request.httpMethod = "POST";
        }
        if ((curlDataOption = CurlDataOptionFactory.getCurlDataOption(optionName, data)) != null) {
            curlDataOption.apply(request);
        }
        if (this.myContentType == null) {
            this.addHeaderToRequest(request, "Content-Type: application/x-www-form-urlencoded");
        }
        this.myHasRequestBody = true;
    }

    private void addAuthorizationDataToRequest(@NotNull RestClientRequest request, @NotNull String authData) {
        String username;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(19);
        }
        if (authData == null) {
            CurlParser.$$$reportNull$$$0(20);
        }
        AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, this.myAuthSchemes == null ? "Basic" : this.myAuthSchemes);
        String password = "";
        int colonPosition = authData.indexOf(58);
        if (colonPosition < 0) {
            username = authData;
        } else {
            username = authData.substring(0, colonPosition);
            password = authData.substring(colonPosition + 1);
        }
        request.authData = new HttpClientAuthData(authScope, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    private boolean isAuthSchemeOption(@NotNull RestClientRequest request, @NotNull String option) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(21);
        }
        if (option == null) {
            CurlParser.$$$reportNull$$$0(22);
        }
        switch (option) {
            case "basic": {
                this.myAuthSchemes = "Basic";
                break;
            }
            case "digest": {
                this.myAuthSchemes = "Digest";
                break;
            }
            case "ntlm": {
                this.myAuthSchemes = "NTLM";
                break;
            }
            case "negotiate": {
                this.myAuthSchemes = "Negotiate";
                break;
            }
            default: {
                return false;
            }
        }
        if (request.authData != null) {
            AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, this.myAuthSchemes);
            request.authData = new HttpClientAuthData(authScope, request.authData.getAuthCredentials());
        }
        return true;
    }

    private void addFormDataToRequest(@NotNull RestClientRequest request, @NotNull String formData) {
        RestClientFormBodyPart restClientFormBodyPart;
        if (request == null) {
            CurlParser.$$$reportNull$$$0(23);
        }
        if (formData == null) {
            CurlParser.$$$reportNull$$$0(24);
        }
        CurlFormData curlFormData = new CurlFormData(formData);
        String fieldName = curlFormData.getName();
        if (curlFormData.hasFileContent()) {
            File file2 = curlFormData.getFile();
            if (file2 == null) {
                throw CurlParseException.newInvalidPathException(formData);
            }
            String filename = file2.getName();
            restClientFormBodyPart = RestClientFormBodyPart.create(fieldName, filename, file2, curlFormData.getFormContentType()).addHeader("Content-Disposition", "form-data; name=\"" + fieldName + "\"; filename=\"" + filename + "\"");
        } else {
            restClientFormBodyPart = RestClientFormBodyPart.create(fieldName, curlFormData.getContent(), curlFormData.getFormContentType()).addHeader("Content-Disposition", "form-data; name=\"" + fieldName + "\"");
        }
        curlFormData.getHeaders().forEach(additionalHeader -> restClientFormBodyPart.addHeader(additionalHeader.getKey(), additionalHeader.getValue()));
        request.formBodyPart.add(restClientFormBodyPart);
        request.httpMethod = "POST";
        request.isFileUpload = true;
        request.multipartBoundary = BOUNDARY;
        if (this.myContentType == null) {
            this.addHeaderToRequest(request, "Content-Type: multipart/form-data");
        }
    }

    private static void addURL(@NotNull RestClientRequest request, @NotNull String currentToken) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(25);
        }
        if (currentToken == null) {
            CurlParser.$$$reportNull$$$0(26);
        }
        try {
            new URI(currentToken);
            request.urlBase = currentToken;
            request.urlPath = "";
        }
        catch (URISyntaxException e) {
            throw CurlParseException.newInvalidUrlException(currentToken);
        }
    }

    @NotNull
    private static RestClientRequest.KeyValuePair getKeyValueForHeader(@NotNull String header) {
        int colonPosition;
        if (header == null) {
            CurlParser.$$$reportNull$$$0(27);
        }
        if ((colonPosition = header.indexOf(58)) < 0) {
            return new RestClientRequest.KeyValuePair(header.trim().replaceAll(";$", ""), "");
        }
        String name = header.substring(0, colonPosition).trim();
        if (name.isEmpty()) {
            throw CurlParseException.newInvalidHeaderException(header);
        }
        String value = header.substring(colonPosition + 1);
        return new RestClientRequest.KeyValuePair(name, value.trim());
    }

    private void addContentTypeHeaderToRequest(@NotNull RestClientRequest request) {
        if (request == null) {
            CurlParser.$$$reportNull$$$0(28);
        }
        Object header = "Content-Type: ";
        header = request.multipartBoundary != null ? (String)header + this.myContentType + "; boundary=WebAppBoundary" : (String)header + this.myContentType;
        request.headers.add(CurlParser.getKeyValueForHeader((String)header));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputString";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/converters/curl/parser/CurlParser";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentToken";
                break;
            }
            case 5: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authData";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/converters/curl/parser/CurlParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToRestClientRequest";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateContentTypeIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseToRestClientRequest";
                break;
            }
            case 1: 
            case 13: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chooseCategory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addShortOption";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLongOption";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addHeaderToRequest";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateContentTypeIfNeeded";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addHttpMethodToRequest";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addDataToRequest";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addAuthorizationDataToRequest";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAuthSchemeOption";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addFormDataToRequest";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getKeyValueForHeader";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addContentTypeHeaderToRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

