/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.stm32cubemx;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.actions.CMakeProjectAction;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CLionProjectWizardUtils;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.embedded.EmbeddedUsagesCollector;
import com.jetbrains.cidr.cpp.embedded.ProjectData;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.CubeMXManager;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.OpenOcdConfiguration;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.ui.EmbeddedMessages;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.ui.SelectBoardDialog;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.ExecutableData;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter2.AttributeFilter;
import org.jdom.filter2.Filter;
import org.jdom.xpath.XPathExpression;
import org.jdom.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertProjectAction
extends CMakeProjectAction {
    protected static final String CPROJECT_FILE_NAME = ".cproject";
    private static final String CONFIG_DEBUG_XPATH = ".//configuration[@artifactExtension='elf' and @name='Debug']";
    protected static final String PROJECT_FILE_NAME = ".project";
    private static final String CMAKE_LISTS_TEMPLATE_FILE_NAME = "CMakeLists_template.txt";
    public static final AttributeFilter ATTRIBUTES_ONLY = new AttributeFilter();
    private static final XPathExpression<Attribute> INCLUDES_XPATH_SW4STM32 = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//*[@superClass='gnu.c.compiler.option.include.paths']/listOptionValue/@value", (Filter)ATTRIBUTES_ONLY);
    private static final XPathExpression<Attribute> DEFINES_XPATH_SW4STM32;
    private static final XPathExpression<Attribute> INCLUDES_XPATH_CUBEIDE;
    private static final XPathExpression<Attribute> DEFINES_XPATH_CUBEIDE;
    private static final XPathExpression<Attribute> SOURCE_XPATH;
    public static final String UNKNOWN = "UNKNOWN";
    public static final String UPDATE_FAILED = "UPDATE_FAILED";
    public static final String CMAKE_LISTS_TEMPLATE_NAME = "tmpl_CMakeLists.txt";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertProjectAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isVisible()) {
            if ("MainMenu".equals(e.getPlace())) {
                presentation.setEnabledAndVisible(ConvertProjectAction.checkProjectUpdateability(e.getProject()));
            } else {
                boolean visible = false;
                VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
                if (file != null) {
                    String fileName = file.getName();
                    if (FileUtilRt.extensionEquals((String)fileName, (String)"ioc")) {
                        visible = true;
                    } else if ("CMakeLists.txt".equals(fileName) || CMAKE_LISTS_TEMPLATE_FILE_NAME.equals(fileName)) {
                        visible = ConvertProjectAction.checkProjectUpdateability(e.getProject());
                    }
                }
                presentation.setEnabledAndVisible(visible);
            }
        }
    }

    private static boolean checkProjectUpdateability(@Nullable Project project) {
        CubeMXManager cubeMXManager = CubeMXManager.getInstance(project);
        CubeMXManager.CubeStatus status = cubeMXManager != null ? cubeMXManager.getStatus() : null;
        return status == CubeMXManager.CubeStatus.OK || status == CubeMXManager.CubeStatus.OUTDATED;
    }

    public ConvertProjectAction() {
        super(EmbeddedBundle.messagePointer("update.cmake.with.cube.xm.action", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProject(@Nullable Project project, boolean automatic) {
        if (project == null) {
            return;
        }
        String detectedMcuFamily = UPDATE_FAILED;
        try {
            StoreUtil.saveDocumentsAndProjectSettings((Project)project);
            ProjectData projectData = ConvertProjectAction.loadProjectData(project);
            if (projectData == null) {
                return;
            }
            VirtualFile projectDir = ConvertProjectAction.getRootDir(project);
            if (projectDir == null) {
                return;
            }
            ConvertProjectAction.scheduleModifyCMakeConfigs(project, projectData);
            ApplicationManager.getApplication().runWriteAction(() -> ConvertProjectAction.writeProject(projectData, projectDir));
            CMakeWorkspace cMakeWorkspace = CMakeWorkspace.getInstance((Project)project);
            if (cMakeWorkspace.getCMakeDependencyFiles().isEmpty()) {
                cMakeWorkspace.selectProjectDir(VfsUtilCore.virtualToIoFile((VirtualFile)projectDir));
            }
            cMakeWorkspace.scheduleClearGeneratedFilesAndReload();
            @NlsSafe Object message = EmbeddedBundle.message("mcu.chip.detected", projectData.getMcuFamily());
            if (projectData.getMcpu() != null) {
                @NlsSafe String mcuName = StringUtil.capitalize((String)projectData.getMcpu());
                message = (String)message + " (ARM " + mcuName + ")";
            }
            detectedMcuFamily = Objects.toString(projectData.getMcuFamily(), UNKNOWN);
            EmbeddedMessages.showSuccessMessage(project, EmbeddedBundle.message("cube.mx.project.updated", new Object[0]), (String)message);
        }
        finally {
            EmbeddedUsagesCollector.triggerStm32CubeMXParse(project, detectedMcuFamily, automatic);
        }
    }

    @Nullable
    public static VirtualFile getRootDir(@NotNull Project project) {
        if (project == null) {
            ConvertProjectAction.$$$reportNull$$$0(1);
        }
        return ConvertProjectAction.getRootDir(Stream.of(ModuleManager.getInstance((Project)project).getModules()));
    }

    @Nullable
    public static VirtualFile getRootDir(@NotNull Stream<Module> modules) {
        if (modules == null) {
            ConvertProjectAction.$$$reportNull$$$0(2);
        }
        return modules.map(ModuleRootManager::getInstance).map(ModuleRootModel::getContentRoots).flatMap(Stream::of).filter(VirtualFile::isDirectory).findFirst().orElse(null);
    }

    public static void scheduleModifyCMakeConfigs(final @NotNull Project project, final @NotNull ProjectData projectData) {
        if (project == null) {
            ConvertProjectAction.$$$reportNull$$$0(3);
        }
        if (projectData == null) {
            ConvertProjectAction.$$$reportNull$$$0(4);
        }
        final MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            public void reloadingFinished(boolean canceled) {
                busConnection.disconnect();
                if (!canceled) {
                    RunManager runManager = RunManager.getInstance((Project)project);
                    ConfigurationFactory factory = ConfigurationTypeUtil.findConfigurationType((String)"com.jetbrains.cidr.embedded.openocd.conf.type").getConfigurationFactories()[0];
                    String name = "OCD " + projectData.getProjectName();
                    if (runManager.findConfigurationByTypeAndName("com.jetbrains.cidr.embedded.openocd.conf.type", name) == null) {
                        RunnerAndConfigurationSettings newRunConfig = runManager.createConfiguration(name, factory);
                        newRunConfig.storeInDotIdeaFolder();
                        OpenOcdConfiguration configuration = (OpenOcdConfiguration)newRunConfig.getConfiguration();
                        configuration.setAllowRunningInParallel(false);
                        CMakeBuildConfigurationHelper helper = CMakeRunConfigurationType.getHelper((Project)project);
                        CMakeTarget target = (CMakeTarget)helper.getDefaultTarget();
                        if (target != null && !target.isExecutable()) {
                            target = helper.getTargets().stream().filter(CMakeTarget::isExecutable).findFirst().orElse(null);
                        }
                        if (target != null) {
                            BuildTargetData buildTargetData = new BuildTargetData(project.getName(), target.getName());
                            BuildTargetAndConfigurationData data = new BuildTargetAndConfigurationData(buildTargetData, null);
                            configuration.setTargetAndConfigurationData(data);
                            configuration.setExecutableData(new ExecutableData(buildTargetData));
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!project.isDisposed()) {
                                configuration.setBoardConfigFile(SelectBoardDialog.selectBoardByPriority(project, projectData.getBoard(), projectData.getMcuFamily()));
                                ApplicationManager.getApplication().runWriteAction(() -> {
                                    runManager.addConfiguration(newRunConfig);
                                    runManager.makeStable(newRunConfig);
                                    runManager.setSelectedConfiguration(newRunConfig);
                                });
                            }
                        });
                    }
                }
            }
        });
    }

    public static void writeProject(@NotNull ProjectData projectData, @NotNull VirtualFile projectDir) {
        if (projectData == null) {
            ConvertProjectAction.$$$reportNull$$$0(5);
        }
        if (projectDir == null) {
            ConvertProjectAction.$$$reportNull$$$0(6);
        }
        String fileName = CMAKE_LISTS_TEMPLATE_FILE_NAME;
        try {
            String templateText;
            VirtualFile cmakeTemplate = projectDir.findOrCreateChildData((Object)ApplicationManager.getApplication(), fileName);
            if (cmakeTemplate.getLength() <= 0L) {
                templateText = ConvertProjectAction.loadCmakeTemplateFromResources();
                VfsUtil.saveText((VirtualFile)cmakeTemplate, (String)templateText);
            } else {
                templateText = VfsUtilCore.loadText((VirtualFile)cmakeTemplate);
            }
            ConvertProjectAction.writeProjectFile(projectDir, templateText, "CMakeLists.txt", projectData);
        }
        catch (IOException e) {
            Application application = ApplicationManager.getApplication();
            application.invokeLater(() -> Messages.showErrorDialog((Component)WindowManager.getInstance().findVisibleFrame(), (String)(fileName + ":\n " + e.getLocalizedMessage()), (String)EmbeddedBundle.message("cube.mx.file.write.error", new Object[0])));
        }
    }

    @Nullable
    public static ProjectData loadProjectData(@NotNull Project project) {
        VirtualFile projectDir;
        if (project == null) {
            ConvertProjectAction.$$$reportNull$$$0(7);
        }
        if ((projectDir = ConvertProjectAction.getRootDir(project)) != null) {
            return ConvertProjectAction.loadProjectData(projectDir);
        }
        return null;
    }

    @Nullable
    public static ProjectData loadProjectData(@NotNull VirtualFile projectDir) {
        if (projectDir == null) {
            ConvertProjectAction.$$$reportNull$$$0(8);
        }
        try {
            VirtualFile iocFile = CubeMXManager.findIocFile(projectDir, false);
            if (iocFile == null) {
                return null;
            }
            ProjectData projectData = new ProjectData();
            Properties properties = new Properties();
            properties.load(iocFile.getInputStream());
            boolean sw4stm32 = "SW4STM32".equalsIgnoreCase(properties.getProperty("ProjectManager.TargetToolchain"));
            Element cProject = ConvertProjectAction.detectAndLoadFile(projectDir, CPROJECT_FILE_NAME);
            if (cProject == null) {
                return null;
            }
            Element dotProject = ConvertProjectAction.detectAndLoadFile(projectDir, PROJECT_FILE_NAME);
            if (dotProject == null) {
                return null;
            }
            Context context = new Context(cProject);
            projectData.setProjectName(dotProject.getChild("name").getText());
            if (sw4stm32) {
                ConvertProjectAction.loadSw4Stm32(context, projectData);
            } else {
                ConvertProjectAction.loadCubeIde(context, projectData);
            }
            projectData.setSources(ConvertProjectAction.loadSources(context));
            CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
            String cMakeMinimumRequiredLine = CLionProjectWizardUtils.getCMakeMinimumRequiredLine((String)CLionProjectWizardUtils.getCMakeVersionUnderProgress((CPPToolchains.Toolchain)toolchain));
            projectData.setCmakeRequiredVersion(cMakeMinimumRequiredLine);
            return projectData;
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)EmbeddedBundle.message("message.read.error", e.getClass().getName(), e.getLocalizedMessage()), (String)CLionCMakeBundle.message((String)"cmake.project.update.action.error", (Object[])new Object[0]));
            Logger.getInstance(ConvertProjectAction.class).error((Throwable)e);
            return null;
        }
    }

    private static void loadSw4Stm32(Context context, ProjectData projectData) {
        String linkerScript = ConvertProjectAction.fetchValueBySuperClass(context, "fr.ac6.managedbuild.tool.gnu.cross.c.linker.script");
        projectData.setLinkerScript(linkerScript.replace("../", ""));
        projectData.setMcuFamily(ConvertProjectAction.fetchValueBySuperClass(context, "fr.ac6.managedbuild.option.gnu.cross.mcu"));
        projectData.setLinkerFlags(ConvertProjectAction.fetchValueBySuperClass(context, "gnu.c.link.option.ldflags"));
        projectData.setBoard(ConvertProjectAction.fetchValueBySuperClass(context, "fr.ac6.managedbuild.option.gnu.cross.board"));
        projectData.setDefines(ConvertProjectAction.loadDefines(context, DEFINES_XPATH_SW4STM32));
        projectData.setIncludes(ConvertProjectAction.loadIncludes(context, INCLUDES_XPATH_SW4STM32));
    }

    private static void loadCubeIde(Context context, ProjectData projectData) {
        String linkerScript = ConvertProjectAction.fetchValueBySuperClass(context, "com.st.stm32cube.ide.mcu.gnu.managedbuild.tool.c.linker.option.script");
        linkerScript = linkerScript.replace("${workspace_loc:/${ProjName}/", "").replace("}", "");
        projectData.setLinkerScript(linkerScript);
        projectData.setMcuFamily(ConvertProjectAction.fetchValueBySuperClass(context, "com.st.stm32cube.ide.mcu.gnu.managedbuild.option.target_mcu"));
        projectData.setLinkerFlags("");
        projectData.setBoard(ConvertProjectAction.fetchValueBySuperClass(context, "com.st.stm32cube.ide.mcu.gnu.managedbuild.option.target_board"));
        projectData.setDefines(ConvertProjectAction.loadDefines(context, DEFINES_XPATH_CUBEIDE));
        projectData.setIncludes(ConvertProjectAction.loadIncludes(context, INCLUDES_XPATH_CUBEIDE));
    }

    @NotNull
    private static String loadCmakeTemplateFromResources() throws IOException {
        String string = FileUtil.loadTextAndClose((InputStream)ConvertProjectAction.class.getResourceAsStream(CMAKE_LISTS_TEMPLATE_NAME));
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static void writeProjectFile(@Nullable VirtualFile projectDir, @NotNull String template, @NotNull String fileName, @NotNull ProjectData projectData) throws IOException {
        if (template == null) {
            ConvertProjectAction.$$$reportNull$$$0(10);
        }
        if (fileName == null) {
            ConvertProjectAction.$$$reportNull$$$0(11);
        }
        if (projectData == null) {
            ConvertProjectAction.$$$reportNull$$$0(12);
        }
        if (projectDir == null) {
            return;
        }
        VirtualFile projectFile = projectDir.findChild(fileName);
        if (projectFile == null) {
            projectFile = projectDir.createChildData(null, fileName);
        }
        String text = new StrSubstitutor(projectData.getAsMap()).replace(template);
        VfsUtil.saveText((VirtualFile)projectFile, (String)text);
    }

    @NotNull
    private static String loadIncludes(@NotNull Context context, XPathExpression<Attribute> xPathExpression) {
        if (context == null) {
            ConvertProjectAction.$$$reportNull$$$0(13);
        }
        List list = xPathExpression.evaluate((Object)context.cProjectElement);
        String string = list.stream().map(Attribute::getValue).map(s -> s.replace("../", "")).collect(Collectors.joining(" "));
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String loadSources(@NotNull Context context) {
        if (context == null) {
            ConvertProjectAction.$$$reportNull$$$0(15);
        }
        List list = SOURCE_XPATH.evaluate((Object)context.cProjectElement);
        String string = list.stream().map(Attribute::getValue).map(s -> "\"" + s + "/*.*\"").collect(Collectors.joining(" "));
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String loadDefines(@NotNull Context context, XPathExpression<Attribute> xPathExpression) {
        if (context == null) {
            ConvertProjectAction.$$$reportNull$$$0(17);
        }
        List list = xPathExpression.evaluate((Object)context.cProjectElement);
        String string = list.stream().map(Attribute::getValue).map(s -> "-D" + s.replace("(", "\\(").replace(")", "\\)").replace("//", "////")).collect(Collectors.joining(" "));
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String fetchValueBySuperClass(@NotNull Context context, @NotNull String key) {
        XPathExpression xPath;
        Attribute attribute;
        if (context == null) {
            ConvertProjectAction.$$$reportNull$$$0(19);
        }
        if (key == null) {
            ConvertProjectAction.$$$reportNull$$$0(20);
        }
        String string = (attribute = (Attribute)(xPath = XPathFactory.instance().compile(".//*[@superClass='" + key + "']/@value", (Filter)ATTRIBUTES_ONLY)).evaluateFirst((Object)context.cProjectElement)) == null ? "" : attribute.getValue();
        if (string == null) {
            ConvertProjectAction.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    private static Element detectAndLoadFile(@NotNull VirtualFile projectDir, @NotNull String fileName) {
        VirtualFile child;
        if (projectDir == null) {
            ConvertProjectAction.$$$reportNull$$$0(22);
        }
        if (fileName == null) {
            ConvertProjectAction.$$$reportNull$$$0(23);
        }
        if ((child = projectDir.findChild(fileName)) == null || !child.exists() || child.isDirectory()) {
            Messages.showErrorDialog((String)EmbeddedBundle.message("cube.mx.file.not.found.description", fileName, projectDir.getPath()), (String)EmbeddedBundle.message("cube.mx.file.not.found", new Object[0]));
            return null;
        }
        try {
            return JDOMUtil.load((InputStream)child.getInputStream());
        }
        catch (IOException | JDOMException e) {
            Messages.showErrorDialog((String)EmbeddedBundle.message("cube.mx.file.read.error.description", fileName, projectDir.getPath(), e.getLocalizedMessage()), (String)EmbeddedBundle.message("cube.mx.file.read.error", new Object[0]));
            return null;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ConvertProjectAction.$$$reportNull$$$0(24);
        }
        Project project = ConvertProjectAction.getEventProject((AnActionEvent)event);
        ConvertProjectAction.updateProject(project, false);
    }

    static {
        INCLUDES_XPATH_CUBEIDE = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//*[@superClass='com.st.stm32cube.ide.mcu.gnu.managedbuild.tool.c.compiler.option.includepaths']/listOptionValue/@value", (Filter)ATTRIBUTES_ONLY);
        DEFINES_XPATH_SW4STM32 = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//*[@superClass='gnu.c.compiler.option.preprocessor.def.symbols']/listOptionValue/@value", (Filter)ATTRIBUTES_ONLY);
        DEFINES_XPATH_CUBEIDE = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//*[@superClass='com.st.stm32cube.ide.mcu.gnu.managedbuild.tool.c.compiler.option.definedsymbols']/listOptionValue/@value", (Filter)ATTRIBUTES_ONLY);
        SOURCE_XPATH = XPathFactory.instance().compile(".//configuration[@artifactExtension='elf' and @name='Debug']//sourceEntries/entry/@name", (Filter)ATTRIBUTES_ONLY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 6: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/ConvertProjectAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/ConvertProjectAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCmakeTemplateFromResources";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadIncludes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSources";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefines";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchValueBySuperClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootDir";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleModifyCMakeConfigs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadProjectData";
                break;
            }
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeProjectFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadIncludes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadSources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadDefines";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fetchValueBySuperClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "detectAndLoadFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Context {
        private final Element cProjectElement;

        Context(@NotNull Element cProjectElement) {
            if (cProjectElement == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.cProjectElement = cProjectElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cProjectElement", "com/jetbrains/cidr/cpp/embedded/stm32cubemx/ConvertProjectAction$Context", "<init>"));
        }
    }
}

