/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlReference
extends PsiReferenceBase<PsiElement>
implements CssReference {
    private @InspectionMessage String myUnresolvedMessage;
    private final FileType myFileType;

    public UrlReference(PsiElement element, @Nullable FileType _fileType, boolean soft) {
        super(element, soft);
        this.myFileType = _fileType;
    }

    public PsiElement resolve() {
        PsiFile psiFile;
        String referenceText = this.getCanonicalText();
        if (referenceText.contains("://") || referenceText.startsWith("//")) {
            if (ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(referenceText)) {
                return this.myElement;
            }
            String resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(referenceText, this.myElement.getProject());
            if (referenceText.equals(resourceLocation)) {
                if (!this.isSoft()) {
                    this.myUnresolvedMessage = XmlPsiBundle.message((String)"xml.inspections.uri.is.not.registered", (Object[])new Object[0]);
                    return null;
                }
                return this.myElement;
            }
            referenceText = resourceLocation;
        }
        if ((psiFile = XmlUtil.findRelativeFile((String)referenceText, (PsiElement)this.myElement.getContainingFile())) == null) {
            this.myUnresolvedMessage = CssBundle.message((String)"invalid.file.reference", (Object[])new Object[0]);
            return null;
        }
        if (this.myFileType != null && psiFile.getFileType() != this.myFileType) {
            this.myUnresolvedMessage = CssBundle.message((String)"file.refers.not.to", (Object[])new Object[]{this.myFileType.getName()});
            return null;
        }
        return psiFile;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            UrlReference.$$$reportNull$$$0(0);
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            UrlReference.$$$reportNull$$$0(1);
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        if (this.getCanonicalText().contains("://")) {
            Object[] objectArray = ExternalResourceManager.getInstance().getResourceUrls(null, false);
            if (objectArray == null) {
                UrlReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            UrlReference.$$$reportNull$$$0(3);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = this.myUnresolvedMessage;
        if (string == null) {
            UrlReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/UrlReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/UrlReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

