/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.gradle.api.Action;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.InstrumentingBackwardsCompatibilityVisitor;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Handle;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;

class InstrumentingTransformer
implements CachedClasspathTransformer.Transform {
    private static final int DECORATION_FORMAT = 16;
    private static final Type SYSTEM_TYPE = Type.getType(System.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type INTEGER_TYPE = Type.getType(Integer.class);
    private static final Type INSTRUMENTED_TYPE = Type.getType(Instrumented.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type SERIALIZED_LAMBDA_TYPE = Type.getType(SerializedLambda.class);
    private static final Type LONG_TYPE = Type.getType(Long.class);
    private static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
    private static final String RETURN_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[0]);
    private static final String RETURN_STRING_FROM_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_STRING_FROM_STRING_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_STRING_FROM_STRING_STRING_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INT = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, Type.INT_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INTEGER = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, INTEGER_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INT_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, Type.INT_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INTEGER_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, INTEGER_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_PRIMITIVE_LONG = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, Type.LONG_TYPE});
    private static final String RETURN_LONG_FROM_STRING_LONG = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, LONG_TYPE});
    private static final String RETURN_LONG_FROM_STRING_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_PRIMITIVE_LONG_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, Type.LONG_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_LONG_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, LONG_TYPE, STRING_TYPE});
    private static final String RETURN_PRIMITIVE_BOOLEAN_FROM_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_PRIMITIVE_BOOLEAN_FROM_STRING_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_OBJECT_FROM_INT = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{Type.INT_TYPE});
    private static final String RETURN_BOOLEAN_FROM_OBJECT = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{OBJECT_TYPE});
    private static final String RETURN_PROPERTIES = Type.getMethodDescriptor((Type)Type.getType(Properties.class), (Type[])new Type[0]);
    private static final String RETURN_PROPERTIES_FROM_STRING = Type.getMethodDescriptor((Type)Type.getType(Properties.class), (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_CALL_SITE_ARRAY = Type.getMethodDescriptor((Type)Type.getType(CallSiteArray.class), (Type[])new Type[0]);
    private static final String RETURN_VOID_FROM_CALL_SITE_ARRAY = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(CallSiteArray.class)});
    private static final String RETURN_OBJECT_FROM_SERIALIZED_LAMBDA = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{SERIALIZED_LAMBDA_TYPE});
    private static final String LAMBDA_METAFACTORY_TYPE = Type.getType(LambdaMetafactory.class).getInternalName();
    private static final String LAMBDA_METAFACTORY_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), STRING_TYPE, Type.getType(MethodType.class), Type.getType(Object[].class)});
    private static final String INSTRUMENTED_CALL_SITE_METHOD = "$instrumentedCallSiteArray";
    private static final String CREATE_CALL_SITE_ARRAY_METHOD = "$createCallSiteArray";
    private static final String DESERIALIZE_LAMBDA = "$deserializeLambda$";
    private static final String RENAMED_DESERIALIZE_LAMBDA = "$renamedDeserializeLambda$";
    private static final String[] NO_EXCEPTIONS = new String[0];

    InstrumentingTransformer() {
    }

    @Override
    public void applyConfigurationTo(Hasher hasher) {
        hasher.putString(InstrumentingTransformer.class.getSimpleName());
        hasher.putInt(16);
    }

    @Override
    public Pair<RelativePath, ClassVisitor> apply(ClasspathEntryVisitor.Entry entry, ClassVisitor visitor) {
        return Pair.of(entry.getPath(), new InstrumentingVisitor(new InstrumentingBackwardsCompatibilityVisitor(visitor)));
    }

    private static class MethodVisitorScope
    extends MethodVisitor {
        public MethodVisitorScope(MethodVisitor methodVisitor) {
            super(524288, methodVisitor);
        }

        protected void unboxOrCastTo(Type targetType) {
            AsmClassGeneratorUtils.unboxOrCast(this, targetType);
        }

        protected void _F_SAME() {
            super.visitFrame(3, 0, new Object[0], 0, new Object[0]);
        }

        protected void _INVOKESTATIC(Type owner, String name, String descriptor) {
            this._INVOKESTATIC(owner.getInternalName(), name, descriptor);
        }

        protected void _INVOKESTATIC(String owner, String name, String descriptor) {
            super.visitMethodInsn(184, owner, name, descriptor, false);
        }

        protected void _INVOKESTATIC(String owner, String name, String descriptor, boolean targetIsInterface) {
            super.visitMethodInsn(184, owner, name, descriptor, targetIsInterface);
        }

        protected void _INVOKEVIRTUAL(Type owner, String name, String descriptor) {
            this._INVOKEVIRTUAL(owner.getInternalName(), name, descriptor);
        }

        protected void _INVOKEVIRTUAL(String owner, String name, String descriptor) {
            super.visitMethodInsn(182, owner, name, descriptor, false);
        }

        protected void _INVOKEDYNAMIC(String name, String descriptor, Handle bootstrapMethodHandle, List<?> bootstrapMethodArguments) {
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments.toArray());
        }

        protected void _DUP() {
            super.visitInsn(89);
        }

        protected void _ACONST_NULL() {
            super.visitInsn(1);
        }

        protected void _LDC(Object value) {
            super.visitLdcInsn(value);
        }

        protected void _ALOAD(int var) {
            super.visitVarInsn(25, var);
        }

        protected void _IFEQ(Label label) {
            super.visitJumpInsn(153, label);
        }

        protected void _ARETURN() {
            super.visitInsn(176);
        }
    }

    private static class LambdaFactoryDetails {
        final String name;
        final String descriptor;
        final Handle bootstrapMethodHandle;
        final List<?> bootstrapMethodArguments;

        public LambdaFactoryDetails(String name, String descriptor, Handle bootstrapMethodHandle, List<?> bootstrapMethodArguments) {
            this.name = name;
            this.descriptor = descriptor;
            this.bootstrapMethodHandle = bootstrapMethodHandle;
            this.bootstrapMethodArguments = bootstrapMethodArguments;
        }
    }

    private static class InstrumentingMethodVisitor
    extends MethodVisitorScope {
        private final InstrumentingVisitor owner;
        private final String className;
        private static final String ACTION_LAMBDA_SUFFIX = ")" + Type.getType(Action.class).getDescriptor();
        private static final String SPEC_LAMBDA_SUFFIX = ")" + Type.getType(Spec.class).getDescriptor();

        public InstrumentingMethodVisitor(InstrumentingVisitor owner, MethodVisitor methodVisitor) {
            super(methodVisitor);
            this.owner = owner;
            this.className = owner.className;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 184 && this.visitINVOKESTATIC(owner, name, descriptor)) {
                return;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        private boolean visitINVOKESTATIC(String owner, String name, String descriptor) {
            if (owner.equals(SYSTEM_TYPE.getInternalName())) {
                if (name.equals("getProperty")) {
                    if (descriptor.equals(RETURN_STRING_FROM_STRING)) {
                        this._LDC(this.binaryClassNameOf(this.className));
                        this._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperty", RETURN_STRING_FROM_STRING_STRING);
                        return true;
                    }
                    if (descriptor.equals(RETURN_STRING_FROM_STRING_STRING)) {
                        this._LDC(this.binaryClassNameOf(this.className));
                        this._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperty", RETURN_STRING_FROM_STRING_STRING_STRING);
                        return true;
                    }
                } else if (name.equals("getProperties") && descriptor.equals(RETURN_PROPERTIES)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperties", RETURN_PROPERTIES_FROM_STRING);
                    return true;
                }
            } else if (owner.equals(INTEGER_TYPE.getInternalName()) && name.equals("getInteger")) {
                if (descriptor.equals(RETURN_INTEGER_FROM_STRING)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_INTEGER_FROM_STRING_INT)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_INT_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_INTEGER_FROM_STRING_INTEGER)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_INTEGER_STRING);
                    return true;
                }
            } else if (owner.equals(LONG_TYPE.getInternalName()) && name.equals("getLong")) {
                if (descriptor.equals(RETURN_LONG_FROM_STRING)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_LONG_FROM_STRING_PRIMITIVE_LONG)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_PRIMITIVE_LONG_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_LONG_FROM_STRING_LONG)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_LONG_STRING);
                    return true;
                }
            } else {
                if (owner.equals(BOOLEAN_TYPE.getInternalName()) && name.equals("getBoolean") && descriptor.equals(RETURN_PRIMITIVE_BOOLEAN_FROM_STRING)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getBoolean", RETURN_PRIMITIVE_BOOLEAN_FROM_STRING_STRING);
                    return true;
                }
                if (owner.equals(this.className) && name.equals(InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD) && descriptor.equals(RETURN_CALL_SITE_ARRAY)) {
                    this._INVOKESTATIC(this.className, InstrumentingTransformer.INSTRUMENTED_CALL_SITE_METHOD, RETURN_CALL_SITE_ARRAY);
                    return true;
                }
            }
            return false;
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (this.isGradleLambdaDescriptor(descriptor) && bootstrapMethodHandle.getOwner().equals(LAMBDA_METAFACTORY_TYPE) && bootstrapMethodHandle.getName().equals("metafactory")) {
                Handle altMethod = new Handle(6, LAMBDA_METAFACTORY_TYPE, "altMetafactory", LAMBDA_METAFACTORY_METHOD_DESCRIPTOR, false);
                ArrayList<Integer> args = new ArrayList<Integer>(bootstrapMethodArguments.length + 1);
                Collections.addAll(args, bootstrapMethodArguments);
                args.add(1);
                super.visitInvokeDynamicInsn(name, descriptor, altMethod, args.toArray());
                this.owner.addSerializedLambda(new LambdaFactoryDetails(name, descriptor, altMethod, args));
            } else {
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }
        }

        private boolean isGradleLambdaDescriptor(String descriptor) {
            return descriptor.endsWith(ACTION_LAMBDA_SUFFIX) || descriptor.endsWith(SPEC_LAMBDA_SUFFIX);
        }

        private String binaryClassNameOf(String className) {
            return Type.getObjectType((String)className).getClassName();
        }
    }

    private static class InstrumentingVisitor
    extends ClassVisitor {
        String className;
        private final List<LambdaFactoryDetails> lambdaFactories = new ArrayList<LambdaFactoryDetails>();
        private boolean hasGroovyCallSites;
        private boolean hasDeserializeLambda;
        private boolean isInterface;

        public InstrumentingVisitor(ClassVisitor visitor) {
            super(524288, visitor);
        }

        public void addSerializedLambda(LambdaFactoryDetails lambdaFactoryDetails) {
            this.lambdaFactories.add(lambdaFactoryDetails);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            this.isInterface = (access & 0x200) != 0;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (name.equals(InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD) && descriptor.equals(RETURN_CALL_SITE_ARRAY)) {
                this.hasGroovyCallSites = true;
            } else if (name.equals(InstrumentingTransformer.DESERIALIZE_LAMBDA) && descriptor.equals(RETURN_OBJECT_FROM_SERIALIZED_LAMBDA)) {
                this.hasDeserializeLambda = true;
                return super.visitMethod(access, InstrumentingTransformer.RENAMED_DESERIALIZE_LAMBDA, descriptor, signature, exceptions);
            }
            MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new InstrumentingMethodVisitor(this, methodVisitor);
        }

        public void visitEnd() {
            if (this.hasGroovyCallSites) {
                this.generateCallSiteFactoryMethod();
            }
            if (!this.lambdaFactories.isEmpty() || this.hasDeserializeLambda) {
                this.generateLambdaDeserializeMethod();
            }
            super.visitEnd();
        }

        private void generateLambdaDeserializeMethod() {
            new MethodVisitorScope(this.visitStaticPrivateMethod(InstrumentingTransformer.DESERIALIZE_LAMBDA, RETURN_OBJECT_FROM_SERIALIZED_LAMBDA)){
                {
                    super(methodVisitor);
                    this.visitCode();
                    Label next = null;
                    for (LambdaFactoryDetails factory : lambdaFactories) {
                        if (next != null) {
                            this.visitLabel(next);
                            this._F_SAME();
                        }
                        next = new Label();
                        this._ALOAD(0);
                        this._INVOKEVIRTUAL(SERIALIZED_LAMBDA_TYPE, "getImplMethodName", RETURN_STRING);
                        this._LDC(((Handle)factory.bootstrapMethodArguments.get(1)).getName());
                        this._INVOKEVIRTUAL(OBJECT_TYPE, "equals", RETURN_BOOLEAN_FROM_OBJECT);
                        this._IFEQ(next);
                        Type[] argumentTypes = Type.getArgumentTypes((String)factory.descriptor);
                        for (int i = 0; i < argumentTypes.length; ++i) {
                            this._ALOAD(0);
                            this._LDC(i);
                            this._INVOKEVIRTUAL(SERIALIZED_LAMBDA_TYPE, "getCapturedArg", RETURN_OBJECT_FROM_INT);
                            this.unboxOrCastTo(argumentTypes[i]);
                        }
                        this._INVOKEDYNAMIC(factory.name, factory.descriptor, factory.bootstrapMethodHandle, factory.bootstrapMethodArguments);
                        this._ARETURN();
                    }
                    if (next != null) {
                        this.visitLabel(next);
                        this._F_SAME();
                    }
                    if (hasDeserializeLambda) {
                        this._ALOAD(0);
                        this._INVOKESTATIC(className, InstrumentingTransformer.RENAMED_DESERIALIZE_LAMBDA, RETURN_OBJECT_FROM_SERIALIZED_LAMBDA, isInterface);
                    } else {
                        this._ACONST_NULL();
                    }
                    this._ARETURN();
                    this.visitMaxs(0, 0);
                    this.visitEnd();
                }
            };
        }

        private void generateCallSiteFactoryMethod() {
            new MethodVisitorScope(this.visitStaticPrivateMethod(InstrumentingTransformer.INSTRUMENTED_CALL_SITE_METHOD, RETURN_CALL_SITE_ARRAY)){
                {
                    super(methodVisitor);
                    this.visitCode();
                    this._INVOKESTATIC(className, InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD, RETURN_CALL_SITE_ARRAY);
                    this._DUP();
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "groovyCallSites", RETURN_VOID_FROM_CALL_SITE_ARRAY);
                    this._ARETURN();
                    this.visitMaxs(2, 0);
                    this.visitEnd();
                }
            };
        }

        private MethodVisitor visitStaticPrivateMethod(String name, String descriptor) {
            return super.visitMethod(4106, name, descriptor, null, NO_EXCEPTIONS);
        }
    }
}

