/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationDependency;
import org.gradle.api.internal.artifacts.transform.ExecuteScheduledTransformationStepBuildOperationDetails;
import org.gradle.api.internal.artifacts.transform.ExecuteScheduledTransformationStepBuildOperationType;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.Describables;
import org.gradle.internal.Try;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.resources.ResourceLock;

public abstract class TransformationNode
extends Node
implements SelfExecutingNode {
    private static final AtomicInteger ORDER_COUNTER = new AtomicInteger();
    private final int order = ORDER_COUNTER.incrementAndGet();
    protected final TransformationStep transformationStep;
    protected final ResolvableArtifact artifact;
    protected final TransformUpstreamDependencies upstreamDependencies;

    public static ChainedTransformationNode chained(TransformationStep current, TransformationNode previous, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return new ChainedTransformationNode(current, previous, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public static InitialTransformationNode initial(TransformationStep initial, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return new InitialTransformationNode(initial, artifact, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    protected TransformationNode(TransformationStep transformationStep, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies) {
        this.transformationStep = transformationStep;
        this.artifact = artifact;
        this.upstreamDependencies = upstreamDependencies;
    }

    public ResolvableArtifact getInputArtifact() {
        return this.artifact;
    }

    public TransformUpstreamDependencies getUpstreamDependencies() {
        return this.upstreamDependencies;
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return this.transformationStep.getOwningProject();
    }

    @Override
    public boolean isPublicNode() {
        return true;
    }

    @Override
    public boolean requiresMonitoring() {
        return false;
    }

    @Override
    public void resolveMutations() {
    }

    @Override
    public String toString() {
        return this.transformationStep.getDisplayName();
    }

    public TransformationStep getTransformationStep() {
        return this.transformationStep;
    }

    public Try<TransformationSubject> getTransformedSubject() {
        return this.getTransformedArtifacts().getValue();
    }

    @Override
    public void execute(NodeExecutionContext context) {
        this.getTransformedArtifacts().run(context);
    }

    public void executeIfNotAlready() {
        this.transformationStep.isolateParametersIfNotAlready();
        this.upstreamDependencies.finalizeIfNotAlready();
        this.getTransformedArtifacts().finalizeIfNotAlready();
    }

    protected abstract CalculatedValueContainer<TransformationSubject, ?> getTransformedArtifacts();

    @Override
    public Set<Node> getFinalizers() {
        return Collections.emptySet();
    }

    @Override
    public void prepareForExecution() {
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        return null;
    }

    public List<ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    @Override
    public Throwable getNodeFailure() {
        return null;
    }

    @Override
    public void rethrowNodeFailure() {
    }

    @Override
    public int compareTo(Node other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        TransformationNode otherTransformation = (TransformationNode)other;
        return this.order - otherTransformation.order;
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
        this.processDependencies(processHardSuccessor, dependencyResolver.resolveDependenciesFor(null, context -> this.getTransformedArtifacts().visitDependencies(context)));
    }

    protected void processDependencies(Action<Node> processHardSuccessor, Set<Node> dependencies) {
        for (Node dependency : dependencies) {
            this.addDependencySuccessor(dependency);
            processHardSuccessor.execute(dependency);
        }
    }

    private abstract class ArtifactTransformationStepBuildOperation
    implements CallableBuildOperation<TransformationSubject> {
        private static final String TRANSFORMING_PROGRESS_PREFIX = "Transforming ";

        private ArtifactTransformationStepBuildOperation() {
        }

        @Override
        public final BuildOperationDescriptor.Builder description() {
            String transformerName = TransformationNode.this.transformationStep.getDisplayName();
            String subjectName = this.describeSubject();
            String basicName = subjectName + " with " + transformerName;
            return BuildOperationDescriptor.displayName("Transform " + basicName).progressDisplayName(TRANSFORMING_PROGRESS_PREFIX + basicName).metadata(BuildOperationCategory.TRANSFORM).details(new ExecuteScheduledTransformationStepBuildOperationDetails(TransformationNode.this, transformerName, subjectName));
        }

        protected abstract String describeSubject();

        @Override
        public TransformationSubject call(BuildOperationContext context) {
            context.setResult(ExecuteScheduledTransformationStepBuildOperationType.RESULT);
            return this.transform();
        }

        protected abstract TransformationSubject transform();
    }

    public static class ChainedTransformationNode
    extends TransformationNode {
        private final TransformationNode previousTransformationNode;
        private final CalculatedValueContainer<TransformationSubject, TransformPreviousArtifacts> result;

        public ChainedTransformationNode(TransformationStep transformationStep, TransformationNode previousTransformationNode, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(transformationStep, previousTransformationNode.artifact, upstreamDependencies);
            this.previousTransformationNode = previousTransformationNode;
            this.result = calculatedValueContainerFactory.create(Describables.of(this), new TransformPreviousArtifacts(buildOperationExecutor));
        }

        public TransformationNode getPreviousTransformationNode() {
            return this.previousTransformationNode;
        }

        protected CalculatedValueContainer<TransformationSubject, TransformPreviousArtifacts> getTransformedArtifacts() {
            return this.result;
        }

        @Override
        public void executeIfNotAlready() {
            this.previousTransformationNode.executeIfNotAlready();
            super.executeIfNotAlready();
        }

        private class TransformPreviousArtifacts
        implements ValueCalculator<TransformationSubject> {
            private final BuildOperationExecutor buildOperationExecutor;

            public TransformPreviousArtifacts(BuildOperationExecutor buildOperationExecutor) {
                this.buildOperationExecutor = buildOperationExecutor;
            }

            @Override
            public boolean usesMutableProjectState() {
                return false;
            }

            @Override
            @Nullable
            public ProjectInternal getOwningProject() {
                return null;
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(ChainedTransformationNode.this.transformationStep);
                context.add(ChainedTransformationNode.this.upstreamDependencies);
                context.add(new DefaultTransformationDependency(Collections.singletonList(ChainedTransformationNode.this.previousTransformationNode)));
            }

            @Override
            public TransformationSubject calculateValue(final NodeExecutionContext context) {
                return this.buildOperationExecutor.call(new ArtifactTransformationStepBuildOperation(){

                    @Override
                    protected TransformationSubject transform() {
                        return (TransformationSubject)ChainedTransformationNode.this.previousTransformationNode.getTransformedSubject().flatMap(transformedSubject -> ChainedTransformationNode.this.transformationStep.createInvocation((TransformationSubject)transformedSubject, ChainedTransformationNode.this.upstreamDependencies, context).invoke()).get();
                    }

                    @Override
                    protected String describeSubject() {
                        return ChainedTransformationNode.this.previousTransformationNode.getTransformedSubject().map(Describable::getDisplayName).getOrMapFailure(Throwable::getMessage);
                    }
                });
            }
        }
    }

    public static class InitialTransformationNode
    extends TransformationNode {
        private final CalculatedValueContainer<TransformationSubject, TransformInitialArtifact> result;

        public InitialTransformationNode(TransformationStep transformationStep, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(transformationStep, artifact, upstreamDependencies);
            this.result = calculatedValueContainerFactory.create(Describables.of(this), new TransformInitialArtifact(buildOperationExecutor));
        }

        protected CalculatedValueContainer<TransformationSubject, TransformInitialArtifact> getTransformedArtifacts() {
            return this.result;
        }

        private class TransformInitialArtifact
        implements ValueCalculator<TransformationSubject> {
            private final BuildOperationExecutor buildOperationExecutor;

            public TransformInitialArtifact(BuildOperationExecutor buildOperationExecutor) {
                this.buildOperationExecutor = buildOperationExecutor;
            }

            @Override
            public boolean usesMutableProjectState() {
                return false;
            }

            @Override
            @Nullable
            public ProjectInternal getOwningProject() {
                return null;
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(InitialTransformationNode.this.transformationStep);
                context.add(InitialTransformationNode.this.upstreamDependencies);
                context.add(InitialTransformationNode.this.artifact);
            }

            @Override
            public TransformationSubject calculateValue(final NodeExecutionContext context) {
                return this.buildOperationExecutor.call(new ArtifactTransformationStepBuildOperation(){

                    @Override
                    protected TransformationSubject transform() {
                        TransformationSubject initialArtifactTransformationSubject;
                        try {
                            initialArtifactTransformationSubject = TransformationSubject.initial(InitialTransformationNode.this.artifact);
                        }
                        catch (ResolveException e) {
                            throw e;
                        }
                        catch (RuntimeException e) {
                            throw new DefaultLenientConfiguration.ArtifactResolveException("artifacts", InitialTransformationNode.this.transformationStep.getDisplayName(), "artifact transform", Collections.singleton(e));
                        }
                        return InitialTransformationNode.this.transformationStep.createInvocation(initialArtifactTransformationSubject, InitialTransformationNode.this.upstreamDependencies, context).invoke().get();
                    }

                    @Override
                    protected String describeSubject() {
                        return InitialTransformationNode.this.artifact.getId().getDisplayName();
                    }
                });
            }
        }
    }
}

