/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import a.d.la;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="toString()", childrenArray="toArray()", hasChildren="!guaranteedToBeEmpty()")
public abstract class PathTreeBase<Self extends PathTreeBase<Self>> {
    @Nullable
    protected Map<String, Self> myChildren;
    private final boolean myResolveSymlinksIfNecessary;
    private static final long b = la.a(6253831476843587844L, -7168954179280762057L, MethodHandles.lookup().lookupClass()).a(215023855919126L);

    public PathTreeBase() {
        this(true);
    }

    public PathTreeBase(boolean resolveSymlinksIfNecessary) {
        this.myResolveSymlinksIfNecessary = resolveSymlinksIfNecessary;
    }

    @NotNull
    protected <T> Map<String, T> createChildrenMap(int capacity) {
        Map map = capacity >= 0 ? CollectionFactory.createFilePathMap((int)capacity) : CollectionFactory.createFilePathMap();
        if (map == null) {
            PathTreeBase.a(0);
        }
        return map;
    }

    @NotNull
    public Collection<Self> getChildren() {
        Collection<Object> collection = this.myChildren == null ? Collections.emptySet() : this.myChildren.values();
        if (collection == null) {
            PathTreeBase.a(1);
        }
        return collection;
    }

    @NotNull
    protected Self getNotNullSubTree(@NotNull String path) {
        if (path == null) {
            PathTreeBase.a(2);
        }
        Self Self = this.getSubTree(path, SearchStrategy.BUILD_IF_NOT_FOUND);
        if (Self == null) {
            PathTreeBase.a(3);
        }
        return Self;
    }

    @Deprecated
    @Nullable
    public Self getSubTree(@NotNull String path, boolean createSubtrees) {
        if (path == null) {
            PathTreeBase.a(4);
        }
        return this.getSubTree(path, createSubtrees ? SearchStrategy.BUILD_IF_NOT_FOUND : SearchStrategy.NULL_IF_NOT_FOUND);
    }

    @Nullable
    public Self getSubTree(@NotNull String path, @NotNull SearchStrategy strategy) {
        if (path == null) {
            PathTreeBase.a(5);
        }
        if (strategy == null) {
            PathTreeBase.a(6);
        }
        return this.a((Iterable<String>)PathTreeBase.a(this.a(path)), strategy);
    }

    @NotNull
    private static List<String> a(@NotNull String string) {
        if (string == null) {
            PathTreeBase.a(7);
        }
        List list2 = StringUtil.split((String)string, (String)"/", (boolean)true, (boolean)false);
        if (list2 == null) {
            PathTreeBase.a(8);
        }
        return list2;
    }

    @NotNull
    private String a(@NotNull String string) {
        int n2;
        long l2 = b ^ 0x76C8E418F51CL;
        if (string == null) {
            PathTreeBase.a(9);
        }
        if ((n2 = string.indexOf("://")) < 0) {
            String string2 = FileUtil.toCanonicalPath((String)string, (boolean)this.myResolveSymlinksIfNecessary);
            if (string2 == null) {
                PathTreeBase.a(10);
            }
            return string2;
        }
        int n3 = n2 + "://".length();
        String string3 = string.substring(0, n3) + FileUtil.toCanonicalPath((String)string.substring(n3), (boolean)this.myResolveSymlinksIfNecessary);
        if (string3 == null) {
            PathTreeBase.a(11);
        }
        return string3;
    }

    @Nullable
    private Self a(@NotNull Iterable<String> iterable, SearchStrategy searchStrategy) {
        if (iterable == null) {
            PathTreeBase.a(12);
        }
        Self Self = this.self();
        Iterator<String> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Self Self2 = Self;
            String string = iterator.next();
            Self Self3 = ((PathTreeBase)Self2).b(string);
            if (Self3 != null) {
                Self = Self3;
                continue;
            }
            switch (searchStrategy) {
                case NULL_IF_NOT_FOUND: {
                    return null;
                }
                case DEEPEST_EXISTING_PREFIX: {
                    return Self;
                }
                case BUILD_IF_NOT_FOUND: {
                    Self = ((PathTreeBase)Self2).a(string);
                }
            }
        }
        return Self;
    }

    @NotNull
    protected Self self() {
        PathTreeBase pathTreeBase = this;
        if (pathTreeBase == null) {
            PathTreeBase.a(13);
        }
        return (Self)pathTreeBase;
    }

    @NotNull
    protected abstract Self createNewTree(@Nullable Self var1);

    @Nullable
    private Self b(@NotNull String string) {
        if (string == null) {
            PathTreeBase.a(14);
        }
        if (this.myChildren == null) {
            return null;
        }
        return (Self)((PathTreeBase)this.myChildren.get(string));
    }

    private Self a(@NotNull String string) {
        if (string == null) {
            PathTreeBase.a(15);
        }
        if (this.myChildren == null) {
            this.myChildren = this.createChildrenMap(-1);
        }
        Self Self = this.createNewTree(this.self());
        this.myChildren.put(string, Self);
        return Self;
    }

    Self clone(@Nullable Self parent) {
        Self Self = this.createNewTree(parent);
        Map<String, Self> map = this.myChildren;
        if (map == null) {
            return Self;
        }
        ((PathTreeBase)Self).myChildren = this.createChildrenMap(map.size());
        for (Map.Entry<String, Self> entry : map.entrySet()) {
            ((PathTreeBase)Self).myChildren.put(entry.getKey(), ((PathTreeBase)entry.getValue()).clone(Self));
        }
        return Self;
    }

    @Nullable
    public static <Self extends PathTreeBase<Self>> Self merge(@NotNull @NotNull Collection<@NotNull Self> trees, boolean allowReuse) {
        if (trees == null) {
            PathTreeBase.a(16);
        }
        return trees.isEmpty() ? null : PathTreeBase.a(null, trees, allowReuse);
    }

    @NotNull
    private static <Self extends PathTreeBase<Self>> Self a(@Nullable Self Self, @NotNull @NotNull Collection<@NotNull Self> collection, boolean bl2) {
        if (collection == null) {
            PathTreeBase.a(17);
        }
        Iterator<@NotNull Self> iterator = collection.iterator();
        assert (iterator.hasNext());
        PathTreeBase pathTreeBase = (PathTreeBase)iterator.next();
        if (!iterator.hasNext()) {
            PathTreeBase<Self> pathTreeBase2 = bl2 ? pathTreeBase : pathTreeBase.clone(Self);
            if (pathTreeBase2 == null) {
                PathTreeBase.a(18);
            }
            return (Self)pathTreeBase2;
        }
        Self Self2 = pathTreeBase.createNewTree(Self);
        MultiMap multiMap = new MultiMap(Self2.createChildrenMap(collection.size()));
        while (true) {
            pathTreeBase.mergeInto(Self2, multiMap);
            if (!iterator.hasNext()) break;
            pathTreeBase = (PathTreeBase)iterator.next();
        }
        if (multiMap.isEmpty()) {
            Self Self3 = Self2;
            if (Self3 == null) {
                PathTreeBase.a(19);
            }
            return Self3;
        }
        Self2.myChildren = Self2.createChildrenMap(multiMap.size());
        for (Map.Entry entry : multiMap.entrySet()) {
            Self Self4 = PathTreeBase.a(Self2, (Collection)entry.getValue(), bl2);
            Self2.myChildren.put((String)entry.getKey(), Self4);
        }
        Self Self5 = Self2;
        if (Self5 == null) {
            PathTreeBase.a(20);
        }
        return Self5;
    }

    protected void mergeInto(@NotNull Self mergedTree, @NotNull MultiMap<String, Self> childrenPerKey) {
        Map<String, Self> map;
        if (mergedTree == null) {
            PathTreeBase.a(21);
        }
        if (childrenPerKey == null) {
            PathTreeBase.a(22);
        }
        if ((map = this.myChildren) != null) {
            for (Map.Entry<String, Self> entry : map.entrySet()) {
                childrenPerKey.putValue((Object)entry.getKey(), (Object)((PathTreeBase)entry.getValue()));
            }
        }
    }

    public void accept(@NotNull Visitor<Self> visitor2) {
        if (visitor2 == null) {
            PathTreeBase.a(23);
        }
        this.a(null, visitor2);
    }

    private void a(@Nullable String object, @NotNull Visitor<Self> visitor2) {
        Map<String, Self> map;
        if (visitor2 == null) {
            PathTreeBase.a(24);
        }
        visitor2.enter();
        if (visitor2.visit((String)object, this.self()) && !ContainerUtil.isEmpty(map = this.myChildren)) {
            if (object != null) {
                object = (String)object + "/";
            }
            for (Map.Entry<String, Self> entry : map.entrySet()) {
                ProgressManager.checkCanceled();
                PathTreeBase pathTreeBase = (PathTreeBase)entry.getValue();
                pathTreeBase.a((String)(object != null ? (String)object + entry.getKey() : entry.getKey()), visitor2);
            }
        }
        visitor2.exit();
    }

    public String toString() {
        long l2 = b ^ 0x1A500EB5F95AL;
        if (this.guaranteedToBeEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(1024).append('[');
        this.accept(new ToStringVisitor(stringBuilder));
        return stringBuilder.append(']').toString();
    }

    protected abstract boolean isLeaf();

    protected void nodeToString(@NotNull StringBuilder sb, @Nullable String path) {
        if (sb == null) {
            PathTreeBase.a(25);
        }
        sb.append(PathTreeBase.pathToDebugString(path));
    }

    @NotNull
    protected static String pathToDebugString(@Nullable String path) {
        return path != null ? path : "\u2205";
    }

    final Object[] toArray() {
        if (this.guaranteedToBeEmpty()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        final ArrayList arrayList = new ArrayList();
        this.accept(new Visitor<Self>(){
            private static final long a = la.a(1817780127522957553L, -5348950849694487103L, MethodHandles.lookup().lookupClass()).a(88184788161855L);

            @Override
            public boolean visit(@Nullable String path, @NotNull Self subTree) {
                if (subTree == null) {
                    1.a(0);
                }
                if (((PathTreeBase)subTree).isLeaf()) {
                    arrayList.add(((PathTreeBase)subTree).nodeDebugRenderer(path));
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4D8838177D7BL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subTree", "com/jetbrains/cidr/PathTreeBase$1", "visit"));
            }
        });
        return arrayList.toArray();
    }

    protected boolean guaranteedToBeEmpty() {
        return ContainerUtil.isEmpty(this.myChildren) && !this.isLeaf();
    }

    @NotNull
    protected Object nodeDebugRenderer(@Nullable String path) {
        return PathTreeBase.pathToDebugString(path);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x24A9DEE0AB4EL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/PathTreeBase";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathComps";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedTree";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenPerKey";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildrenMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/PathTreeBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullSubTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPathInComponents";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullSubTree";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSubTree";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "splitPathInComponents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mergeInto";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "nodeToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class ToStringVisitor<Self extends PathTreeBase<?>>
    implements Visitor<Self> {
        @NotNull
        private final StringBuilder sb;
        private boolean isFirstElement;
        private static final long a = la.a(7532907062871698890L, -9107026555288711699L, MethodHandles.lookup().lookupClass()).a(91439841427568L);

        public ToStringVisitor(@NotNull StringBuilder sb) {
            if (sb == null) {
                ToStringVisitor.a(0);
            }
            this.isFirstElement = true;
            this.sb = sb;
        }

        @Override
        public boolean visit(@Nullable String path, @NotNull Self subTree) {
            if (subTree == null) {
                ToStringVisitor.a(1);
            }
            if (!((PathTreeBase)subTree).isLeaf()) {
                return true;
            }
            if (!this.isFirstElement) {
                this.sb.append(',').append(' ');
            }
            ((PathTreeBase)subTree).nodeToString(this.sb, path);
            this.isFirstElement = false;
            return true;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x2BC21FBF3B14L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subTree";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/PathTreeBase$ToStringVisitor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Visitor<T extends PathTreeBase<?>> {
        default public void enter() {
        }

        public boolean visit(@Nullable String var1, @NotNull T var2);

        default public void exit() {
        }
    }

    public static final class SearchStrategy
    extends Enum<SearchStrategy> {
        public static final /* enum */ SearchStrategy NULL_IF_NOT_FOUND;
        public static final /* enum */ SearchStrategy BUILD_IF_NOT_FOUND;
        public static final /* enum */ SearchStrategy DEEPEST_EXISTING_PREFIX;
        private static final /* synthetic */ SearchStrategy[] $VALUES;

        public static SearchStrategy[] values() {
            return (SearchStrategy[])$VALUES.clone();
        }

        public static SearchStrategy valueOf(String name) {
            return Enum.valueOf(SearchStrategy.class, name);
        }

        static {
            long l2 = la.a(-2503218907425634639L, -2885429408908985045L, MethodHandles.lookup().lookupClass()).a(222708637290667L) ^ 0x77ABE8A76636L;
            NULL_IF_NOT_FOUND = new SearchStrategy();
            BUILD_IF_NOT_FOUND = new SearchStrategy();
            DEEPEST_EXISTING_PREFIX = new SearchStrategy();
            $VALUES = new SearchStrategy[]{NULL_IF_NOT_FOUND, BUILD_IF_NOT_FOUND, DEEPEST_EXISTING_PREFIX};
        }
    }
}

