/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.attach;

import a.d.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.osHandlers.AttachOSHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshAttachHost
extends EnvironmentAwareHost {
    @NonNls
    private static final List<String> COMM_LIST;
    @NonNls
    private static final List<String> COMMAND_LIST;
    @NlsSafe
    @NotNull
    private final String myPresentationName;
    @NotNull
    private final RemoteCredentialsHolder myCredentials;
    private static final long a;

    public SshAttachHost(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            SshAttachHost.a(0);
        }
        this.myCredentials = new RemoteCredentialsHolder();
        this.myCredentials.copyFrom(credentials);
        this.myPresentationName = this.myCredentials.getHost() + "@" + this.myCredentials.getPort();
    }

    @NotNull
    public RemoteCredentials getCredentials() {
        RemoteCredentialsHolder remoteCredentialsHolder = this.myCredentials;
        if (remoteCredentialsHolder == null) {
            SshAttachHost.a(1);
        }
        return remoteCredentialsHolder;
    }

    private String a(@NotNull GeneralCommandLine generalCommandLine) throws ExecutionException {
        ProcessOutput processOutput;
        int n2;
        long l2 = a ^ 0x56110EC5C7DCL;
        if (generalCommandLine == null) {
            SshAttachHost.a(2);
        }
        if ((n2 = (processOutput = this.getProcessOutput(generalCommandLine)).getExitCode()) != 0) {
            throw new ExecutionException(SshBundle.message("dialog.message.non.zero.exit.code", generalCommandLine.getCommandLineString()));
        }
        return processOutput.getStdout();
    }

    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException {
        long l2 = a ^ 0x57F4D2AF0AD4L;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(COMM_LIST);
        GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(COMMAND_LIST);
        List list2 = this.getOsHandler().getOSType() == AttachOSHandler.OSType.MACOSX ? ProcessListUtil.parseMacOutput((String)this.a(generalCommandLine), (String)this.a(generalCommandLine2)) : (this.getOsHandler().getOSType() == AttachOSHandler.OSType.LINUX ? ProcessListUtil.parseLinuxOutputMacStyle((String)this.a(generalCommandLine), (String)this.a(generalCommandLine2)) : Collections.emptyList());
        if (list2 == null) {
            throw new ExecutionException(SshBundle.message("dialog.message.error.while.parsing.process.list", new Object[0]));
        }
        List list3 = list2;
        if (list3 == null) {
            SshAttachHost.a(3);
        }
        return list3;
    }

    @NotNull
    public BaseProcessHandler getProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        long l2 = a ^ 0x3145AE8EDA13L;
        if (commandLine == null) {
            SshAttachHost.a(4);
        }
        ConnectionBuilder connectionBuilder2 = RemoteCredentialsUtil.connectionBuilder(this.getCredentials(), null);
        try {
            SshExecProcess sshExecProcess = RemoteCredentialsUtil.processBuilder(connectionBuilder2, commandLine).withChangeDir(false).withAllocatePty(false).start();
            return new CapturingSshProcessHandler(sshExecProcess, null, commandLine.getCommandLineString());
        }
        catch (SshTransportException sshTransportException) {
            throw new ExecutionException(SshBundle.message("dialog.message.failed.to.create.ssh.process", new Object[0]), (Throwable)((Object)sshTransportException));
        }
    }

    @Nullable
    public InputStream getFileContent(@NotNull String filePath) throws IOException {
        long l2 = a ^ 0x516A35138317L;
        if (filePath == null) {
            SshAttachHost.a(5);
        }
        try {
            SftpChannel sftpChannel2 = RemoteCredentialsUtil.connectionBuilder(this.getCredentials()).openSftpChannel();
            RemoteFileObject remoteFileObject = sftpChannel2.file(filePath);
            if (!remoteFileObject.exists()) {
                throw new IOException("No such file on ssh host: " + filePath);
            }
            return remoteFileObject.inputStream();
        }
        catch (SshTransportException sshTransportException) {
            throw new IOException("error while getting remote file content", (Throwable)((Object)sshTransportException));
        }
    }

    public boolean canReadFile(@NotNull String filePath) {
        if (filePath == null) {
            SshAttachHost.a(6);
        }
        return false;
    }

    @NlsSafe
    @NotNull
    public String getFileSystemHostId() {
        String string = this.myPresentationName;
        if (string == null) {
            SshAttachHost.a(7);
        }
        return string;
    }

    public boolean isSameHost(@NotNull Object credentialsObject) {
        if (credentialsObject == null) {
            SshAttachHost.a(8);
        }
        if (!(credentialsObject instanceof RemoteCredentials)) {
            return false;
        }
        RemoteCredentials remoteCredentials = (RemoteCredentials)credentialsObject;
        return Objects.equals(this.myCredentials.getHost(), remoteCredentials.getHost());
    }

    @NotNull
    String getHost() {
        String string = this.myCredentials.getHost();
        if (string == null) {
            SshAttachHost.a(9);
        }
        return string;
    }

    int getPort() {
        return this.myCredentials.getPort();
    }

    public int hashCode() {
        return Objects.hash(this.myCredentials.getHost(), this.myCredentials.getPort(), this.myCredentials.getUserName(), this.myCredentials.getPassword());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        return this.isSameHost(((SshAttachHost)((Object)o2)).getCredentials());
    }

    static {
        a = la.a(-1012850433371917079L, -5187530159504441148L, MethodHandles.lookup().lookupClass()).a(45378134433842L);
        long l2 = a ^ 0x569C539F79DL;
        COMM_LIST = Arrays.asList("/bin/ps", "-a", "-x", "-o", "pid,state,user,comm");
        COMMAND_LIST = Arrays.asList("/bin/ps", "-a", "-x", "-o", "pid,state,user,command");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x6F463C6419F5L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/attach/SshAttachHost";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsObject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/attach/SshAttachHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystemHostId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execAndCheckExitCode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProcessHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canReadFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSameHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

