/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import a.d.la;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEnabledConfiguration
implements JDOMExternalizable {
    private static final Logger LOG;
    public static final Key<CoverageEnabledConfiguration> COVERAGE_KEY;
    @NonNls
    protected static final String COVERAGE_ENABLED_ATTRIBUTE_NAME = "enabled";
    @NonNls
    protected static final String COVERAGE_RUNNER = "runner";
    @NonNls
    protected static final String TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME = "per_test_coverage_enabled";
    @NonNls
    protected static final String SAMPLING_COVERAGE_ATTRIBUTE_NAME = "sample_coverage";
    @NonNls
    protected static final String TRACK_TEST_FOLDERS = "track_test_folders";
    private final Project myProject;
    private final RunConfigurationBase<?> myConfiguration;
    private boolean myIsCoverageEnabled;
    private String myRunnerId;
    private CoverageRunner myCoverageRunner;
    private boolean myTrackPerTestCoverage;
    private boolean mySampling;
    private boolean myTrackTestFolders;
    @NonNls
    protected String myCoverageFilePath;
    private CoverageSuite myCurrentCoverageSuite;
    private static final long a;

    public CoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> configuration) {
        if (configuration == null) {
            CoverageEnabledConfiguration.a(0);
        }
        this.myIsCoverageEnabled = false;
        this.myTrackPerTestCoverage = true;
        this.mySampling = true;
        this.myTrackTestFolders = false;
        this.myConfiguration = configuration;
        this.myProject = configuration.getProject();
    }

    @NotNull
    public RunConfigurationBase<?> getConfiguration() {
        RunConfigurationBase<?> runConfigurationBase = this.myConfiguration;
        if (runConfigurationBase == null) {
            CoverageEnabledConfiguration.a(1);
        }
        return runConfigurationBase;
    }

    public boolean isCoverageEnabled() {
        return this.myIsCoverageEnabled;
    }

    public void setCoverageEnabled(boolean isCoverageEnabled) {
        this.myIsCoverageEnabled = isCoverageEnabled;
    }

    public boolean isSampling() {
        return this.mySampling;
    }

    public void setSampling(boolean sampling) {
        this.mySampling = sampling;
    }

    public String getRunnerId() {
        return this.myRunnerId;
    }

    @Nullable
    public CoverageRunner getCoverageRunner() {
        return this.myCoverageRunner;
    }

    public void setCoverageRunner(@Nullable CoverageRunner coverageRunner) {
        this.myCoverageRunner = coverageRunner;
        this.myRunnerId = coverageRunner != null ? coverageRunner.getId() : null;
        this.myCoverageFilePath = null;
    }

    public void coverageRunnerExtensionRemoved(@NotNull CoverageRunner runner) {
        if (runner == null) {
            CoverageEnabledConfiguration.a(2);
        }
        if (runner.getId().equals(this.myRunnerId)) {
            this.myCoverageRunner = null;
            this.myCoverageFilePath = null;
        }
    }

    public boolean isTrackPerTestCoverage() {
        return this.myTrackPerTestCoverage;
    }

    public void setTrackPerTestCoverage(boolean collectLineInfo) {
        this.myTrackPerTestCoverage = collectLineInfo;
    }

    public boolean isTrackTestFolders() {
        return this.myTrackTestFolders;
    }

    public void setTrackTestFolders(boolean trackTestFolders) {
        this.myTrackTestFolders = trackTestFolders;
    }

    public CoverageSuite getCurrentCoverageSuite() {
        return this.myCurrentCoverageSuite;
    }

    public void setCurrentCoverageSuite(CoverageSuite currentCoverageSuite) {
        this.myCurrentCoverageSuite = currentCoverageSuite;
    }

    public String getName() {
        return this.myConfiguration.getName();
    }

    public boolean canHavePerTestCoverage() {
        for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!coverageEngine.isApplicableTo(this.myConfiguration)) continue;
            return coverageEngine.canHavePerTestCoverage(this.myConfiguration);
        }
        return false;
    }

    public static boolean isApplicableTo(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.a(3);
        }
        if ((coverageEnabledConfiguration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) != null) {
            return true;
        }
        for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!coverageEngine.isApplicableTo(runConfiguration)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static CoverageEnabledConfiguration getOrCreate(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.a(4);
        }
        if ((coverageEnabledConfiguration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) == null) {
            for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageEngine.isApplicableTo(runConfiguration)) continue;
                coverageEnabledConfiguration = coverageEngine.createCoverageEnabledConfiguration(runConfiguration);
                break;
            }
            LOG.assertTrue(coverageEnabledConfiguration != null, (Object)("Coverage enabled run configuration wasn't found for run configuration: " + runConfiguration.getName() + ", type = " + runConfiguration.getClass().getName()));
            runConfiguration.putCopyableUserData(COVERAGE_KEY, (Object)coverageEnabledConfiguration);
        }
        CoverageEnabledConfiguration coverageEnabledConfiguration2 = coverageEnabledConfiguration;
        if (coverageEnabledConfiguration2 == null) {
            CoverageEnabledConfiguration.a(5);
        }
        return coverageEnabledConfiguration2;
    }

    @Nullable
    @NonNls
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath == null) {
            this.myCoverageFilePath = this.createCoverageFile();
        }
        return this.myCoverageFilePath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        long l2 = a ^ 0x31AF245702F2L;
        this.myIsCoverageEnabled = Boolean.parseBoolean(element.getAttributeValue(COVERAGE_ENABLED_ATTRIBUTE_NAME));
        String string = element.getAttributeValue(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME);
        this.myTrackPerTestCoverage = string == null || Boolean.valueOf(string) != false;
        this.mySampling = Boolean.parseBoolean(element.getAttributeValue(SAMPLING_COVERAGE_ATTRIBUTE_NAME, "true"));
        String string2 = element.getAttributeValue(TRACK_TEST_FOLDERS);
        this.myTrackTestFolders = string2 != null && Boolean.valueOf(string2) != false;
        String string3 = element.getAttributeValue(COVERAGE_RUNNER);
        if (string3 != null) {
            this.myRunnerId = string3;
            this.myCoverageRunner = null;
            for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)this.myRunnerId)) continue;
                this.myCoverageRunner = coverageRunner;
                break;
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = a ^ 0x3F22DBAFC671L;
        if (this.myIsCoverageEnabled) {
            element.setAttribute(COVERAGE_ENABLED_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (!this.myTrackPerTestCoverage) {
            element.setAttribute(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (!this.mySampling) {
            element.setAttribute(SAMPLING_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (this.myTrackTestFolders) {
            element.setAttribute(TRACK_TEST_FOLDERS, String.valueOf(true));
        }
        if (this.myCoverageRunner != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myCoverageRunner.getId());
        } else if (this.myRunnerId != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myRunnerId);
        }
    }

    @Nullable
    @NonNls
    protected String createCoverageFile() {
        if (this.myCoverageRunner == null) {
            return null;
        }
        @NonNls String string = PathManager.getSystemPath() + File.separator + "coverage";
        String string2 = string + File.separator + FileUtil.sanitizeFileName((String)this.myProject.getName()) + this.coverageFileNameSeparator() + FileUtil.sanitizeFileName((String)this.myConfiguration.getName()) + "." + this.myCoverageRunner.getDataFileExtension();
        new File(string).mkdirs();
        return string2;
    }

    protected String coverageFileNameSeparator() {
        return "$";
    }

    static {
        a = la.a(1961941773985623707L, -6736516703372702319L, MethodHandles.lookup().lookupClass()).a(43588755344394L);
        long l2 = a ^ 0x20FFF4CA82C0L;
        LOG = Logger.getInstance((String)CoverageEnabledConfiguration.class.getName());
        COVERAGE_KEY = Key.create((String)"com.intellij.coverage");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x1F5908E7F386L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = COVERAGE_RUNNER;
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "coverageRunnerExtensionRemoved";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

