/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCScopeInfo {
    @NotNull
    private final PsiElement scopeOwner;
    private boolean initialized;
    private List<PsiElement> linkedScopesToFindIn;
    private OCSymbolKind kindOfScope;
    private PsiElement parentScope;

    @Nullable
    public OCSymbolKind getKindOfScope() {
        this.lazyInit();
        return this.kindOfScope;
    }

    @Nullable
    public PsiElement getParentScope() {
        this.lazyInit();
        return this.parentScope;
    }

    @NotNull
    public LocalSearchScope getLocalSearchScope() {
        this.lazyInit();
        return new LocalSearchScope(this.linkedScopesToFindIn.toArray(PsiElement.EMPTY_ARRAY));
    }

    @NotNull
    public SearchScope getSearchScope() {
        PsiElement parent;
        if (!(this.scopeOwner instanceof OCDefineDirective) && (parent = PsiTreeUtil.getContextOfType((PsiElement)this.scopeOwner, (Class[])new Class[]{OCCallable.class})) != null && (parent != this.scopeOwner.getContext() || this.scopeOwner instanceof OCMethodSelectorPart)) {
            LocalSearchScope localSearchScope = this.getLocalSearchScope();
            if (localSearchScope == null) {
                OCScopeInfo.$$$reportNull$$$0(0);
            }
            return localSearchScope;
        }
        Project project = this.scopeOwner.getProject();
        GlobalSearchScope projectSourcesScope = OCSearchScope.getProjectSourcesScope(project);
        if (OCSearchScope.isInProjectSources(this.scopeOwner)) {
            GlobalSearchScope globalSearchScope = projectSourcesScope;
            if (globalSearchScope == null) {
                OCScopeInfo.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        SearchScope searchScope = projectSourcesScope.union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
        if (searchScope == null) {
            OCScopeInfo.$$$reportNull$$$0(2);
        }
        return searchScope;
    }

    @Contract(pure=true)
    public OCScopeInfo(@NotNull PsiElement element) {
        if (element == null) {
            OCScopeInfo.$$$reportNull$$$0(3);
        }
        this.initialized = false;
        this.scopeOwner = element;
    }

    private void addScopeToFindIn(@NotNull PsiElement scopeToFindIn) {
        if (scopeToFindIn == null) {
            OCScopeInfo.$$$reportNull$$$0(4);
        }
        this.createScopeToFindIn();
        this.linkedScopesToFindIn.add(scopeToFindIn);
    }

    private void addScopeToFindIn(@NotNull Collection<? extends PsiElement> scopesToFindIn) {
        if (scopesToFindIn == null) {
            OCScopeInfo.$$$reportNull$$$0(5);
        }
        this.createScopeToFindIn();
        this.linkedScopesToFindIn.addAll(scopesToFindIn);
    }

    private void addDefaultParentScopeToFindInIfEmpty(@NotNull PsiElement scopes) {
        if (scopes == null) {
            OCScopeInfo.$$$reportNull$$$0(6);
        }
        if (this.linkedScopesToFindIn == null) {
            this.addScopeToFindIn(scopes.getParent());
        }
    }

    private void createScopeToFindIn() {
        if (this.linkedScopesToFindIn == null) {
            this.linkedScopesToFindIn = new ArrayList<PsiElement>();
        }
    }

    private void lazyInit() {
        PsiElement scopeElement2;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Runnable functionSetup = () -> {
            this.kindOfScope = ((OCFunctionDeclaration)this.scopeOwner).getBody() != null ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.FUNCTION_PREDECLARATION;
            this.addScopeToFindIn(this.scopeOwner);
            this.addScopeToFindIn(DoxygenFacade.getCommentScope(this.scopeOwner));
        };
        Consumer<PsiElement> resetParentScopeToFindIn = scopeElement -> {
            if (scopeElement != null) {
                this.addScopeToFindIn((PsiElement)scopeElement);
                this.parentScope = scopeElement;
            }
        };
        this.parentScope = scopeElement2 = PsiTreeUtil.getContextOfType((PsiElement)this.scopeOwner, (Class[])new Class[]{OCLocalScopeable.class, OCTemplateParameterList.class, OCLambdaIntroducer.class});
        if (scopeElement2 instanceof OCEnum && !((OCEnum)scopeElement2).isEnumClass()) {
            this.kindOfScope = OCSymbolKind.ENUM_CONST;
            scopeElement2 = PsiTreeUtil.getContextOfType((PsiElement)this.scopeOwner, (Class[])new Class[]{OCLocalScopeable.class});
            resetParentScopeToFindIn.accept(scopeElement2);
        } else if (scopeElement2 instanceof OCStructLike) {
            if (!(this.scopeOwner instanceof OCFunctionDeclaration)) {
                this.kindOfScope = OCSymbolKind.STRUCT_FIELD;
            }
            this.addScopeToFindIn(scopeElement2);
        } else if (scopeElement2 instanceof OCTemplateParameterList) {
            if (this.scopeOwner instanceof OCTypeParameterDeclaration) {
                this.kindOfScope = OCSymbolKind.TEMPLATE_TYPE_PARAMETER;
            } else if (this.scopeOwner instanceof OCDeclarator) {
                this.kindOfScope = OCSymbolKind.TEMPLATE_VALUE_PARAMETER;
            }
            if (this.kindOfScope != null && (scopeElement2 = PsiTreeUtil.getContextOfType((PsiElement)scopeElement2, (Class[])new Class[]{OCDeclaration.class})) != null) {
                this.addScopeToFindIn(scopeElement2);
                this.addScopeToFindIn(DoxygenFacade.getCommentScope(scopeElement2));
                this.parentScope = scopeElement2;
            }
        } else if (scopeElement2 instanceof OCParameterList) {
            PsiElement parent = scopeElement2.getContext();
            if (parent instanceof OCCatchSection) {
                this.kindOfScope = OCSymbolKind.CATCH_EXCEPTION_VARIABLE;
                scopeElement2 = ((OCCatchSection)parent).getBody();
                resetParentScopeToFindIn.accept(scopeElement2);
            } else {
                this.kindOfScope = OCSymbolKind.PARAMETER;
                PsiElement callable = PsiTreeUtil.getContextOfType((PsiElement)scopeElement2, (Class[])new Class[]{OCCallable.class, OCParameterList.class, OCMethodSelectorPart.class, OCDeclarator.class, OCTypeElement.class});
                if (callable instanceof OCDeclarator && callable.getParent() instanceof OCCallable) {
                    callable = callable.getParent();
                }
                if (callable instanceof OCCallable) {
                    if (callable instanceof OCFunctionDefinition && (PsiTreeUtil.getChildOfType((PsiElement)((OCFunctionDefinition)callable).getDeclarator(), OCConstructorInitializationList.class) != null || PsiTreeUtil.getChildOfType((PsiElement)callable, OCCatchSection.class) != null)) {
                        resetParentScopeToFindIn.accept(callable);
                    } else {
                        OCBlockStatement body = ((OCCallable)callable).getBody();
                        OCNoexceptSpecifier noexceptSpecifier = ((OCCallable)callable).getNoexceptSpecifier();
                        OCTypeElement typeElement = callable instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)callable).getTrailingReturnTypeElement() : ((OCCallable)callable).getReturnTypeElement();
                        resetParentScopeToFindIn.accept(body != null ? body : scopeElement2);
                        if (noexceptSpecifier != null) {
                            this.addScopeToFindIn(noexceptSpecifier);
                        }
                        if (typeElement != null) {
                            this.addScopeToFindIn(typeElement);
                        }
                    }
                    this.addScopeToFindIn(DoxygenFacade.getCommentScope(callable));
                }
            }
        } else if (scopeElement2 instanceof OCMethod) {
            this.kindOfScope = OCSymbolKind.PARAMETER;
            OCBlockStatement blockStatement = ((OCMethod)scopeElement2).getBody();
            resetParentScopeToFindIn.accept(blockStatement);
            this.addScopeToFindIn(DoxygenFacade.getCommentScope(scopeElement2));
        } else if (scopeElement2 instanceof OCLambdaIntroducer) {
            scopeElement2 = ((OCLambdaExpression)scopeElement2.getParent()).getBody();
            resetParentScopeToFindIn.accept(scopeElement2);
        } else if (scopeElement2 != null) {
            resetParentScopeToFindIn.accept(scopeElement2);
        }
        if (this.scopeOwner instanceof OCFunctionDeclaration) {
            functionSetup.run();
        }
        this.addDefaultParentScopeToFindInIfEmpty(this.scopeOwner);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static OCScopeInfo createScopeInfo(@NotNull PsiElement element) {
        if (element == null) {
            OCScopeInfo.$$$reportNull$$$0(7);
        }
        return new OCScopeInfo(element);
    }

    public static boolean isLocalDeclarator(@NotNull PsiElement element) {
        Object symbol;
        if (element == null) {
            OCScopeInfo.$$$reportNull$$$0(8);
        }
        return element instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)element).getSymbol()) != null && symbol.getKind().isLocal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCScopeInfo";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeToFindIn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopesToFindIn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCScopeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addScopeToFindIn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultParentScopeToFindInIfEmpty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createScopeInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isLocalDeclarator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

