/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.MaybeFileOwnerSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.OCSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeSerializer
extends MaybeFileOwnerSerializer<OCIncludeSymbol> {
    @NotNull
    private final FileSymbolTableSerializer mySerializer;

    public OCIncludeSerializer(@NotNull FileSymbolTableSerializer serializer) {
        if (serializer == null) {
            OCIncludeSerializer.$$$reportNull$$$0(0);
        }
        super(serializer, OCIncludeSymbol.class);
        this.mySerializer = serializer;
    }

    @Override
    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull OCIncludeSymbol object) {
        if (kryo == null) {
            OCIncludeSerializer.$$$reportNull$$$0(1);
        }
        if (output == null) {
            OCIncludeSerializer.$$$reportNull$$$0(2);
        }
        if (object == null) {
            OCIncludeSerializer.$$$reportNull$$$0(3);
        }
        super.write(kryo, output, object);
        VirtualFile targetFile = object.getTargetFile();
        OCIncludeSerializer.writeTargetFile(output, targetFile);
    }

    public static void writeTargetFile(@NotNull Output output, @Nullable VirtualFile targetFile) {
        String path;
        int id;
        if (output == null) {
            OCIncludeSerializer.$$$reportNull$$$0(4);
        }
        if (targetFile != null && targetFile.isValid()) {
            if (targetFile instanceof VirtualFileWithId) {
                id = ((VirtualFileWithId)targetFile).getId();
                path = targetFile.getPath();
            } else {
                id = -1;
                path = CustomHeaderProvider.provideSerializationPathForFile(targetFile);
                if (path == null) {
                    OCSerializer.LOG.error("only LocalVirtualFiles are supported: " + targetFile.getClass() + ": " + targetFile);
                }
            }
        } else {
            id = -1;
            path = null;
        }
        output.writeInt(id, true);
        output.writeString(path);
    }

    public OCIncludeSymbol read(@NotNull Kryo kryo, @NotNull Input input, Class<OCIncludeSymbol> type) {
        if (kryo == null) {
            OCIncludeSerializer.$$$reportNull$$$0(5);
        }
        if (input == null) {
            OCIncludeSerializer.$$$reportNull$$$0(6);
        }
        OCIncludeSymbol include = (OCIncludeSymbol)super.read(kryo, input, type);
        VirtualFile targetFile = OCIncludeSerializer.readTargetFile(input, this.mySerializer);
        include.updateTargetFile(targetFile);
        return include;
    }

    @Nullable
    public static VirtualFile readTargetFile(@NotNull Input input, @NotNull FileSymbolTableSerializer serializer) {
        if (input == null) {
            OCIncludeSerializer.$$$reportNull$$$0(7);
        }
        if (serializer == null) {
            OCIncludeSerializer.$$$reportNull$$$0(8);
        }
        int fileId = input.readInt(true);
        String path = input.readString();
        VirtualFile targetFile = null;
        if (fileId != -1) {
            targetFile = PersistentFS.getInstance().findFileById(fileId);
        }
        if (!(path == null || targetFile != null && FileUtil.pathsEqual((String)path, (String)targetFile.getPath()) || (targetFile = LocalFileSystem.getInstance().findFileByPath(path)) != null)) {
            targetFile = CustomHeaderProvider.getCustomHeaderFile(path, serializer.getProject(), serializer.getCurrentFile());
        }
        return targetFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kryo";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/serialization/OCIncludeSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTargetFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "readTargetFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

