/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;

public class OCConvertLiteralIntentionAction
extends OCPsiElementQuickFix<OCExpression>
implements HighPriorityAction {
    private final OCType myLeftType;
    private final OCType myRightType;

    public OCConvertLiteralIntentionAction(@NotNull OCExpression expression, OCType leftType, OCType rightType) {
        if (expression == null) {
            OCConvertLiteralIntentionAction.$$$reportNull$$$0(0);
        }
        super(expression);
        this.myLeftType = leftType;
        this.myRightType = rightType;
    }

    @Override
    @IntentionFamilyName
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.family.name.convert.literal.type", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getTextInternal();
        if (string == null) {
            OCConvertLiteralIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull OCExpression element) {
        if (element == null) {
            OCConvertLiteralIntentionAction.$$$reportNull$$$0(2);
        }
        OCExpression expression = (OCExpression)this.myElementPtr.getElement();
        if (this.myLeftType == null || this.myRightType == null || !(expression instanceof OCLiteralExpression) || !OCSearchScope.isInProjectSources(expression.getParent())) {
            return false;
        }
        OCMacroRange call = OCElementUtil.getRangeInMacroCall(expression);
        if (call != null && !call.mapsToArguments()) {
            return false;
        }
        boolean isIdOrObject = this.myLeftType.isObjCRootType();
        return (this.myLeftType.isPointerToStringCompatible() || isIdOrObject) && this.myRightType.isPointerToChar() || (this.myLeftType.getName().equals("NSNumber *") || isIdOrObject) && this.myRightType instanceof OCNumericType && OCCompilerFeaturesHelper.supportsObjectLiterals(expression.getContainingOCFile());
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCExpression expression) {
        if (expression == null) {
            OCConvertLiteralIntentionAction.$$$reportNull$$$0(3);
        }
        OCChangeUtil.changeText(file.getProject(), file, expression.getRangeWithMacros().getStartOffset(), 0, "@", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCConvertLiteralIntentionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCConvertLiteralIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

