/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve.manager;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\f\u001a\u00020\u0005R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache;", "", "()V", "moduleMapLocationsCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "", "searchRootPath", "", "getSearchRootPath", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/lang/String;", "buildPossibleModuleMapLocations", "headersSearchRoot", "clear", "", "getPossibleModuleMapLocations", "Companion", "intellij.c"})
public final class ModuleMapLocationCache {
    private final ConcurrentMap<HeadersSearchRoot, Collection<HeadersSearchRoot>> moduleMapLocationsCache;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(@NotNull HeadersSearchRoot headersSearchRoot) {
        Intrinsics.checkNotNullParameter((Object)headersSearchRoot, (String)"headersSearchRoot");
        Collection<HeadersSearchRoot> collection = this.moduleMapLocationsCache.computeIfAbsent(headersSearchRoot, new Function(this){
            final /* synthetic */ ModuleMapLocationCache this$0;

            public final Collection<HeadersSearchRoot> apply(HeadersSearchRoot root) {
                HeadersSearchRoot headersSearchRoot = root;
                Intrinsics.checkNotNullExpressionValue((Object)headersSearchRoot, (String)"root");
                return ModuleMapLocationCache.access$buildPossibleModuleMapLocations(this.this$0, headersSearchRoot);
            }
            {
                this.this$0 = moduleMapLocationCache;
            }
        });
        Intrinsics.checkNotNullExpressionValue(collection, (String)"moduleMapLocationsCache.\u2026eMapLocations(root)\n    }");
        return collection;
    }

    private final Collection<HeadersSearchRoot> buildPossibleModuleMapLocations(HeadersSearchRoot headersSearchRoot) {
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            ModuleMapLog.LOG.trace("Collecting possible module map locations for " + this.getSearchRootPath(headersSearchRoot));
        }
        Collection<HeadersSearchRoot> possibleLocations = ModuleMapUtil.getPossibleModuleMapLocations(headersSearchRoot);
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            Iterable $this$forEach$iv = possibleLocations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HeadersSearchRoot possibleLocation = (HeadersSearchRoot)element$iv;
                boolean bl = false;
                ModuleMapLog.LOG.trace("  found possible location " + this.getSearchRootPath(possibleLocation));
            }
        }
        return possibleLocations;
    }

    private final String getSearchRootPath(HeadersSearchRoot $this$searchRootPath) {
        Object object = $this$searchRootPath.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            String string = $this$searchRootPath.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        }
        return object;
    }

    public final void clear() {
        this.moduleMapLocationsCache.clear();
    }

    public ModuleMapLocationCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConcurrentSoftMap()");
        this.moduleMapLocationsCache = concurrentMap;
    }

    public static final /* synthetic */ Collection access$buildPossibleModuleMapLocations(ModuleMapLocationCache $this, HeadersSearchRoot headersSearchRoot) {
        return $this.buildPossibleModuleMapLocations(headersSearchRoot);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c"})
    public static final class Companion {
        @NotNull
        public final ModuleMapLocationCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ModuleMapLocationCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (ModuleMapLocationCache)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

