/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveIvarsToImplementationIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message("intentions.move.instance.variables", new Object[0]);
        if (string == null) {
            OCMoveIvarsToImplementationIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCMoveIvarsToImplementationIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            OCMoveIvarsToImplementationIntentionAction.$$$reportNull$$$0(2);
        }
        Pair<OCInstanceVariablesList, OCInstanceVariablesList> pair = this.locateCandidate(editor, file);
        return OCCompilerFeaturesHelper.supportsIvarsInImplementation() && pair != null && OCCodeInsightUtil.isValid((PsiElement)pair.getFirst()) && OCCodeInsightUtil.isValid((PsiElement)pair.getSecond()) && !((OCInstanceVariablesList)pair.getFirst()).isEmpty() && ((OCInstanceVariablesList)pair.getSecond()).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            OCMoveIvarsToImplementationIntentionAction.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Pair<OCInstanceVariablesList, OCInstanceVariablesList> pair = this.locateCandidate(editor, file);
        if (pair != null) {
            PsiFile srcFile = ((OCInstanceVariablesList)pair.getFirst()).getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(srcFile)) {
                return;
            }
            PsiFile dstFile = ((OCInstanceVariablesList)pair.getSecond()).getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(dstFile)) {
                return;
            }
            OCChangeUtil.changeText(project, dstFile, ((OCInstanceVariablesList)pair.getSecond()).getTextOffset(), 0, ((OCInstanceVariablesList)pair.getFirst()).getTextWithMacros(), true);
            OCChangeUtil.changeText(project, srcFile, ((OCInstanceVariablesList)pair.getFirst()).getTextOffset(), ((OCInstanceVariablesList)pair.getFirst()).getTextLength(), "", true);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    protected Pair<OCInstanceVariablesList, OCInstanceVariablesList> locateCandidate(Editor editor, PsiFile file) {
        PsiElement implementation;
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCInstanceVariablesList intfList = OCElementUtil.getAdjacentParentOfType(at, OCInstanceVariablesList.class);
        OCInterface anInterface = (OCInterface)PsiTreeUtil.getParentOfType((PsiElement)intfList, OCInterface.class);
        if (anInterface == null) {
            return null;
        }
        OCInterfaceSymbol interfaceSymbol = anInterface.getSymbol();
        Project project = file.getProject();
        OCImplementationSymbol implementationSymbol = interfaceSymbol != null ? interfaceSymbol.getImplementation(project) : null;
        PsiElement psiElement = implementation = implementationSymbol != null ? implementationSymbol.locateDefinition(project) : null;
        if (implementation instanceof OCClassDeclaration) {
            return Pair.create((Object)intfList, (Object)((OCClassDeclaration)implementation).getInstanceVariablesList());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCMoveIvarsToImplementationIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCMoveIvarsToImplementationIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

