/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionQuickFix;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import org.jetbrains.annotations.NotNull;

public class NotImplementedFunctions
extends OCInspections.Functions {
    public boolean runForWholeFile() {
        return true;
    }

    public boolean worksWithClangd() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            NotImplementedFunctions.$$$reportNull$$$0(0);
        }
        if (!OCSearchScope.isInProjectSources((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                NotImplementedFunctions.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new OCVisitor(){

            @Override
            public void visitFunctionDeclaration(@NotNull OCFunctionDeclaration function) {
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (function instanceof OCFunctionDefinition) {
                    return;
                }
                if (!function.isPossibleStructMember()) {
                    return;
                }
                OCDeclarator declarator = function.getDeclarator();
                if (declarator != null && declarator.getInitializer() != null) {
                    return;
                }
                OCFunctionSymbol symbol = (OCFunctionSymbol)ObjectUtils.tryCast((Object)function.getSymbol(), OCFunctionSymbol.class);
                if (symbol != null && symbol.isPredeclaration() && !symbol.isDefault() && !symbol.isDelete() && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(symbol, true, holder.getProject()) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.REQUIRED) {
                    OCCompilationContext compilationContext = OCCompilationContext.create(function);
                    OCInspection.registerProblem(holder, null, null, isOnTheFly, function.getHeaderRange(), OCBundle.message("inspection.message.function.not.implemented", symbol.getNameWithKindUppercase(compilationContext)), "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NotImplementedFunctions.class, new OCGenerateDefinitionQuickFix(symbol, true, compilationContext), new OCGenerateDefinitionQuickFix(symbol, false, compilationContext), new OCMakeFunctionVirtualFix(symbol, true, holder.getProject()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/inspections/NotImplementedFunctions$1", "visitFunctionDeclaration"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/NotImplementedFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/NotImplementedFunctions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

