/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.application.options.CodeStyle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCConvertMemberRefactoringProcessor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateIvarsHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCPropertySymbol, OCGenerateIvarsActionContext> {
    private static final OCBooleanOption SHOW_SYNTHESIZED = new OCBooleanOption(OCGenerateBundle.message("generate.ivars.handler.show.synthesized", new Object[0]));

    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        return OCGenerateBundle.message("generate.ivars.handler.members.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getActionTitle() {
        String string = OCGenerateBundle.message("generate.ivars.handler.action.title", new Object[0]);
        if (string == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NlsContexts.DialogMessage
    protected String getNoMembersMessage(@NotNull OCGenerateIvarsActionContext context) {
        if (context == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(1);
        }
        String parentName = context.getParentNameUppercase();
        return OCGenerateBundle.message("generate.ivars.handler.no.members.message", parentName);
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateIvarsActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(2);
        }
        if (options == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(3);
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_SYNTHESIZED, (Object)true));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    @NotNull
    protected OCGenerateIvarsActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(4);
        }
        return new OCGenerateIvarsActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element);
    }

    public static boolean isPropertyDefective(OCPropertySymbol property, @NotNull Project project) {
        OCClassSymbol parent;
        if (project == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(5);
        }
        if ((parent = property.getParent()) instanceof OCProtocolSymbol) {
            return false;
        }
        OCType type = parent.getType().resolve(OCResolveContext.forSymbol(parent, project), true);
        if (type instanceof OCObjectType) {
            OCGenerateIvarsActionContext context = new OCGenerateIvarsActionContext(parent, (OCObjectType)type, parent.getContainingOCFile(project));
            return OCGenerateIvarsHandler.getDefectiveCondition(context).value((Object)property);
        }
        return false;
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCGenerateIvarsActionContext context, @NotNull List<OCPropertySymbol> properties) {
        if (project == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(7);
        }
        if (context == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            OCGenerateIvarsHandler.$$$reportNull$$$0(9);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class);
        boolean declareInImpl = OCCompilerFeaturesHelper.supportsIvarsInImplementation() && settings.PUT_IVARS_TO_IMPLEMENTATION;
        this.performAction(file, context, properties, null, declareInImpl);
    }

    public void performAction(PsiFile file, OCGenerateIvarsActionContext context, List<OCPropertySymbol> properties, String customName, boolean declareInImplementation) {
        OCClassSymbol parent;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        OCInterfaceSymbol interfaceSymbol = (OCInterfaceSymbol)context.getInterfaceSymbol();
        OCImplementationSymbol implementationSymbol = context.getImplementationSymbol();
        HashMap ivarNames = new HashMap();
        ArrayList<String> nonReleasedIvarNames = new ArrayList<String>();
        HashMap newDeclarations = new HashMap();
        HashMap existingDeclarations = new HashMap();
        ArrayList synthesizes = new ArrayList();
        boolean replaceAllProps = this.replaceAllProperties();
        Condition<OCPropertySymbol> defectiveCondition = OCGenerateIvarsHandler.getDefectiveCondition(context);
        PsiFile psiContext = context.getContext().isValid() ? context.getContext() : file;
        ArrayList<OCPropertySymbol> nonReleasedProperties = new ArrayList<OCPropertySymbol>();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(file);
        ApplicationManager.getApplication().runWriteAction(() -> this.lambda$performAction$0(properties, replaceAllProps, defectiveCondition, context, customName, ivarNames, interfaceSymbol, implementationSymbol, (PsiElement)psiContext, file, newDeclarations, existingDeclarations, synthesizes, ivarsInfo, nonReleasedProperties, nonReleasedIvarNames));
        if (!newDeclarations.isEmpty()) {
            Boolean generateIvars = this.generateIvars(file.getProject());
            if (generateIvars == null) {
                return;
            }
            if (!generateIvars.booleanValue()) {
                newDeclarations.clear();
            }
        }
        OCReleaseVariablesIntentionAction releaseAction = null;
        if (OCCompilerFeaturesHelper.isArcDisabled(file) && !nonReleasedProperties.isEmpty()) {
            parent = properties.get(0).getParent();
            releaseAction = new OCReleaseVariablesIntentionAction(OCSymbolKind.INSTANCE_VARIABLE, parent, nonReleasedProperties, nonReleasedIvarNames, file.getProject());
        }
        parent = declareInImplementation ? context.getImplementationSymbol() : context.getInterfaceSymbol();
        OCConvertMemberRefactoringProcessor<OCPropertySymbol> processor = new OCConvertMemberRefactoringProcessor<OCPropertySymbol>(parent, properties, ivarNames, newDeclarations, existingDeclarations, replaceAllProps ? null : synthesizes, releaseAction, (OCElementType)OCTokenTypes.DEREF, this.getActionTitle(), replaceAllProps, context.getProject()){

            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
                if (conflicts == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OCGenerateIvarsHandler.this.passConflictsToTest(new ArrayList<String>(conflicts.values()));
                    this.prepareSuccessful();
                    return true;
                }
                return super.showConflicts(conflicts, usages);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/jetbrains/cidr/lang/generate/handlers/OCGenerateIvarsHandler$2", "showConflicts"));
            }
        };
        processor.run();
    }

    protected void passConflictsToTest(List<String> conflicts) {
    }

    protected boolean replaceAllProperties() {
        return false;
    }

    @Nullable
    protected static Boolean askGenerateIvars(Project project) {
        Ref result = Ref.create();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        OCCodeStyleSettings.RememberedOption option = OCCodeStyleSettings.askAndSave(settings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES, OCBundle.message("dialog.message.objc.do.you.want.to.generate.instance.variables.for.chosen.properties", new Object[0]), OCBundle.message("dialog.title.objc.generate.instance.variables", new Object[0]), (Ref<Boolean>)result);
        if (option == null) {
            return null;
        }
        settings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES = option;
        return (Boolean)result.get();
    }

    @Nullable
    protected Boolean generateIvars(Project project) {
        if (this.replaceAllProperties()) {
            return true;
        }
        return OCGenerateIvarsHandler.askGenerateIvars(project);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCPropertySymbol> candidates, OCGenerateIvarsActionContext actionContext, int moreNodesLevel) {
        if (OCGenerateIvarsHandler.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED).booleanValue()) {
            return super.getChooserNodes(chooser, candidates, actionContext, moreNodesLevel);
        }
        Condition<OCPropertySymbol> condition = OCGenerateIvarsHandler.getDefectiveCondition(actionContext);
        return super.getChooserNodes(chooser, ContainerUtil.filter(candidates, condition), actionContext, moreNodesLevel);
    }

    private static Condition<OCPropertySymbol> getDefectiveCondition(OCGenerateIvarsActionContext actionContext) {
        HashMap implementedProperties = new HashMap();
        actionContext.getType().processMembers(OCMemberSymbol.class, member -> {
            if (member instanceof OCSynthesizeSymbol) {
                implementedProperties.put(member.getName(), 10);
            } else if (member instanceof OCMethodSymbol && member.isDefinition()) {
                OCPropertySymbol property;
                OCMethodSymbol intfMethod = (OCMethodSymbol)member.getAssociatedSymbol(actionContext.getProject());
                OCPropertySymbol oCPropertySymbol = property = intfMethod != null ? intfMethod.getGeneratedFromProperty() : null;
                if (property != null) {
                    Integer curValue = (Integer)implementedProperties.get(property.getName());
                    implementedProperties.put(property.getName(), curValue != null ? curValue + 1 : 1);
                }
            }
            return true;
        });
        return property -> {
            String categoryName = property.getParent().getCategoryName();
            if (categoryName != null && !categoryName.isEmpty()) {
                return false;
            }
            if (property.getParent().equals(actionContext.getInterfaceSymbol())) {
                Integer value = (Integer)implementedProperties.get(property.getName());
                return (property.isReadonly() ? 1 : 2) > (value != null ? value : 0);
            }
            return property.getAssociatedSymbol(actionContext.getProject()) == null;
        };
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCPropertySymbol> candidates, OCOption option, OCGenerateIvarsActionContext actionContext) {
        if (SHOW_SYNTHESIZED.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    private /* synthetic */ void lambda$performAction$0(List properties, boolean replaceAllProps, Condition defectiveCondition, OCGenerateIvarsActionContext context, String customName, Map ivarNames, OCInterfaceSymbol interfaceSymbol, OCImplementationSymbol implementationSymbol, PsiElement psiContext, PsiFile file, Map newDeclarations, Map existingDeclarations, List synthesizes, OCNotReleasedIvarInspection.IvarsInfo ivarsInfo, List nonReleasedProperties, List nonReleasedIvarNames) {
        for (OCPropertySymbol property : properties) {
            if (!replaceAllProps && !defectiveCondition.value((Object)property)) continue;
            OCInstanceVariableSymbol associatedIvar = property.getAssociatedIvar(context.getProject());
            String ivarName = customName != null ? customName : (associatedIvar != null ? associatedIvar.getName() : OCNameSuggester.getNonCollidingName(property, context.getProject()));
            ivarNames.put(property, ivarName);
            CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol> finder = new CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol>(){

                protected boolean accept(OCInstanceVariableSymbol symbol) {
                    return symbol.getGeneratedFromProperty() == null;
                }
            };
            interfaceSymbol.processMembersInAllCategories(ivarName, OCInstanceVariableSymbol.class, finder, context.getProject());
            implementationSymbol.processMembers(ivarName, OCInstanceVariableSymbol.class, finder);
            OCType type = property.getResolvedType(OCResolveContext.forPsi(psiContext));
            if (!finder.isFound()) {
                ARCAttribute ivarAttribute;
                OCPropertySymbol.FlagAttribute propAttribute = property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, (PsiElement)file);
                String modifier = null;
                if (OCCompilerFeaturesHelper.isArcEnabled(file) && type.isPointerToObjectCompatible() && !(ivarAttribute = propAttribute.getIvarCompatibleARCAttribute()).isDefault()) {
                    modifier = ivarAttribute.getTokenName();
                }
                newDeclarations.put(property, OCElementFactory.declaration(modifier, ivarName, property.getType(), psiContext));
            } else {
                existingDeclarations.put(property, (OCMemberSymbol)finder.getFoundValue());
            }
            if (replaceAllProps) continue;
            String name = ivarName.equals(property.getName()) ? null : ivarName;
            OCSynthesizePropertiesList synthesize = OCElementFactory.synthesizeList("@synthesize", property.getName(), name, psiContext);
            synthesizes.add(synthesize);
            if (!type.isPointerToObjectCompatible() || !property.isRetained() || finder.isFound() && ivarsInfo != null && OCNotReleasedIvarInspection.isIvarReleased((OCInstanceVariableSymbol)finder.getFoundValue(), file, ivarsInfo)) continue;
            nonReleasedProperties.add(property);
            nonReleasedIvarNames.add(ivarName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateIvarsHandler";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateIvarsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNoMembersMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyDefective";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

