/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;

public class OCIfSurrounder
extends OCStatementSurrounder<OCIfStatement> {
    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "if (a) {\n}";
    }

    @Override
    protected PsiElement getInsertionPlace(OCIfStatement statement) {
        return statement.getThenBranch();
    }

    @Override
    protected TextRange getSelectionRange(OCIfStatement statement) {
        OCCondition condition = statement.getCondition();
        int offset = condition.getRangeWithMacros().getStartOffset();
        OCChangeUtil.delete(condition);
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return OCBundle.message("surround.with.if.template", new Object[0]);
    }
}

