/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @NonNls
    private static final String ourLineEndWhilePasteInString = "\\n\"\n \"";

    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!this.isSupportedFile(file)) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        boolean isLiteral = true;
        for (int i2 = 0; i2 < startOffsets.length && isLiteral; ++i2) {
            if (OCStringLiteralCopyPasteProcessor.findLiteralTokenType(document.getCharsSequence(), startOffsets[i2], endOffsets[i2]) != null) continue;
            isLiteral = false;
        }
        return isLiteral ? StringUtil.unescapeStringCharacters((String)text) : null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!this.isSupportedFile(file)) {
            String string = text;
            if (string == null) {
                OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        IElementType tokenType = OCStringLiteralCopyPasteProcessor.findLiteralTokenType(editor.getDocument().getCharsSequence(), selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        if (tokenType == OCTokenTypes.STRING_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
                }
                return string;
            }
            StringBuilder buffer = new StringBuilder(text.length());
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                String line = lines[i2];
                buffer.append(StringUtil.escapeStringCharacters((String)line));
                if (i2 == lines.length - 1) continue;
                buffer.append(ourLineEndWhilePasteInString);
            }
            text = buffer.toString();
        } else if (tokenType == OCTokenTypes.CHARACTER_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
                }
                return string;
            }
            return OCStringLiteralCopyPasteProcessor.escapeCharCharacters(text);
        }
        String string = text;
        if (string == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected boolean isSupportedFile(PsiFile file) {
        return file instanceof OCPsiFile;
    }

    @Nullable
    private static IElementType findLiteralTokenType(@NotNull CharSequence documentText, int selectionStart, int selectionEnd) {
        if (documentText == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.maxLanguage()).build());
        lexer.start(documentText);
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if ((tokenType == OCTokenTypes.STRING_LITERAL || tokenType == OCTokenTypes.CHARACTER_LITERAL) && lexer.getTokenStart() < selectionStart && selectionEnd < lexer.getTokenEnd()) {
                return tokenType;
            }
            lexer.advance();
        }
        return null;
    }

    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buffer);
        String string = buffer.toString();
        if (string == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        if (project == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLiteralTokenType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

