/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.external.system.fixtures;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.cpp.CPPProjectFixture;
import com.jetbrains.cidr.cpp.assertions.CPPAssertions;
import com.jetbrains.cidr.cpp.assertions.CppSoftAssertions;
import com.jetbrains.cidr.cpp.external.system.ExtSysWaitingContext;
import com.jetbrains.cidr.cpp.external.system.fixtures.ExtSysAbstractProjectFixture;
import com.jetbrains.cidr.cpp.external.system.fixtures.ExtSysProjectFixture;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspaceListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.io.File;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ProxyableListAssert;
import org.assertj.core.api.SoftAssertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010&\u001a\u00020'H\u0004J\b\u0010(\u001a\u00020\u0010H\u0004J\b\u0010)\u001a\u00020\u001cH\u0004J(\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020#2\b\u0010/\u001a\u0004\u0018\u000100H\u0004J*\u00101\u001a\u0004\u0018\u00010\u00022\u0016\u00102\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u000304032\b\u00105\u001a\u0004\u0018\u000106J\b\u00107\u001a\u00020$H&J\u0010\u00108\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0002H\u0004J4\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020\n2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010\n2\u0006\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020#H\u0002J2\u0010@\u001a\u00020'2\u0006\u0010:\u001a\u00020\n2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010\n2\u0006\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020#J\u0016\u0010A\u001a\u00020'2\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\nJ\b\u0010D\u001a\u00020'H\u0016R,\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020#*\u00020$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010%\u00a8\u0006E"}, d2={"Lcom/jetbrains/cidr/cpp/external/system/fixtures/ExtSysAbstractProjectFixture;", "Lcom/jetbrains/cidr/cpp/CPPProjectFixture;", "", "Lcom/jetbrains/cidr/cpp/external/system/fixtures/ExtSysProjectFixture;", "dataFixture", "Lcom/jetbrains/cidr/CidrTestDataFixture;", "(Lcom/jetbrains/cidr/CidrTestDataFixture;)V", "additionalModelContext", "", "Lkotlin/Pair;", "", "getAdditionalModelContext", "()Ljava/util/List;", "setAdditionalModelContext", "(Ljava/util/List;)V", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "getConnection", "()Lcom/intellij/util/messages/MessageBusConnection;", "setConnection", "(Lcom/intellij/util/messages/MessageBusConnection;)V", "externalSystemProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getExternalSystemProjectFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setExternalSystemProjectFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "<set-?>", "Lcom/jetbrains/cidr/cpp/external/system/ExtSysWaitingContext;", "waitingContext", "getWaitingContext", "()Lcom/jetbrains/cidr/cpp/external/system/ExtSysWaitingContext;", "setWaitingContext", "(Lcom/jetbrains/cidr/cpp/external/system/ExtSysWaitingContext;)V", "isSupported", "", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "(Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;)Z", "checkCPPProjectOpenedCorrectly", "", "createConnection", "createWaitingContext", "doBuildOrCleanConfig", "Lcom/jetbrains/cidr/execution/ExecutionResult;", "Lcom/jetbrains/cidr/execution/build/CidrBuildResult;", "config", "build", "listener", "Lcom/intellij/execution/process/ProcessListener;", "getBuildConfiguration", "runConfiguration", "Lcom/jetbrains/cidr/execution/CidrRunConfiguration;", "Lcom/jetbrains/cidr/execution/CidrBuildTarget;", "executionTarget", "Lcom/intellij/execution/ExecutionTarget;", "getCidrWorkspace", "getConfigBuildId", "initProject", "relativeProjectPath", "buildSymbolTables", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$SymbolsProperties$SymbolsKind;", "relativeFilesToCopyPath", "openProject", "expectFailures", "initProjectAndWait", "setUp", "testClassFQN", "testName", "tearDown", "intellij.clion.testFramework"})
public abstract class ExtSysAbstractProjectFixture
extends CPPProjectFixture
implements ExtSysProjectFixture {
    protected volatile VirtualFile externalSystemProjectFile;
    @Nullable
    private volatile MessageBusConnection connection;
    @Nullable
    private volatile ExtSysWaitingContext waitingContext;
    @NotNull
    private volatile List<Pair<String, String>> additionalModelContext;

    @NotNull
    protected final VirtualFile getExternalSystemProjectFile() {
        VirtualFile virtualFile = this.externalSystemProjectFile;
        if (virtualFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"externalSystemProjectFile");
        }
        return virtualFile;
    }

    protected final void setExternalSystemProjectFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<set-?>");
        this.externalSystemProjectFile = virtualFile;
    }

    @Nullable
    protected final MessageBusConnection getConnection() {
        return this.connection;
    }

    protected final void setConnection(@Nullable MessageBusConnection messageBusConnection) {
        this.connection = messageBusConnection;
    }

    @Override
    @Nullable
    public final ExtSysWaitingContext getWaitingContext() {
        return this.waitingContext;
    }

    protected final void setWaitingContext(@Nullable ExtSysWaitingContext extSysWaitingContext) {
        this.waitingContext = extSysWaitingContext;
    }

    @Override
    @NotNull
    public final List<Pair<String, String>> getAdditionalModelContext() {
        return this.additionalModelContext;
    }

    @Override
    public final void setAdditionalModelContext(@NotNull List<Pair<String, String>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.additionalModelContext = list;
    }

    protected abstract boolean isSupported(@NotNull ExternalWorkspace var1);

    @NotNull
    public abstract ExternalWorkspace getCidrWorkspace();

    @Override
    public final void setUp(@NotNull String testClassFQN, @NotNull String testName) {
        Intrinsics.checkNotNullParameter((Object)testClassFQN, (String)"testClassFQN");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        super.setUp(testClassFQN, testName);
        this.getTaskListener().reset();
        ExtensionPointName extensionPointName = ExternalSystemTaskNotificationListener.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExternalSystemTaskNotificationListener.EP_NAME");
        extensionPointName.getPoint().registerExtension((Object)this.getTaskListener(), this.getTestRootDisposable());
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.additionalModelContext = CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public final Void getBuildConfiguration(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> runConfiguration, @Nullable ExecutionTarget executionTarget) {
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected final ExecutionResult<CidrBuildResult> doBuildOrCleanConfig(@NotNull Void config, boolean build2, @Nullable ProcessListener listener) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected final String getConfigBuildId(@NotNull Void config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        throw (Throwable)new UnsupportedOperationException();
    }

    private final void initProject(String relativeProjectPath, FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables, String relativeFilesToCopyPath, boolean openProject, boolean expectFailures) {
        if (buildSymbolTables == null) {
            this.initProject(relativeProjectPath, relativeFilesToCopyPath, openProject);
        } else {
            this.initProject(new CidrTestProjectDescription(relativeProjectPath, relativeFilesToCopyPath, openProject), buildSymbolTables);
        }
        if (openProject) {
            CppSoftAssertions.assertSoftly((Function1<? super SoftAssertions, Unit>)((Function1)new Function1<SoftAssertions, Unit>(this, expectFailures){
                final /* synthetic */ ExtSysAbstractProjectFixture this$0;
                final /* synthetic */ boolean $expectFailures;

                public final void invoke(@NotNull SoftAssertions $this$assertSoftly) {
                    Intrinsics.checkNotNullParameter((Object)$this$assertSoftly, (String)"$receiver");
                    Object object = $this$assertSoftly.assertThat(this.this$0.getTaskListener().isStarted()).describedAs("Task listener started?", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertThat(taskListener.\u2026\"Task listener started?\")");
                    ((BooleanAssert)object).isTrue();
                    Object object2 = $this$assertSoftly.assertThat(this.this$0.getTaskListener().isFinished()).describedAs("Task listener finished?", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"assertThat(taskListener.\u2026Task listener finished?\")");
                    ((BooleanAssert)object2).isTrue();
                    Object object3 = $this$assertSoftly.assertThat(this.this$0.getTaskListener().isSucceeded()).describedAs("Task listener succeeded?", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"assertThat(taskListener.\u2026ask listener succeeded?\")");
                    ((BooleanAssert)object3).isTrue();
                    Object object4 = $this$assertSoftly.assertThat(this.this$0.getTaskListener().isFailed()).describedAs("Task listener failed?", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"assertThat(taskListener.\u2026(\"Task listener failed?\")");
                    ((BooleanAssert)object4).isFalse();
                    Object object5 = $this$assertSoftly.assertThat(this.this$0.getTaskListener().isCancelled()).describedAs("Task listener was cancelled?", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"assertThat(taskListener.\u2026listener was cancelled?\")");
                    ((BooleanAssert)object5).isFalse();
                    List taskListenerFailures2 = SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.this$0.getTaskListener().getFailures()), (Function1)initProject.taskListenerFailures.1.INSTANCE)));
                    AbstractListAssert abstractListAssert = $this$assertSoftly.assertThat(taskListenerFailures2).describedAs("Task listener failures", new Object[0]);
                    boolean bl = false;
                    boolean bl2 = false;
                    ProxyableListAssert $this$apply = (ProxyableListAssert)abstractListAssert;
                    boolean bl3 = false;
                    if (this.$expectFailures) {
                        $this$apply.isNotEmpty();
                    } else {
                        $this$apply.isEmpty();
                    }
                    Iterable $this$forEach$iv = this.this$0.getTaskListener().getErrors();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Throwable error = (Throwable)element$iv;
                        boolean bl4 = false;
                        $this$assertSoftly.fail(ExceptionsKt.stackTraceToString((Throwable)error), error);
                    }
                }
                {
                    this.this$0 = extSysAbstractProjectFixture;
                    this.$expectFailures = bl;
                    super(1);
                }
            }));
        }
    }

    @Override
    public final void initProjectAndWait(@NotNull String relativeProjectPath, @Nullable FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables, @Nullable String relativeFilesToCopyPath, boolean openProject, boolean expectFailures) {
        Intrinsics.checkNotNullParameter((Object)relativeProjectPath, (String)"relativeProjectPath");
        this.initProject(relativeProjectPath, buildSymbolTables, relativeFilesToCopyPath, openProject, expectFailures);
        if (openProject) {
            ExtSysWaitingContext waitingContextSnapshot = CPPAssertions.assertNotNull(this.waitingContext, "Waiting context");
            waitingContextSnapshot.waitForInitialized();
            waitingContextSnapshot.waitForUpdateScheduled();
            waitingContextSnapshot.waitForUpdateStarted();
            waitingContextSnapshot.waitForUpdateFinished();
        }
    }

    @Override
    protected final void checkCPPProjectOpenedCorrectly() {
        Object object = Assertions.assertThat((boolean)this.getCidrWorkspace().isInitialized()).describedAs("CIDR workspace initialized", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertThat(cidrWorkspace\u2026R workspace initialized\")");
        ((AbstractBooleanAssert)object).isTrue();
    }

    @NotNull
    protected final MessageBusConnection createConnection() {
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection == null) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            MessageBusConnection messageBusConnection2 = application.getMessageBus().connect(this.getTestRootDisposable());
            messageBusConnection = messageBusConnection2;
            Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"ApplicationManager.getAp\u2026nnect(testRootDisposable)");
        }
        return messageBusConnection;
    }

    @NotNull
    protected final ExtSysWaitingContext createWaitingContext() {
        ExtSysWaitingContext waitingContextSnapshot = this.waitingContext;
        if (waitingContextSnapshot != null) {
            return waitingContextSnapshot;
        }
        MessageBusConnection connectionSnapshot = CPPAssertions.assertNotNull(this.connection, "Connection");
        ExtSysWaitingContext context = new ExtSysWaitingContext();
        connectionSnapshot.subscribe(ExternalWorkspaceListener.TOPIC, (Object)new ExternalWorkspaceListener(this, context){
            final /* synthetic */ ExtSysAbstractProjectFixture this$0;
            final /* synthetic */ ExtSysWaitingContext $context;

            public void initialized(@NotNull ExternalWorkspace workspace, @Nullable File projectDir) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                if (this.this$0.isSupported(workspace)) {
                    Project project2 = workspace.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"workspace.project");
                    if (Intrinsics.areEqual((Object)project2.getBasePath(), (Object)this.this$0.getProjectDirPath())) {
                        this.$context.initialized();
                    }
                }
            }

            public void updateScheduled(@NotNull ExternalWorkspace workspace) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                if (this.this$0.isSupported(workspace)) {
                    Project project2 = workspace.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"workspace.project");
                    if (Intrinsics.areEqual((Object)project2.getBasePath(), (Object)this.this$0.getProjectDirPath())) {
                        this.$context.updateScheduled();
                    }
                }
            }

            public void updateStarted(@NotNull ExternalWorkspace workspace) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                if (this.this$0.isSupported(workspace)) {
                    Project project2 = workspace.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"workspace.project");
                    if (Intrinsics.areEqual((Object)project2.getBasePath(), (Object)this.this$0.getProjectDirPath())) {
                        this.$context.updateStarted();
                    }
                }
            }

            public void updateFinished(@NotNull ExternalWorkspace workspace) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                if (this.this$0.isSupported(workspace)) {
                    Project project2 = workspace.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"workspace.project");
                    if (Intrinsics.areEqual((Object)project2.getBasePath(), (Object)this.this$0.getProjectDirPath())) {
                        this.$context.updateFinished();
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$context = $captured_local_variable$1;
            }
        });
        return context;
    }

    protected ExtSysAbstractProjectFixture(@NotNull CidrTestDataFixture dataFixture) {
        Intrinsics.checkNotNullParameter((Object)dataFixture, (String)"dataFixture");
        super(dataFixture);
        this.additionalModelContext = CollectionsKt.emptyList();
    }
}

