/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchRequest;

public final class FetchV2Request
extends FetchRequest {
    private final List<ObjectId> peerHas;
    private final TreeMap<String, ObjectId> wantedRefs;
    private final boolean doneReceived;
    @NonNull
    private final List<String> serverOptions;

    FetchV2Request(@NonNull List<ObjectId> peerHas, @NonNull TreeMap<String, ObjectId> wantedRefs, @NonNull Set<ObjectId> wantIds, @NonNull Set<ObjectId> clientShallowCommits, int deepenSince, @NonNull List<String> deepenNotRefs, int depth, long filterBlobLimit, boolean doneReceived, @NonNull Set<String> clientCapabilities, @Nullable String agent, @NonNull List<String> serverOptions) {
        super(wantIds, depth, clientShallowCommits, filterBlobLimit, clientCapabilities, deepenSince, deepenNotRefs, agent);
        this.peerHas = Objects.requireNonNull(peerHas);
        this.wantedRefs = Objects.requireNonNull(wantedRefs);
        this.doneReceived = doneReceived;
        this.serverOptions = Objects.requireNonNull(serverOptions);
    }

    @NonNull
    List<ObjectId> getPeerHas() {
        return this.peerHas;
    }

    @NonNull
    Map<String, ObjectId> getWantedRefs() {
        return this.wantedRefs;
    }

    boolean wasDoneReceived() {
        return this.doneReceived;
    }

    @NonNull
    public List<String> getServerOptions() {
        return this.serverOptions;
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        final List<ObjectId> peerHas = new ArrayList<ObjectId>();
        final TreeMap<String, ObjectId> wantedRefs = new TreeMap();
        final Set<ObjectId> wantIds = new HashSet<ObjectId>();
        final Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
        final List<String> deepenNotRefs = new ArrayList<String>();
        final Set<String> clientCapabilities = new HashSet<String>();
        int depth;
        int deepenSince;
        long filterBlobLimit = -1L;
        boolean doneReceived;
        @Nullable
        String agent;
        final List<String> serverOptions = new ArrayList<String>();

        private Builder() {
        }

        Builder addPeerHas(ObjectId objectId) {
            this.peerHas.add(objectId);
            return this;
        }

        Builder addWantedRef(String refName, ObjectId oid) {
            this.wantedRefs.put(refName, oid);
            return this;
        }

        Builder addClientCapability(String clientCapability) {
            this.clientCapabilities.add(clientCapability);
            return this;
        }

        Builder addWantId(ObjectId wantId) {
            this.wantIds.add(wantId);
            return this;
        }

        Builder addClientShallowCommit(ObjectId shallowOid) {
            this.clientShallowCommits.add(shallowOid);
            return this;
        }

        Builder setDepth(int d) {
            this.depth = d;
            return this;
        }

        int getDepth() {
            return this.depth;
        }

        boolean hasDeepenNotRefs() {
            return !this.deepenNotRefs.isEmpty();
        }

        Builder addDeepenNotRef(String deepenNotRef) {
            this.deepenNotRefs.add(deepenNotRef);
            return this;
        }

        Builder setDeepenSince(int value) {
            this.deepenSince = value;
            return this;
        }

        int getDeepenSince() {
            return this.deepenSince;
        }

        Builder setFilterBlobLimit(long filterBlobLim) {
            this.filterBlobLimit = filterBlobLim;
            return this;
        }

        Builder setDoneReceived() {
            this.doneReceived = true;
            return this;
        }

        Builder setAgent(@Nullable String agentValue) {
            this.agent = agentValue;
            return this;
        }

        Builder addServerOption(@NonNull String value) {
            this.serverOptions.add(value);
            return this;
        }

        FetchV2Request build() {
            return new FetchV2Request(this.peerHas, this.wantedRefs, this.wantIds, this.clientShallowCommits, this.deepenSince, this.deepenNotRefs, this.depth, this.filterBlobLimit, this.doneReceived, this.clientCapabilities, this.agent, Collections.unmodifiableList(this.serverOptions));
        }
    }
}

