/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import org.apache.activemq.apollo.broker.Broker$;
import org.apache.activemq.apollo.broker.BrokerConnection;
import org.apache.activemq.apollo.broker.Delivery;
import org.apache.activemq.apollo.broker.DeliveryConsumer;
import org.apache.activemq.apollo.broker.DeliveryProducer;
import org.apache.activemq.apollo.broker.DeliveryProducer$class;
import org.apache.activemq.apollo.broker.DeliverySession;
import org.apache.activemq.apollo.broker.Queue;
import org.apache.activemq.apollo.broker.Queue$;
import org.apache.activemq.apollo.broker.QueueEntry;
import org.apache.activemq.apollo.broker.Sink;
import org.apache.activemq.apollo.broker.Subscription$;
import org.apache.activemq.apollo.broker.store.StoreUOW;
import org.apache.activemq.apollo.util.Dispatched;
import org.apache.activemq.apollo.util.list.LinkedNode;
import org.apache.activemq.apollo.util.list.LinkedNodeList;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\tmw!B\u0001\u0003\u0011\u000bi\u0011\u0001D*vEN\u001c'/\u001b9uS>t'BA\u0002\u0005\u0003\u0019\u0011'o\\6fe*\u0011QAB\u0001\u0007CB|G\u000e\\8\u000b\u0005\u001dA\u0011\u0001C1di&4X-\\9\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0002\u0012\u00051\u0019VOY:de&\u0004H/[8o'\u0011y!C\u0007\u0011\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u00027b]\u001eT\u0011aF\u0001\u0005U\u00064\u0018-\u0003\u0002\u001a)\t1qJ\u00196fGR\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003?q\u00111\u0001T8h!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000b\u001dzA\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u0016\u0010\u0007\u0004%)aK\u0001\u0013I\u0015t\u0017M\u00197f?\u0006\u001c8/\u001a:uS>t7/F\u0001-!\t\tS&\u0003\u0002/E\t9!i\\8mK\u0006t\u0007B\u0002\u0019\u0010A\u00035A&A\n%K:\f'\r\\3`CN\u001cXM\u001d;j_:\u001c\bE\u0002\u0003\u0011\u0005\u0001\u00114#B\u0019\u0013gY\u0002\u0003C\u0001\b5\u0013\t)$A\u0001\tEK2Lg/\u001a:z!J|G-^2feB\u00111dN\u0005\u0003qq\u0011!\u0002R5ta\u0006$8\r[3e\u0011!Q\u0014G!b\u0001\n\u0003Y\u0014!B9vKV,W#\u0001\u001f\u0011\u00059i\u0014B\u0001 \u0003\u0005\u0015\tV/Z;f\u0011!\u0001\u0015G!A!\u0002\u0013a\u0014AB9vKV,\u0007\u0005\u0003\u0005Cc\t\u0015\r\u0011\"\u0001D\u0003!\u0019wN\\:v[\u0016\u0014X#\u0001#\u0011\u00059)\u0015B\u0001$\u0003\u0005A!U\r\\5wKJL8i\u001c8tk6,'\u000f\u0003\u0005Ic\t\u0005\t\u0015!\u0003E\u0003%\u0019wN\\:v[\u0016\u0014\b\u0005C\u0003(c\u0011\u0005!\nF\u0002L\u00196\u0003\"AD\u0019\t\u000biJ\u0005\u0019\u0001\u001f\t\u000b\tK\u0005\u0019\u0001#\t\u000b=\u000bD\u0011\u0001)\u0002\u001d\u0011L7\u000f]1uG\"|\u0016/^3vKV\t\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006a\u0001.Y<uI&\u001c\b/\u0019;dQ*\u0011aKC\u0001\u000bMV\u001cXm]8ve\u000e,\u0017B\u0001-T\u00055!\u0015n\u001d9bi\u000eD\u0017+^3vK\"9!,\rb\u0001\n\u0003Y\u0016AA5e+\u0005a\u0006CA\u0011^\u0013\tq&EA\u0002J]RDa\u0001Y\u0019!\u0002\u0013a\u0016aA5eA!9!-\ra\u0001\n\u0003\u0019\u0017\u0001C1dcVL'/\u001a3\u0016\u0003\u0011\u00042!\u001a5k\u001b\u00051'BA4\u001d\u0003\u0011a\u0017n\u001d;\n\u0005%4'A\u0004'j].,GMT8eK2K7\u000f\u001e\t\u0003W2l\u0011!\r\u0004\u0005[F\u0002aN\u0001\nBGF,\u0018N]3e#V,W/Z#oiJL8c\u00017pAA\u0019Q\r\u001d6\n\u0005E4'A\u0003'j].,GMT8eK\"A1\u000f\u001cBC\u0002\u0013\u0005A/A\u0003f]R\u0014\u00180F\u0001v!\tqa/\u0003\u0002x\u0005\tQ\u0011+^3vK\u0016sGO]=\t\u0011ed'\u0011!Q\u0001\nU\fa!\u001a8uef\u0004\u0003\"B\u0014m\t\u0003YHC\u00016}\u0011\u0015\u0019(\u00101\u0001v\u0011\u0015qH\u000e\"\u0001\u0000\u0003\r\t7m\u001b\u000b\u0005\u0003\u0003\t9\u0001E\u0002\"\u0003\u0007I1!!\u0002#\u0005\u0011)f.\u001b;\t\u000f\u0005%Q\u00101\u0001\u0002\f\u0005\u0019Qo\\<\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u0003\u0003\u0015\u0019Ho\u001c:f\u0013\u0011\t)\"a\u0004\u0003\u0011M#xN]3V\u001f^Cq!!\u0007m\t\u0003\tY\"\u0001\bj]\u000e\u0014X-\\3oi~s\u0017mY6\u0016\u0005\u0005\u0005\u0001bBA\u0010Y\u0012\u0005\u00111D\u0001\u0005]\u0006\u001c7\u000eC\u0005\u0002$E\u0002\r\u0011\"\u0001\u0002&\u0005a\u0011mY9vSJ,Gm\u0018\u0013fcR!\u0011\u0011AA\u0014\u0011%\tI#!\t\u0002\u0002\u0003\u0007A-A\u0002yIEBq!!\f2A\u0003&A-A\u0005bGF,\u0018N]3eA!I\u0011\u0011G\u0019A\u0002\u0013\u0005\u00111G\u0001\bg\u0016\u001c8/[8o+\t\t)\u0004E\u0002\u000f\u0003oI1!!\u000f\u0003\u0005=!U\r\\5wKJL8+Z:tS>t\u0007\"CA\u001fc\u0001\u0007I\u0011AA \u0003-\u0019Xm]:j_:|F%Z9\u0015\t\u0005\u0005\u0011\u0011\t\u0005\u000b\u0003S\tY$!AA\u0002\u0005U\u0002\u0002CA#c\u0001\u0006K!!\u000e\u0002\u0011M,7o]5p]\u0002B\u0001\"!\u00132\u0001\u0004%\t\u0001^\u0001\u0004a>\u001c\b\"CA'c\u0001\u0007I\u0011AA(\u0003\u001d\u0001xn]0%KF$B!!\u0001\u0002R!I\u0011\u0011FA&\u0003\u0003\u0005\r!\u001e\u0005\b\u0003+\n\u0004\u0015)\u0003v\u0003\u0011\u0001xn\u001d\u0011\t\u0013\u0005e\u0013\u00071A\u0005\u0002\u0005m\u0013!D1dcVL'/\u001a3`g&TX-\u0006\u0002\u0002^A\u0019\u0011%a\u0018\n\u0007\u0005\u0005$E\u0001\u0003M_:<\u0007\"CA3c\u0001\u0007I\u0011AA4\u0003E\t7-];je\u0016$wl]5{K~#S-\u001d\u000b\u0005\u0003\u0003\tI\u0007\u0003\u0006\u0002*\u0005\r\u0014\u0011!a\u0001\u0003;B\u0001\"!\u001c2A\u0003&\u0011QL\u0001\u000fC\u000e\fX/\u001b:fI~\u001b\u0018N_3!\u0011\u0019\t\t(\rC\u00017\u0006q\u0011mY9vSJ,GmX2pk:$\b\"CA;c\u0001\u0007I\u0011AA.\u0003e)g.];fk\u0016|6/\u001b>f?B,'oX5oi\u0016\u0014h/\u00197\t\u0013\u0005e\u0014\u00071A\u0005\u0002\u0005m\u0014!H3ocV,W/Z0tSj,w\f]3s?&tG/\u001a:wC2|F%Z9\u0015\t\u0005\u0005\u0011Q\u0010\u0005\u000b\u0003S\t9(!AA\u0002\u0005u\u0003\u0002CAAc\u0001\u0006K!!\u0018\u00025\u0015t\u0017/^3vK~\u001b\u0018N_3`a\u0016\u0014x,\u001b8uKJ4\u0018\r\u001c\u0011\t\u0013\u0005\u0015\u0015\u00071A\u0005\u0002\u0005m\u0013!H3ocV,W/Z0tSj,w,\u0019;`Y\u0006\u001cHoX5oi\u0016\u0014h/\u00197\t\u0013\u0005%\u0015\u00071A\u0005\u0002\u0005-\u0015!I3ocV,W/Z0tSj,w,\u0019;`Y\u0006\u001cHoX5oi\u0016\u0014h/\u00197`I\u0015\fH\u0003BA\u0001\u0003\u001bC!\"!\u000b\u0002\b\u0006\u0005\t\u0019AA/\u0011!\t\t*\rQ!\n\u0005u\u0013AH3ocV,W/Z0tSj,w,\u0019;`Y\u0006\u001cHoX5oi\u0016\u0014h/\u00197!\u0011%\t)*\ra\u0001\n\u0003\tY&A\td_:\u001cX/\\3s?N$\u0018\r\u001c7`[ND\u0011\"!'2\u0001\u0004%\t!a'\u0002+\r|gn];nKJ|6\u000f^1mY~k7o\u0018\u0013fcR!\u0011\u0011AAO\u0011)\tI#a&\u0002\u0002\u0003\u0007\u0011Q\f\u0005\t\u0003C\u000b\u0004\u0015)\u0003\u0002^\u0005\u00112m\u001c8tk6,'oX:uC2dw,\\:!\u0011%\t)+\ra\u0001\n\u0003\tY&A\u0007m_\u0006$wl\u001d;bY2|Vn\u001d\u0005\n\u0003S\u000b\u0004\u0019!C\u0001\u0003W\u000b\u0011\u0003\\8bI~\u001bH/\u00197m?6\u001cx\fJ3r)\u0011\t\t!!,\t\u0015\u0005%\u0012qUA\u0001\u0002\u0004\ti\u0006\u0003\u0005\u00022F\u0002\u000b\u0015BA/\u00039aw.\u00193`gR\fG\u000e\\0ng\u0002B\u0011\"!.2\u0001\u0004%\t!a\u0017\u0002)\r|gn];nKJ|6\u000f^1mY~\u001bH/\u0019:u\u0011%\tI,\ra\u0001\n\u0003\tY,\u0001\rd_:\u001cX/\\3s?N$\u0018\r\u001c7`gR\f'\u000f^0%KF$B!!\u0001\u0002>\"Q\u0011\u0011FA\\\u0003\u0003\u0005\r!!\u0018\t\u0011\u0005\u0005\u0017\u0007)Q\u0005\u0003;\nQcY8ogVlWM]0ti\u0006dGnX:uCJ$\b\u0005C\u0005\u0002FF\u0002\r\u0011\"\u0001\u0002\\\u0005\u0001Bn\\1e?N$\u0018\r\u001c7`gR\f'\u000f\u001e\u0005\n\u0003\u0013\f\u0004\u0019!C\u0001\u0003\u0017\fA\u0003\\8bI~\u001bH/\u00197m?N$\u0018M\u001d;`I\u0015\fH\u0003BA\u0001\u0003\u001bD!\"!\u000b\u0002H\u0006\u0005\t\u0019AA/\u0011!\t\t.\rQ!\n\u0005u\u0013!\u00057pC\u0012|6\u000f^1mY~\u001bH/\u0019:uA!I\u0011Q[\u0019A\u0002\u0013\u0005\u00111L\u0001\u000bgR\f'\u000f^3e?\u0006$\b\"CAmc\u0001\u0007I\u0011AAn\u00039\u0019H/\u0019:uK\u0012|\u0016\r^0%KF$B!!\u0001\u0002^\"Q\u0011\u0011FAl\u0003\u0003\u0005\r!!\u0018\t\u0011\u0005\u0005\u0018\u0007)Q\u0005\u0003;\n1b\u001d;beR,GmX1uA!I\u0011Q]\u0019A\u0002\u0013\u0005\u00111L\u0001\u0010i>$\u0018\r\\0bG.|6m\\;oi\"I\u0011\u0011^\u0019A\u0002\u0013\u0005\u00111^\u0001\u0014i>$\u0018\r\\0bG.|6m\\;oi~#S-\u001d\u000b\u0005\u0003\u0003\ti\u000f\u0003\u0006\u0002*\u0005\u001d\u0018\u0011!a\u0001\u0003;B\u0001\"!=2A\u0003&\u0011QL\u0001\u0011i>$\u0018\r\\0bG.|6m\\;oi\u0002B\u0011\"!>2\u0001\u0004%\t!a\u0017\u0002\u001dQ|G/\u00197`C\u000e\\wl]5{K\"I\u0011\u0011`\u0019A\u0002\u0013\u0005\u00111`\u0001\u0013i>$\u0018\r\\0bG.|6/\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005u\bBCA\u0015\u0003o\f\t\u00111\u0001\u0002^!A!\u0011A\u0019!B\u0013\ti&A\bu_R\fGnX1dW~\u001b\u0018N_3!\u0011%\u0011)!\ra\u0001\n\u0003\tY&\u0001\tu_R\fGn\u00188bG.|6m\\;oi\"I!\u0011B\u0019A\u0002\u0013\u0005!1B\u0001\u0015i>$\u0018\r\\0oC\u000e\\wlY8v]R|F%Z9\u0015\t\u0005\u0005!Q\u0002\u0005\u000b\u0003S\u00119!!AA\u0002\u0005u\u0003\u0002\u0003B\tc\u0001\u0006K!!\u0018\u0002#Q|G/\u00197`]\u0006\u001c7nX2pk:$\b\u0005C\u0005\u0003\u0016E\u0002\r\u0011\"\u0001\u0002\\\u0005Q\u0011\u000e\u001a7f?N$\u0018M\u001d;\t\u0013\te\u0011\u00071A\u0005\u0002\tm\u0011AD5eY\u0016|6\u000f^1si~#S-\u001d\u000b\u0005\u0003\u0003\u0011i\u0002\u0003\u0006\u0002*\t]\u0011\u0011!a\u0001\u0003;B\u0001B!\t2A\u0003&\u0011QL\u0001\fS\u0012dWmX:uCJ$\b\u0005C\u0005\u0003&E\u0002\r\u0011\"\u0001\u0002\\\u0005Q\u0011\u000e\u001a7f?R|G/\u00197\t\u0013\t%\u0012\u00071A\u0005\u0002\t-\u0012AD5eY\u0016|Fo\u001c;bY~#S-\u001d\u000b\u0005\u0003\u0003\u0011i\u0003\u0003\u0006\u0002*\t\u001d\u0012\u0011!a\u0001\u0003;B\u0001B!\r2A\u0003&\u0011QL\u0001\fS\u0012dWm\u0018;pi\u0006d\u0007\u0005C\u0004\u00036E\"\tAa\u000e\u0002\u0013\u0005\u001c7n\u0018:bi\u0016\u001cXC\u0001B\u001d!\u0015\t#1\bB \u0013\r\u0011iD\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\u0005\u0012\tE!\u0012\u0003F%\u0019!1\t\u0012\u0003\rQ+\b\u000f\\33!\r\t#qI\u0005\u0004\u0005\u0013\u0012#A\u0002#pk\ndW\rC\u0004\u0003NE\"\tEa\u0014\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0015\u0011\u0007M\u0011\u0019&C\u0002\u0003VQ\u0011aa\u0015;sS:<\u0007B\u0002B-c\u0011\u00051&A\u0004ce><8/\u001a:\t\r\tu\u0013\u0007\"\u0001,\u0003%)\u0007p\u00197vg&4X\r\u0003\u0005\u0003bE\u0012\r\u0011\"\u0001\\\u0003=\u0019wN\\:v[\u0016\u0014xLY;gM\u0016\u0014\bb\u0002B3c\u0001\u0006I\u0001X\u0001\u0011G>t7/^7fe~\u0013WO\u001a4fe\u0002BqA!\u001b2\t\u0003\u0011Y'\u0001\u0003pa\u0016tGCAA\u0001\u0011%\u0011y'\ra\u0001\n\u0003\u0011\t(\u0001\u000bqK:$\u0017N\\4`G2|7/Z0bGRLwN\\\u000b\u0003\u0005g\u0002R!\tB;\u0003\u0003I1Aa\u001e#\u0005%1UO\\2uS>t\u0007\u0007C\u0005\u0003|E\u0002\r\u0011\"\u0001\u0003~\u0005A\u0002/\u001a8eS:<wl\u00197pg\u0016|\u0016m\u0019;j_:|F%Z9\u0015\t\u0005\u0005!q\u0010\u0005\u000b\u0003S\u0011I(!AA\u0002\tM\u0004\u0002\u0003BBc\u0001\u0006KAa\u001d\u0002+A,g\u000eZ5oO~\u001bGn\\:f?\u0006\u001cG/[8oA!9!qQ\u0019\u0005\u0002\u0005m\u0011AE2iK\u000e\\wLZ5oSNDwl\u00197pg\u0016DqAa#2\t\u0003\u0011Y'A\u0003dY>\u001cX\rC\u0004\u0003\u0010F\"\tA!%\u0002\u000f\u0005$g/\u00198dKR!\u0011\u0011\u0001BJ\u0011\u001d\u0011)J!$A\u0002U\fQA^1mk\u0016DqA!'2\t\u0003\u0011Y*\u0001\u0004sK^Lg\u000e\u001a\u000b\u0005\u0003\u0003\u0011i\nC\u0004\u0003\u0016\n]\u0005\u0019A;\t\r\t\u0005\u0016\u0007\"\u0001,\u0003-!\u0018-\u001b7`a\u0006\u00148.\u001a3\t\u000f\t\u0015\u0016\u0007\"\u0001\u0003(\u00069Q.\u0019;dQ\u0016\u001cHc\u0001\u0017\u0003*\"91Oa)A\u0002\t-\u0006c\u0001\b\u0003.&\u0019!q\u0016\u0002\u0003\u0011\u0011+G.\u001b<fefDaAa-2\t\u0003Y\u0013\u0001\u00024vY2DqAa.2\t\u0003\u0011I,A\u0003pM\u001a,'\u000fF\u0002-\u0005wC\u0001B!0\u00036\u0002\u0007!1V\u0001\tI\u0016d\u0017N^3ss\"9!\u0011Y\u0019\u0005\u0002\t\r\u0017aB1dcVL'/\u001a\u000b\u0004U\n\u0015\u0007BB:\u0003@\u0002\u0007Q\u000fC\u0004\u0003JF\"\t!a\u0007\u0002!\rDWmY6`Y>\fGmX:uC2d\u0007b\u0002Bgc\u0011\u0005\u00111D\u0001\u0015G\",7m[0d_:\u001cX/\\3s?N$\u0018\r\u001c7\t\u000f\tE\u0017\u0007\"\u0001\u0003T\u0006!\u0012\r\u001a6vgR|\u0006O]3gKR\u001c\u0007nX:ju\u0016,\"A!6\u0011\u000f\u0005\u0012\t%!\u0018\u0002^!9!\u0011\\\u0019\u0005\u0002\u0005m\u0011a\u0004:fM&dGn\u00189sK\u001a,Go\u00195")
public class Subscription
implements DeliveryProducer,
Dispatched,
ScalaObject {
    private final Queue queue;
    private final DeliveryConsumer consumer;
    private final int id;
    private LinkedNodeList<AcquiredQueueEntry> acquired;
    private DeliverySession session;
    private QueueEntry pos;
    private long acquired_size;
    private long enqueue_size_per_interval;
    private long enqueue_size_at_last_interval;
    private long consumer_stall_ms;
    private long load_stall_ms;
    private long consumer_stall_start;
    private long load_stall_start;
    private long started_at;
    private long total_ack_count;
    private long total_ack_size;
    private long total_nack_count;
    private long idle_start;
    private long idle_total;
    private final int consumer_buffer;
    private Function0<BoxedUnit> pending_close_action;

    public static final void trace(Throwable throwable) {
        Subscription$.MODULE$.trace(throwable);
    }

    public static final void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.trace(throwable, function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.trace(function0, seq);
    }

    public static final void debug(Throwable throwable) {
        Subscription$.MODULE$.debug(throwable);
    }

    public static final void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.debug(throwable, function0, seq);
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.debug(function0, seq);
    }

    public static final void info(Throwable throwable) {
        Subscription$.MODULE$.info(throwable);
    }

    public static final void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.info(throwable, function0, seq);
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.info(function0, seq);
    }

    public static final void warn(Throwable throwable) {
        Subscription$.MODULE$.warn(throwable);
    }

    public static final void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.warn(throwable, function0, seq);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.warn(function0, seq);
    }

    public static final void error(Throwable throwable) {
        Subscription$.MODULE$.error(throwable);
    }

    public static final void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.error(throwable, function0, seq);
    }

    public static final void error(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.error(function0, seq);
    }

    public static final void org$apache$activemq$apollo$util$Log$_setter_$log_$eq(Logger logger) {
        Subscription$.MODULE$.org$apache$activemq$apollo$util$Log$_setter_$log_$eq(logger);
    }

    public static final Logger log() {
        return Subscription$.MODULE$.log();
    }

    public static final boolean $enable_assertions() {
        return Subscription$.MODULE$.$enable_assertions();
    }

    public void assert_executing() {
        Dispatched.class.assert_executing((Dispatched)this);
    }

    @Override
    public Option<BrokerConnection> connection() {
        return DeliveryProducer$class.connection(this);
    }

    @Override
    public int send_buffer_size() {
        return DeliveryProducer$class.send_buffer_size(this);
    }

    @Override
    public void collocate(DispatchQueue value) {
        DeliveryProducer$class.collocate(this, value);
    }

    public Queue queue() {
        return this.queue;
    }

    public DeliveryConsumer consumer() {
        return this.consumer;
    }

    @Override
    public DispatchQueue dispatch_queue() {
        return this.queue().dispatch_queue();
    }

    public int id() {
        return this.id;
    }

    public LinkedNodeList<AcquiredQueueEntry> acquired() {
        return this.acquired;
    }

    public void acquired_$eq(LinkedNodeList<AcquiredQueueEntry> linkedNodeList) {
        this.acquired = linkedNodeList;
    }

    public DeliverySession session() {
        return this.session;
    }

    public void session_$eq(DeliverySession deliverySession) {
        this.session = deliverySession;
    }

    public QueueEntry pos() {
        return this.pos;
    }

    public void pos_$eq(QueueEntry queueEntry) {
        this.pos = queueEntry;
    }

    public long acquired_size() {
        return this.acquired_size;
    }

    public void acquired_size_$eq(long l) {
        this.acquired_size = l;
    }

    public int acquired_count() {
        return this.acquired().size();
    }

    public long enqueue_size_per_interval() {
        return this.enqueue_size_per_interval;
    }

    public void enqueue_size_per_interval_$eq(long l) {
        this.enqueue_size_per_interval = l;
    }

    public long enqueue_size_at_last_interval() {
        return this.enqueue_size_at_last_interval;
    }

    public void enqueue_size_at_last_interval_$eq(long l) {
        this.enqueue_size_at_last_interval = l;
    }

    public long consumer_stall_ms() {
        return this.consumer_stall_ms;
    }

    public void consumer_stall_ms_$eq(long l) {
        this.consumer_stall_ms = l;
    }

    public long load_stall_ms() {
        return this.load_stall_ms;
    }

    public void load_stall_ms_$eq(long l) {
        this.load_stall_ms = l;
    }

    public long consumer_stall_start() {
        return this.consumer_stall_start;
    }

    public void consumer_stall_start_$eq(long l) {
        this.consumer_stall_start = l;
    }

    public long load_stall_start() {
        return this.load_stall_start;
    }

    public void load_stall_start_$eq(long l) {
        this.load_stall_start = l;
    }

    public long started_at() {
        return this.started_at;
    }

    public void started_at_$eq(long l) {
        this.started_at = l;
    }

    public long total_ack_count() {
        return this.total_ack_count;
    }

    public void total_ack_count_$eq(long l) {
        this.total_ack_count = l;
    }

    public long total_ack_size() {
        return this.total_ack_size;
    }

    public void total_ack_size_$eq(long l) {
        this.total_ack_size = l;
    }

    public long total_nack_count() {
        return this.total_nack_count;
    }

    public void total_nack_count_$eq(long l) {
        this.total_nack_count = l;
    }

    public long idle_start() {
        return this.idle_start;
    }

    public void idle_start_$eq(long l) {
        this.idle_start = l;
    }

    public long idle_total() {
        return this.idle_total;
    }

    public void idle_total_$eq(long l) {
        this.idle_total = l;
    }

    public Option<Tuple2<Object, Object>> ack_rates() {
        None$ none$;
        long duration = (Broker$.MODULE$.now() - this.started_at()) * 1000000L;
        duration -= this.idle_total();
        if (this.idle_start() != 0L) {
            duration -= System.nanoTime() - this.idle_start();
        }
        if (duration != 0L && this.total_ack_count() > 0L) {
            double ack_rate = 1.0E9 * (double)this.total_ack_count() / (double)duration;
            double ack_size_rate = 1.0E9 * (double)this.total_ack_size() / (double)duration;
            none$ = new Some((Object)new Tuple2.mcDD.sp(ack_rate, ack_size_rate));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String toString() {
        return new StringBuilder().append((Object)"{ id: ").append((Object)BoxesRunTime.boxToInteger((int)this.id())).append((Object)", acquired_size: ").append((Object)BoxesRunTime.boxToLong((long)this.acquired_size())).append((Object)", pos: ").append(this.seq$1(this.pos())).append((Object)"}").toString();
    }

    public boolean browser() {
        return this.consumer().browser();
    }

    public boolean exclusive() {
        return this.consumer().exclusive();
    }

    public int consumer_buffer() {
        return this.consumer_buffer;
    }

    public void open() {
        this.consumer().retain();
        if (this.consumer().start_from_tail()) {
            this.pos_$eq(this.queue().tail_entry());
        } else {
            this.pos_$eq(this.queue().head_entry());
        }
        if (Subscription$.MODULE$.$enable_assertions()) {
            Predef$.MODULE$.assert(this.pos() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID;
                private final Subscription $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("pos.$bang$eq(null) with pos=>%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.pos()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.consumer().set_starting_seq(this.pos().seq());
        this.session_$eq(this.consumer().connect(this));
        ((Sink)((Object)this.session())).refiller_$eq(package$.MODULE$.DispatchQueueWrapper(this.dispatch_queue()).runnable((Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final Subscription $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.session() != null) {
                    this.$outer.check_consumer_stall();
                }
                if (this.$outer.pos() != null) {
                    this.$outer.pos().task().run();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.pos().$colon$colon$eq(this);
        this.queue().all_subscriptions_$eq((Map<DeliveryConsumer, Subscription>)this.queue().all_subscriptions().$plus(Predef$.MODULE$.any2ArrowAssoc((Object)this.consumer()).$minus$greater((Object)this)));
        this.queue().consumer_counter_$eq(this.queue().consumer_counter() + 1L);
        this.queue().change_consumer_capacity(this.consumer_buffer());
        if (this.exclusive()) {
            this.queue().exclusive_subscriptions().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Subscription[]{this}));
        }
        if (this.queue().service_state().is_started()) {
            this.refill_prefetch();
            package$.MODULE$.DispatchQueueWrapper(this.queue().dispatch_queue()).$less$less(this.pos().task());
        }
        this.queue().check_idle();
    }

    public Function0<BoxedUnit> pending_close_action() {
        return this.pending_close_action;
    }

    public void pending_close_action_$eq(Function0<BoxedUnit> function0) {
        this.pending_close_action = function0;
    }

    public void check_finish_close() {
        if (this.pending_close_action() != null && this.acquired().isEmpty()) {
            this.pending_close_action().apply$mcV$sp();
            this.pending_close_action_$eq(null);
        }
    }

    public void close() {
        if (this.pos() != null) {
            this.pos().$minus$eq(this);
            this.pos_$eq(null);
            this.queue().exclusive_subscriptions_$eq((ListBuffer<Subscription>)((ListBuffer)this.queue().exclusive_subscriptions().filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final Subscription $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Subscription subscription) {
                    Subscription subscription2 = subscription;
                    Subscription subscription3 = this.$outer;
                    return !(subscription2 != null ? !subscription2.equals(subscription3) : subscription3 != null);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            })));
            this.queue().all_subscriptions_$eq((Map<DeliveryConsumer, Subscription>)((Map)this.queue().all_subscriptions().$minus((Object)this.consumer())));
            ((Sink)((Object)this.session())).refiller_$eq(package$.MODULE$.NOOP());
            this.session().close();
            this.session_$eq(null);
            this.pending_close_action_$eq((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final Subscription $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.queue().change_consumer_capacity(-this.$outer.consumer_buffer());
                    if (this.$outer.exclusive()) {
                        this.$outer.queue().all_subscriptions().values().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anonfun$close$2 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(Subscription subscription) {
                                subscription.rewind(this.$outer.org$apache$activemq$apollo$broker$Subscription$$anonfun$$$outer().queue().head_entry());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    this.$outer.queue().check_idle();
                    this.$outer.queue().trigger_swap();
                }

                public Subscription org$apache$activemq$apollo$broker$Subscription$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.consumer().release();
            this.check_finish_close();
        }
    }

    public void advance(QueueEntry value$2) {
        if (Subscription$.MODULE$.$enable_assertions()) {
            Predef$.MODULE$.assert(value$2 != null, (Function0)new Serializable(this, value$2){
                public static final long serialVersionUID;
                private final QueueEntry value$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("value.$bang$eq(null) with value=>%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2}));
                }
                {
                    this.value$2 = queueEntry;
                }
            });
        }
        this.pos_$eq(value$2);
        this.check_load_stall();
        if (this.tail_parked() && this.consumer().close_on_drain()) {
            this.close();
        }
    }

    public void rewind(QueueEntry value$1) {
        if (Subscription$.MODULE$.$enable_assertions()) {
            Predef$.MODULE$.assert(value$1 != null, (Function0)new Serializable(this, value$1){
                public static final long serialVersionUID;
                private final QueueEntry value$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("value.$bang$eq(null) with value=>%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1}));
                }
                {
                    this.value$1 = queueEntry;
                }
            });
        }
        this.pos().$minus$eq(this);
        value$1.$colon$colon$eq(this);
        this.pos_$eq(value$1);
        this.check_load_stall();
        package$.MODULE$.DispatchQueueWrapper(this.queue().dispatch_queue()).$less$less(value$1.task());
    }

    public boolean tail_parked() {
        return this.pos() == this.queue().tail_entry();
    }

    public boolean matches(Delivery entry) {
        return this.consumer().matches(entry);
    }

    public boolean full() {
        return ((Sink)((Object)this.session())).full();
    }

    public boolean offer(Delivery delivery) {
        boolean exceptionResult2 = false;
        try {
            if (Subscription$.MODULE$.$enable_assertions()) {
                Predef$.MODULE$.assert(delivery.seq() > 0L, (Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "delivery.seq.$greater(0)";
                    }
                });
            }
            exceptionResult2 = ((Sink)((Object)this.session())).offer(delivery);
            return exceptionResult2;
        }
        finally {
            this.check_consumer_stall();
        }
    }

    public AcquiredQueueEntry acquire(QueueEntry entry) {
        return new AcquiredQueueEntry(this, entry);
    }

    public void check_load_stall() {
        if (this.pos().is_swapped_or_swapped_range()) {
            if (this.load_stall_start() == 0L) {
                this.load_stall_start_$eq(this.queue().virtual_host().broker().now());
            }
        } else if (this.load_stall_start() != 0L) {
            this.load_stall_ms_$eq(this.load_stall_ms() + (this.queue().virtual_host().broker().now() - this.load_stall_start()));
            this.load_stall_start_$eq(0L);
        }
    }

    public void check_consumer_stall() {
        if (this.full()) {
            if (this.consumer_stall_start() == 0L) {
                this.consumer_stall_start_$eq(this.queue().virtual_host().broker().now());
            }
        } else if (this.consumer_stall_start() != 0L) {
            this.consumer_stall_ms_$eq(this.consumer_stall_ms() + (this.queue().virtual_host().broker().now() - this.consumer_stall_start()));
            this.consumer_stall_start_$eq(0L);
        }
    }

    public Tuple2<Object, Object> adjust_prefetch_size() {
        this.enqueue_size_per_interval_$eq(this.session().enqueue_size_counter() - this.enqueue_size_at_last_interval());
        this.enqueue_size_at_last_interval_$eq(this.session().enqueue_size_counter());
        if (this.consumer_stall_start() != 0L) {
            long now = this.queue().virtual_host().broker().now();
            this.consumer_stall_ms_$eq(this.consumer_stall_ms() + (now - this.consumer_stall_start()));
            this.consumer_stall_start_$eq(now);
        }
        if (this.load_stall_start() != 0L) {
            long now = this.queue().virtual_host().broker().now();
            this.load_stall_ms_$eq(this.load_stall_ms() + (now - this.load_stall_start()));
            this.load_stall_start_$eq(now);
        }
        Tuple2.mcJJ.sp rc = new Tuple2.mcJJ.sp(this.consumer_stall_ms(), this.load_stall_ms());
        this.consumer_stall_ms_$eq(0L);
        this.load_stall_ms_$eq(0L);
        return rc;
    }

    public void refill_prefetch() {
        QueueEntry cursor = this.pos().is_tail() ? null : (this.pos().is_head() ? (QueueEntry)this.pos().getNext() : this.pos());
        int remaining = this.consumer_buffer();
        while (remaining > 0 && cursor != null) {
            QueueEntry next = (QueueEntry)cursor.getNext();
            if (!(cursor.prefetched() || !this.browser() && cursor.is_acquired())) {
                remaining -= cursor.size();
                cursor.prefetched_$eq(true);
                cursor.load(this.queue().consumer_swapped_in());
            }
            cursor = next;
        }
        if (!this.queue().consumers_keeping_up() && (cursor == null || cursor.as_loaded() != null && cursor.as_loaded().space() == this.queue().producer_swapped_in())) {
            this.queue().consumers_keeping_up_$eq(true);
        }
    }

    private final Object seq$1(QueueEntry entry) {
        return entry == null ? null : BoxesRunTime.boxToLong((long)entry.seq());
    }

    public Subscription(Queue queue, DeliveryConsumer consumer) {
        this.queue = queue;
        this.consumer = consumer;
        DeliveryProducer$class.$init$(this);
        Dispatched.class.$init$((Dispatched)this);
        this.id = Queue$.MODULE$.subcsription_counter().incrementAndGet();
        this.acquired = new LinkedNodeList();
        this.session = null;
        this.pos = null;
        this.acquired_size = 0L;
        this.enqueue_size_per_interval = 0L;
        this.enqueue_size_at_last_interval = 0L;
        this.consumer_stall_ms = 0L;
        this.load_stall_ms = 0L;
        this.consumer_stall_start = 0L;
        this.load_stall_start = 0L;
        this.started_at = Broker$.MODULE$.now();
        this.total_ack_count = 0L;
        this.total_ack_size = 0L;
        this.total_nack_count = 0L;
        this.idle_start = System.nanoTime();
        this.idle_total = 0L;
        this.consumer_buffer = consumer.receive_buffer_size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AcquiredQueueEntry
    extends LinkedNode<AcquiredQueueEntry>
    implements ScalaObject {
        private final QueueEntry entry;
        public final Subscription $outer;

        public QueueEntry entry() {
            return this.entry;
        }

        public void ack(StoreUOW uow) {
            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().assert_executing();
            if (this.isLinked()) {
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_ack_count_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_ack_count() + 1L);
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_ack_size_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_ack_size() + (long)this.entry().size());
                if (this.entry().messageKey() != -1L) {
                    StoreUOW storeBatch = uow == null ? this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().virtual_host().store().create_uow() : uow;
                    storeBatch.dequeue(this.entry().toQueueEntryRecord());
                    if (uow == null) {
                        storeBatch.release();
                    }
                }
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().dequeue_item_counter_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().dequeue_item_counter() + 1L);
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().dequeue_size_counter_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().dequeue_size_counter() + (long)this.entry().size());
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().dequeue_ts_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().now());
                this.unlink();
                if (this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired().isEmpty()) {
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().idle_start_$eq(System.nanoTime());
                }
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired_size_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired_size() - (long)this.entry().size());
                QueueEntry next = this.entry().nextOrTail();
                this.entry().remove();
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().trigger_swap();
                next.task().run();
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().check_finish_close();
                return;
            }
            Subscription$.MODULE$.debug((Function0)new Serializable(this){
                public static final long serialVersionUID;
                private final AcquiredQueueEntry $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Unexpected ack: message seq allready acked: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.entry().seq())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }

        public void increment_nack() {
            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_nack_count_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_nack_count() + 1L);
        }

        public void nack() {
            block5: {
                QueueEntry.EntryState entryState;
                block8: {
                    block7: {
                        block6: {
                            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().assert_executing();
                            if (!this.isLinked()) break block5;
                            entryState = this.entry().state();
                            if (!(entryState instanceof QueueEntry.Loaded)) break block6;
                            ((QueueEntry.Loaded)entryState).acquirer_$eq(null);
                            break block7;
                        }
                        if (!(entryState instanceof QueueEntry.Swapped)) break block8;
                        ((QueueEntry.Swapped)entryState).acquirer_$eq(null);
                    }
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired_size_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired_size() - (long)this.entry().size());
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_item_counter_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_item_counter() + 1L);
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_size_counter_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_size_counter() + (long)this.entry().size());
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_ts_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().now());
                    if (!this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().exclusive()) {
                        QueueEntry.Loaded loaded$1 = this.entry().as_loaded();
                        this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().all_subscriptions().valuesIterator().foreach((Function1)new Serializable(this, loaded$1){
                            public static final long serialVersionUID;
                            private final AcquiredQueueEntry $outer;
                            private final QueueEntry.Loaded loaded$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(Subscription sub) {
                                boolean matches;
                                boolean bl = matches = this.loaded$1 == null ? true : sub.matches(this.loaded$1.delivery());
                                if (!sub.browser() && this.$outer.entry().seq() < sub.pos().seq() && matches) {
                                    sub.rewind(this.$outer.entry());
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.loaded$1 = loaded;
                            }
                        });
                    }
                    this.unlink();
                    if (this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired().isEmpty()) {
                        this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().idle_start_$eq(System.nanoTime());
                    }
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().check_finish_close();
                    return;
                }
                throw new MatchError((Object)entryState);
            }
            Subscription$.MODULE$.debug((Function0)new Serializable(this){
                public static final long serialVersionUID;
                private final AcquiredQueueEntry $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Unexpected nack: message seq allready acked: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.entry().seq())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }

        public Subscription org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer() {
            return this.$outer;
        }

        public AcquiredQueueEntry(Subscription $outer, QueueEntry entry) {
            this.entry = entry;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            if ($outer.acquired().isEmpty()) {
                $outer.idle_total_$eq(System.nanoTime() - $outer.idle_start());
                $outer.idle_start_$eq(0L);
            }
            $outer.acquired().addLast((LinkedNode)this);
            $outer.acquired_size_$eq($outer.acquired_size() + (long)entry.size());
        }
    }
}

