/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.carrotsearch.hppc.LongOpenHashSet;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.index.sasi.disk.AbstractTokenTreeBuilder;
import org.apache.cassandra.index.sasi.disk.TokenTreeBuilder;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.Pair;

public class DynamicTokenTreeBuilder
extends AbstractTokenTreeBuilder {
    private final SortedMap<Long, LongSet> tokens = new TreeMap<Long, LongSet>();

    public DynamicTokenTreeBuilder() {
    }

    public DynamicTokenTreeBuilder(TokenTreeBuilder data) {
        this.add(data);
    }

    public DynamicTokenTreeBuilder(SortedMap<Long, LongSet> data) {
        this.add(data);
    }

    @Override
    public void add(Long token, long keyPosition) {
        LongSet found = (LongSet)this.tokens.get(token);
        if (found == null) {
            found = new LongOpenHashSet(2);
            this.tokens.put(token, found);
        }
        found.add(keyPosition);
    }

    @Override
    public void add(Iterator<Pair<Long, LongSet>> data) {
        while (data.hasNext()) {
            Pair<Long, LongSet> entry = data.next();
            for (LongCursor l : (LongSet)entry.right) {
                this.add((Long)entry.left, l.value);
            }
        }
    }

    @Override
    public void add(SortedMap<Long, LongSet> data) {
        for (Map.Entry<Long, LongSet> newEntry : data.entrySet()) {
            LongSet found = (LongSet)this.tokens.get(newEntry.getKey());
            if (found == null) {
                found = new LongOpenHashSet(4);
                this.tokens.put(newEntry.getKey(), found);
            }
            for (LongCursor offset : newEntry.getValue()) {
                found.add(offset.value);
            }
        }
    }

    @Override
    public Iterator<Pair<Long, LongSet>> iterator() {
        final Iterator<Map.Entry<Long, LongSet>> iterator = this.tokens.entrySet().iterator();
        return new AbstractIterator<Pair<Long, LongSet>>(){

            @Override
            protected Pair<Long, LongSet> computeNext() {
                if (!iterator.hasNext()) {
                    return (Pair)this.endOfData();
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                return Pair.create(entry.getKey(), entry.getValue());
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.tokens.size() == 0;
    }

    @Override
    protected void constructTree() {
        this.tokenCount = this.tokens.size();
        this.treeMinToken = this.tokens.firstKey();
        this.treeMaxToken = this.tokens.lastKey();
        this.numBlocks = 1;
        if (this.tokenCount <= 248L) {
            this.rightmostLeaf = this.leftmostLeaf = new DynamicLeaf(this.tokens);
            this.root = this.leftmostLeaf;
        } else {
            this.root = new AbstractTokenTreeBuilder.InteriorNode();
            this.rightmostParent = (AbstractTokenTreeBuilder.InteriorNode)this.root;
            int i = 0;
            DynamicLeaf lastLeaf = null;
            Long firstToken = this.tokens.firstKey();
            Long finalToken = this.tokens.lastKey();
            for (Long token : this.tokens.keySet()) {
                DynamicLeaf leaf;
                if (i == 0 || i % 248 != 0 && (long)i != this.tokenCount - 1L) {
                    ++i;
                    continue;
                }
                Long lastToken = token;
                DynamicLeaf dynamicLeaf = leaf = (long)i != this.tokenCount - 1L || token.equals(finalToken) ? new DynamicLeaf(this.tokens.subMap(firstToken, lastToken)) : new DynamicLeaf(this.tokens.tailMap(firstToken));
                if (i == 248) {
                    this.leftmostLeaf = leaf;
                } else {
                    lastLeaf.next = leaf;
                }
                this.rightmostParent.add(leaf);
                lastLeaf = leaf;
                this.rightmostLeaf = leaf;
                firstToken = lastToken;
                ++i;
                ++this.numBlocks;
                if (!token.equals(finalToken)) continue;
                DynamicLeaf finalLeaf = new DynamicLeaf(this.tokens.tailMap(token));
                lastLeaf.next = finalLeaf;
                this.rightmostParent.add(finalLeaf);
                this.rightmostLeaf = finalLeaf;
                ++this.numBlocks;
            }
        }
    }

    private class DynamicLeaf
    extends AbstractTokenTreeBuilder.Leaf {
        private final SortedMap<Long, LongSet> tokens;

        DynamicLeaf(SortedMap<Long, LongSet> data) {
            super(data.firstKey(), data.lastKey());
            this.tokens = data;
        }

        @Override
        public int tokenCount() {
            return this.tokens.size();
        }

        @Override
        public boolean isSerializable() {
            return true;
        }

        @Override
        protected void serializeData(ByteBuffer buf) {
            for (Map.Entry<Long, LongSet> entry : this.tokens.entrySet()) {
                this.createEntry(entry.getKey(), entry.getValue()).serialize(buf);
            }
        }
    }
}

