/* Scanner for "C" assignment statements... sort of. */
/* Compile: reflex --flex --bison-locations --bison-bridge --header-file flexexample8.l */
/* Compile: bison -d -y flexexample8.y */
/* Example taken from Flex documentation A.2 */
/* Bison bridge passes yylval to yylex (which limits yylval's scope to the rule actions) */
/* Note: yylval is no longer a pointer in reentrant/bison-bridge lexer specifications but a reference for convenience */

%top{
#include "y.tab.h"  /* Generated by bison. */
#define YY_EXTERN_C extern "C" /* this is needed for yylex C linkage when compiling y.tab.c in C */
}

%option bison-locations bison-bridge noyywrap header-file

%%

[[:digit:]]+  { yylval.num = atoi(yytext);   return NUMBER; }
[[:alnum:]]+  { yylval.str = strdup(yytext); return STRING; }
"="|";"       { return yytext[0]; }
.|\n          {}

%%
