/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.InstanceStateChangeDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class StopInstances
extends BaseCmd {
    private static final String[] FORCE_DESC = new String[]{"Forcefully stops the instance."};

    public StopInstances(String[] args) {
        super("ec2stop", "ec2-stop-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"force");
        OptionBuilder.withDescription((String)StopInstances.joinDescription(FORCE_DESC));
        result.addOption(OptionBuilder.create((String)"f"));
        return result;
    }

    protected String getOptionString() {
        return "INSTANCE [INSTANCE [...]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Stop selected running instances.");
        System.out.println("     The INSTANCE parameter is an instance ID to stop.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("force");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("INSTANCE");
        String[] instanceIds = this.getNonOptions();
        boolean force = this.isOptionSet("force");
        RequestResultPair rsp = jec2.stopInstances(instanceIds, force);
        for (InstanceStateChangeDescription tid : (List)rsp.getResponse()) {
            out.output(System.out, tid);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new StopInstances(args).invoke();
    }
}

