#!/bin/sh
#
# Copyright (c) 2009-2018 Andreas Gustafsson.  All rights reserved.
# Please refer to the file COPYRIGHT for detailed copyright information.
#

. ./bracket.conf

module=${1:-src}

test -n "$rsync" || { echo "rsync not set in configuration" 2>&1; exit 1; }

date=$(date '+%Y%m%d-%H%M')
year=$(echo $date | cut -c 1-4)
ydir="$logdir/repo-update/$year"
mkdir -p $ydir
exec >>$ydir/rsync-$date.log 2>&1

# Add -c option to disregard timestamps and compare checksums instead
# Or -I?

(
    TZ=UTC
    cd $repo_root
    echo "start at `date`"
    date '+%s' >rsync_begin_stamp
    # In case of repo corruption, try adding --checksum
    time $rsync -v -a --delete --exclude '#cvs.lock' \
        --log-file "$db_dir/rsync.log" \
	rsync://anoncvs.NetBSD.org/cvsroot/$module . || exit 1
    echo "end at `date`"
    echo ""
) || exit 1
